/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ExpressionVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeBindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class FullConstraintCreator
extends ConstraintCreator {
    public ITypeConstraint[] create(ArrayInitializer arrayInitializer) {
        ITypeBinding arrayBinding = arrayInitializer.resolveTypeBinding();
        Assert.isTrue(arrayBinding.isArray());
        List expressions = arrayInitializer.expressions();
        ITypeConstraint[] constraints = new ITypeConstraint[expressions.size()];
        Type type = FullConstraintCreator.getTypeParent(arrayInitializer);
        TypeVariable typeVariable = new TypeVariable(type);
        int i = 0;
        while (i < constraints.length) {
            Expression each = (Expression)expressions.get(i);
            constraints[i] = SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(each), typeVariable);
            ++i;
        }
        return constraints;
    }

    public ITypeConstraint[] create(Assignment assignment) {
        return new ITypeConstraint[]{SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(assignment.getRightHandSide()), new ExpressionVariable(assignment.getLeftHandSide()))};
    }

    public ITypeConstraint[] create(CastExpression castExpression) {
        Expression expression = castExpression.getExpression();
        Type type = castExpression.getType();
        SimpleTypeConstraint definesConstraint = SimpleTypeConstraint.createDefinesConstraint(new ExpressionVariable((Expression)castExpression), new TypeVariable(castExpression.getType()));
        if (TypeBindings.isClassBinding(expression.resolveTypeBinding()) && TypeBindings.isClassBinding(type.resolveBinding())) {
            ExpressionVariable expressionVariable = new ExpressionVariable(expression);
            ExpressionVariable castExpressionVariable = new ExpressionVariable((Expression)castExpression);
            return new ITypeConstraint[]{definesConstraint, FullConstraintCreator.createOrOrSubtypeConstraint(expressionVariable, castExpressionVariable)};
        }
        return new ITypeConstraint[]{definesConstraint};
    }

    public ITypeConstraint[] create(ClassInstanceCreation instanceCreation) {
        List arguments = instanceCreation.arguments();
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>(arguments.size());
        IMethodBinding methodBinding = instanceCreation.resolveConstructorBinding();
        result.addAll(Arrays.asList(FullConstraintCreator.getArgumentConstraints(arguments, methodBinding)));
        if (instanceCreation.getAnonymousClassDeclaration() == null) {
            ExpressionVariable constructorVar = new ExpressionVariable((Expression)instanceCreation);
            RawBindingVariable typeVar = new RawBindingVariable(instanceCreation.resolveTypeBinding());
            result.add(SimpleTypeConstraint.createDefinesConstraint(constructorVar, typeVar));
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ConstructorInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>(arguments.size());
        IMethodBinding methodBinding = invocation.resolveConstructorBinding();
        result.addAll(Arrays.asList(FullConstraintCreator.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(FieldAccess access) {
        Expression expression = access.getExpression();
        SimpleName name = access.getName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding vb = (IVariableBinding)binding;
        return FullConstraintCreator.createConstraintsForAccessToField(vb, expression, (Expression)access);
    }

    public ITypeConstraint[] create(FieldDeclaration fd) {
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>();
        result.addAll(Arrays.asList(FullConstraintCreator.getConstraintsFromFragmentList(fd.fragments(), fd.getType())));
        result.addAll(FullConstraintCreator.getConstraintsForHiding(fd));
        result.addAll(FullConstraintCreator.getConstraintsForFieldDeclaringTypes(fd));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(InstanceofExpression instanceofExpression) {
        Expression expression = instanceofExpression.getLeftOperand();
        Type type = instanceofExpression.getRightOperand();
        if (TypeBindings.isClassBinding(expression.resolveTypeBinding()) && TypeBindings.isClassBinding(type.resolveBinding())) {
            ExpressionVariable expressionVar = new ExpressionVariable(expression);
            TypeVariable typeVariable = new TypeVariable(type);
            return new ITypeConstraint[]{FullConstraintCreator.createOrOrSubtypeConstraint(expressionVar, typeVariable)};
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(MethodDeclaration declaration) {
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>(declaration.parameters().size());
        IMethodBinding methodBinding = declaration.resolveBinding();
        if (methodBinding == null) {
            return new ITypeConstraint[0];
        }
        result.add(SimpleTypeConstraint.createDefinesConstraint(new DeclaringTypeVariable(methodBinding), new RawBindingVariable(methodBinding.getDeclaringClass())));
        if (!methodBinding.isConstructor() && !methodBinding.getReturnType().isPrimitive()) {
            ReturnTypeVariable returnTypeBindingVariable = new ReturnTypeVariable(methodBinding);
            TypeVariable returnTypeVariable = new TypeVariable(declaration.getReturnType());
            SimpleTypeConstraint defines = SimpleTypeConstraint.createDefinesConstraint(returnTypeBindingVariable, returnTypeVariable);
            result.add(defines);
        }
        int i = 0;
        int n = declaration.parameters().size();
        while (i < n) {
            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)declaration.parameters().get(i);
            ParameterTypeVariable parameterTypeVariable = new ParameterTypeVariable(methodBinding, i);
            ExpressionVariable parameterNameVariable = new ExpressionVariable((Expression)paramDecl.getName());
            SimpleTypeConstraint constraint = SimpleTypeConstraint.createDefinesConstraint(parameterTypeVariable, parameterNameVariable);
            result.add(constraint);
            ++i;
        }
        if (MethodChecks.isVirtual(methodBinding)) {
            result.addAll(FullConstraintCreator.getConstraintsForOverriding(methodBinding));
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ParenthesizedExpression node) {
        ExpressionVariable v1 = new ExpressionVariable((Expression)node);
        ExpressionVariable v2 = new ExpressionVariable(node.getExpression());
        SimpleTypeConstraint equal = SimpleTypeConstraint.createEqualsConstraint(v1, v2);
        return new ITypeConstraint[]{equal};
    }

    public ITypeConstraint[] create(MethodInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>(arguments.size());
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return new ITypeConstraint[0];
        }
        ITypeConstraint returnTypeConstraint = FullConstraintCreator.getReturnTypeConstraint((Expression)invocation, methodBinding);
        if (returnTypeConstraint != null) {
            result.add(returnTypeConstraint);
        }
        result.addAll(Arrays.asList(FullConstraintCreator.getArgumentConstraints(arguments, methodBinding)));
        if (invocation.getExpression() != null) {
            if (MethodChecks.isVirtual(methodBinding)) {
                IMethodBinding[] rootDefs = FullConstraintCreator.getRootDefs(methodBinding);
                ExpressionVariable expressionVar = new ExpressionVariable(invocation.getExpression());
                if (rootDefs.length == 1) {
                    result.add(SimpleTypeConstraint.createSubtypeConstraint(expressionVar, new DeclaringTypeVariable(rootDefs[0])));
                } else {
                    ITypeConstraint[] constraints = new ITypeConstraint[rootDefs.length];
                    int i = 0;
                    while (i < rootDefs.length) {
                        DeclaringTypeVariable rootDefTypeVar = new DeclaringTypeVariable(rootDefs[i]);
                        constraints[i] = SimpleTypeConstraint.createSubtypeConstraint(expressionVar, rootDefTypeVar);
                        ++i;
                    }
                    result.add(new CompositeOrTypeConstraint(constraints));
                }
            } else {
                DeclaringTypeVariable typeVar = new DeclaringTypeVariable(methodBinding);
                ExpressionVariable expressionVar = new ExpressionVariable(invocation.getExpression());
                result.add(SimpleTypeConstraint.createSubtypeConstraint(expressionVar, typeVar));
            }
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(QualifiedName qualifiedName) {
        IVariableBinding vb;
        SimpleName name = qualifiedName.getName();
        Name qualifier = qualifiedName.getQualifier();
        IBinding nameBinding = name.resolveBinding();
        if (nameBinding instanceof IVariableBinding && (vb = (IVariableBinding)nameBinding).isField()) {
            return FullConstraintCreator.createConstraintsForAccessToField(vb, (Expression)qualifier, (Expression)qualifiedName);
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(ReturnStatement returnStatement) {
        if (returnStatement.getExpression() == null) {
            return new ITypeConstraint[0];
        }
        ReturnTypeVariable returnTypeVariable = new ReturnTypeVariable(returnStatement);
        SimpleTypeConstraint c = SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(returnStatement.getExpression()), returnTypeVariable);
        return new ITypeConstraint[]{c};
    }

    public ITypeConstraint[] create(SingleVariableDeclaration svd) {
        SimpleTypeConstraint defines = SimpleTypeConstraint.createDefinesConstraint(new ExpressionVariable((Expression)svd.getName()), new TypeVariable(svd.getType()));
        if (svd.getInitializer() == null) {
            return new ITypeConstraint[]{defines};
        }
        ITypeConstraint[] result = new ITypeConstraint[]{SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(svd.getInitializer()), new ExpressionVariable((Expression)svd.getName())), defines};
        return result;
    }

    public ITypeConstraint[] create(SuperConstructorInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>(arguments.size());
        IMethodBinding methodBinding = invocation.resolveConstructorBinding();
        result.addAll(Arrays.asList(FullConstraintCreator.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(SuperFieldAccess access) {
        SimpleName name = access.getName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding vb = (IVariableBinding)binding;
        return FullConstraintCreator.createConstraintsForAccessToField(vb, null, (Expression)access);
    }

    public ITypeConstraint[] create(SuperMethodInvocation invocation) {
        List arguments = invocation.arguments();
        ArrayList<ITypeConstraint> result = new ArrayList<ITypeConstraint>(arguments.size());
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        ITypeConstraint returnTypeConstraint = FullConstraintCreator.getReturnTypeConstraint((Expression)invocation, methodBinding);
        if (returnTypeConstraint != null) {
            result.add(returnTypeConstraint);
        }
        result.addAll(Arrays.asList(FullConstraintCreator.getArgumentConstraints(arguments, methodBinding)));
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    public ITypeConstraint[] create(ThisExpression expression) {
        ExpressionVariable thisExpression = new ExpressionVariable((Expression)expression);
        RawBindingVariable declaringType = new RawBindingVariable(expression.resolveTypeBinding());
        return new ITypeConstraint[]{SimpleTypeConstraint.createDefinesConstraint(thisExpression, declaringType)};
    }

    public ITypeConstraint[] create(VariableDeclarationExpression vde) {
        return FullConstraintCreator.getConstraintsFromFragmentList(vde.fragments(), vde.getType());
    }

    public ITypeConstraint[] create(VariableDeclarationFragment vdf) {
        if (vdf.getInitializer() == null) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(vdf.getInitializer()), new ExpressionVariable((Expression)vdf.getName()))};
    }

    public ITypeConstraint[] create(VariableDeclarationStatement vds) {
        return FullConstraintCreator.getConstraintsFromFragmentList(vds.fragments(), vds.getType());
    }

    private static Collection getConstraintsForFieldDeclaringTypes(FieldDeclaration fd) {
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>(fd.fragments().size());
        Iterator iter = fd.fragments().iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment varDecl = (VariableDeclarationFragment)iter.next();
            IVariableBinding binding = varDecl.resolveBinding();
            Assert.isTrue(binding.isField());
            result.add(SimpleTypeConstraint.createDefinesConstraint(new DeclaringTypeVariable(binding), new RawBindingVariable(binding.getDeclaringClass())));
        }
        return result;
    }

    private static Collection getConstraintsForHiding(FieldDeclaration fd) {
        ArrayList result = new ArrayList();
        Iterator iter = fd.fragments().iterator();
        while (iter.hasNext()) {
            result.addAll(FullConstraintCreator.getConstraintsForHiding((VariableDeclarationFragment)iter.next()));
        }
        return result;
    }

    private static Collection getConstraintsForHiding(VariableDeclarationFragment fragment) {
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>();
        IVariableBinding fieldBinding = fragment.resolveBinding();
        Assert.isTrue(fieldBinding.isField());
        Set declaringTypes = FullConstraintCreator.getDeclaringSuperTypes(fieldBinding);
        DeclaringTypeVariable hiddingFieldVar = new DeclaringTypeVariable(fieldBinding);
        Iterator iter = declaringTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding declaringSuperType = (ITypeBinding)iter.next();
            IVariableBinding hiddenField = FullConstraintCreator.findField(fieldBinding, declaringSuperType);
            Assert.isTrue(hiddenField.isField());
            DeclaringTypeVariable hiddenFieldVar = new DeclaringTypeVariable(hiddenField);
            result.add(SimpleTypeConstraint.createStrictSubtypeConstraint(hiddingFieldVar, hiddenFieldVar));
        }
        return result;
    }

    private static ITypeConstraint[] getConstraintsFromFragmentList(List fragments, Type type) {
        int size = fragments.size();
        TypeVariable typeVariable = new TypeVariable(type);
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>(size * (size - 1) / 2);
        int i = 0;
        while (i < size) {
            VariableDeclarationFragment fragment1 = (VariableDeclarationFragment)fragments.get(i);
            SimpleName fragment1Name = fragment1.getName();
            result.add(SimpleTypeConstraint.createDefinesConstraint(new ExpressionVariable((Expression)fragment1Name), typeVariable));
            int j = i + 1;
            while (j < size) {
                VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fragments.get(j);
                result.add(SimpleTypeConstraint.createEqualsConstraint(new ExpressionVariable((Expression)fragment1Name), new ExpressionVariable((Expression)fragment2.getName())));
                ++j;
            }
            ++i;
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    private static Collection getConstraintsForOverriding(IMethodBinding overriddingMethod) {
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>();
        Set declaringSupertypes = FullConstraintCreator.getDeclaringSuperTypes(overriddingMethod);
        Iterator iter = declaringSupertypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding superType = (ITypeBinding)iter.next();
            IMethodBinding overriddenMethod = FullConstraintCreator.findMethod(overriddingMethod, superType);
            Assert.isNotNull(overriddenMethod);
            SimpleTypeConstraint returnTypeConstraint = SimpleTypeConstraint.createEqualsConstraint(new ReturnTypeVariable(overriddenMethod), new ReturnTypeVariable(overriddingMethod));
            result.add(returnTypeConstraint);
            Assert.isTrue(overriddenMethod.getParameterTypes().length == overriddingMethod.getParameterTypes().length);
            int i = 0;
            int n = overriddenMethod.getParameterTypes().length;
            while (i < n) {
                SimpleTypeConstraint parameterTypeConstraint = SimpleTypeConstraint.createEqualsConstraint(new ParameterTypeVariable(overriddenMethod, i), new ParameterTypeVariable(overriddingMethod, i));
                result.add(parameterTypeConstraint);
                ++i;
            }
            SimpleTypeConstraint declaringTypeConstraint = SimpleTypeConstraint.createStrictSubtypeConstraint(new DeclaringTypeVariable(overriddingMethod), new DeclaringTypeVariable(overriddenMethod));
            result.add(declaringTypeConstraint);
        }
        return result;
    }

    private static ITypeConstraint getReturnTypeConstraint(Expression invocation, IMethodBinding methodBinding) {
        if (methodBinding == null || methodBinding.isConstructor() || methodBinding.getReturnType().isPrimitive()) {
            return null;
        }
        ReturnTypeVariable returnTypeVariable = new ReturnTypeVariable(methodBinding);
        ExpressionVariable invocationVariable = new ExpressionVariable(invocation);
        return SimpleTypeConstraint.createDefinesConstraint(invocationVariable, returnTypeVariable);
    }

    private static ITypeConstraint[] getArgumentConstraints(List arguments, IMethodBinding methodBinding) {
        ArrayList<SimpleTypeConstraint> result = new ArrayList<SimpleTypeConstraint>(arguments.size());
        int i = 0;
        int n = arguments.size();
        while (i < n) {
            Expression argument = (Expression)arguments.get(i);
            ExpressionVariable expressionVariable = new ExpressionVariable(argument);
            ParameterTypeVariable parameterTypeVariable = new ParameterTypeVariable(methodBinding, i);
            SimpleTypeConstraint argConstraint = SimpleTypeConstraint.createSubtypeConstraint(expressionVariable, parameterTypeVariable);
            result.add(argConstraint);
            ++i;
        }
        return result.toArray(new ITypeConstraint[result.size()]);
    }

    private static Type getTypeParent(ArrayInitializer arrayInitializer) {
        if (arrayInitializer.getParent() instanceof ArrayCreation) {
            return ((ArrayCreation)arrayInitializer.getParent()).getType().getElementType();
        }
        if (arrayInitializer.getParent() instanceof ArrayInitializer) {
            return FullConstraintCreator.getTypeParent((ArrayInitializer)arrayInitializer.getParent());
        }
        if (arrayInitializer.getParent() instanceof VariableDeclaration) {
            VariableDeclaration parent = (VariableDeclaration)arrayInitializer.getParent();
            if (parent.getParent() instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (parent.getParent() instanceof VariableDeclarationExpression) {
                Type type = ((VariableDeclarationExpression)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (parent.getParent() instanceof FieldDeclaration) {
                Type type = ((FieldDeclaration)parent.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static ITypeConstraint createOrOrSubtypeConstraint(ConstraintVariable var1, ConstraintVariable var2) {
        SimpleTypeConstraint c1 = SimpleTypeConstraint.createSubtypeConstraint(var1, var2);
        SimpleTypeConstraint c2 = SimpleTypeConstraint.createSubtypeConstraint(var2, var1);
        return new CompositeOrTypeConstraint(new ITypeConstraint[]{c1, c2});
    }

    private static ITypeConstraint[] createConstraintsForAccessToField(IVariableBinding fieldBinding, Expression qualifier, Expression accessExpression) {
        Assert.isTrue(fieldBinding.isField());
        SimpleTypeConstraint defines = SimpleTypeConstraint.createDefinesConstraint(new ExpressionVariable(accessExpression), new RawBindingVariable(fieldBinding.getType()));
        if (qualifier == null) {
            return new ITypeConstraint[]{defines};
        }
        DeclaringTypeVariable declaringTypeVar = new DeclaringTypeVariable(fieldBinding);
        SimpleTypeConstraint subType = SimpleTypeConstraint.createSubtypeConstraint(new ExpressionVariable(qualifier), declaringTypeVar);
        return new ITypeConstraint[]{defines, subType};
    }

    private static IVariableBinding findField(IVariableBinding fieldBinding, ITypeBinding type) {
        if (fieldBinding.getDeclaringClass().equals((Object)type)) {
            return fieldBinding;
        }
        return Bindings.findFieldInType(type, fieldBinding.getName());
    }

    private static Set getDeclaringSuperTypes(IVariableBinding fieldBinding) {
        Set allSuperTypes = TypeBindings.getSuperTypes(fieldBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        Iterator iter = allSuperTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding type = (ITypeBinding)iter.next();
            if (FullConstraintCreator.findField(fieldBinding, type) == null) continue;
            result.add(type);
        }
        return result;
    }

    private static IMethodBinding[] getRootDefs(IMethodBinding methodBinding) {
        Set declaringSuperTypes = FullConstraintCreator.getDeclaringSuperTypes(methodBinding);
        declaringSuperTypes.add(methodBinding.getDeclaringClass());
        HashSet<IMethodBinding> result = new HashSet<IMethodBinding>();
        Iterator iter = declaringSuperTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding type = (ITypeBinding)iter.next();
            if (FullConstraintCreator.containsASuperType(type, declaringSuperTypes)) continue;
            result.add(FullConstraintCreator.findMethod(methodBinding, type));
        }
        return result.toArray(new IMethodBinding[result.size()]);
    }

    private static boolean containsASuperType(ITypeBinding type, Set declaringSuperTypes) {
        Iterator iter = declaringSuperTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding maybeSuperType = (ITypeBinding)iter.next();
            if (!TypeBindings.isSubtypeBindingOf(type, maybeSuperType)) continue;
            return true;
        }
        return false;
    }

    private static Set getDeclaringSuperTypes(IMethodBinding methodBinding) {
        Set allSuperTypes = TypeBindings.getSuperTypes(methodBinding.getDeclaringClass());
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        Iterator iter = allSuperTypes.iterator();
        while (iter.hasNext()) {
            ITypeBinding type = (ITypeBinding)iter.next();
            if (FullConstraintCreator.findMethod(methodBinding, type) == null) continue;
            result.add(type);
        }
        return result;
    }

    private static IMethodBinding findMethod(IMethodBinding methodBinding, ITypeBinding type) {
        if (methodBinding.getDeclaringClass().equals((Object)type)) {
            return methodBinding;
        }
        return Bindings.findMethodInType(type, methodBinding.getName(), methodBinding.getParameterTypes());
    }
}

