/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public class DeclaringTypeVariable
extends ConstraintVariable {
    private final IBinding fBinding;

    protected DeclaringTypeVariable(ITypeBinding memberTypeBinding) {
        super(memberTypeBinding.getDeclaringClass());
        this.fBinding = memberTypeBinding;
    }

    protected DeclaringTypeVariable(IVariableBinding fieldBinding) {
        super(fieldBinding.getDeclaringClass());
        Assert.isTrue(fieldBinding.isField());
        this.fBinding = fieldBinding;
    }

    protected DeclaringTypeVariable(IMethodBinding methodBinding) {
        super(methodBinding.getDeclaringClass());
        this.fBinding = methodBinding;
    }

    public String toString() {
        return "Decl(" + Bindings.asString(this.fBinding) + ")";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DeclaringTypeVariable)) {
            return false;
        }
        DeclaringTypeVariable other = (DeclaringTypeVariable)obj;
        return Bindings.equals(this.fBinding, other.fBinding);
    }

    public int hashCode() {
        return super.hashCode() ^ this.fBinding.hashCode();
    }
}

