/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.TypeBindings;

public abstract class ConstraintVariable {
    private final ITypeBinding fBinding;

    protected ConstraintVariable(ITypeBinding binding) {
        this.fBinding = binding;
    }

    public boolean isEqualType(ConstraintVariable other) {
        return this.isEqualBinding(other.fBinding);
    }

    public boolean isStrictSubtypeOf(ConstraintVariable other) {
        return TypeBindings.isSubtypeBindingOf(this.fBinding, other.fBinding);
    }

    public boolean isSubtypeOf(ConstraintVariable other) {
        return this.isEqualType(other) || this.isStrictSubtypeOf(other);
    }

    public boolean isEqualBinding(ITypeBinding binding) {
        return TypeBindings.isEqualTo(this.fBinding, binding);
    }

    public String toResolvedString() {
        return TypeBindings.toString(this.fBinding);
    }

    public String toString() {
        return TypeBindings.toString(this.fBinding);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstraintVariable)) {
            return false;
        }
        ConstraintVariable other = (ConstraintVariable)obj;
        return TypeBindings.isEqualTo(this.fBinding, other.fBinding);
    }

    public int hashCode() {
        if (this.fBinding == null) {
            return super.hashCode();
        }
        return Bindings.hashCode((IBinding)this.fBinding);
    }

    public ITypeBinding getBinding() {
        return this.fBinding;
    }
}

