/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public class CompositeOrTypeConstraint
implements ITypeConstraint {
    private final ITypeConstraint[] fConstraints;

    public CompositeOrTypeConstraint(ITypeConstraint[] constraints) {
        Assert.isNotNull(constraints);
        this.fConstraints = CompositeOrTypeConstraint.sort(CompositeOrTypeConstraint.getCopy(constraints));
    }

    private static ITypeConstraint[] getCopy(ITypeConstraint[] constraints) {
        List<ITypeConstraint> l = Arrays.asList(constraints);
        return l.toArray(new ITypeConstraint[l.size()]);
    }

    private static ITypeConstraint[] sort(ITypeConstraint[] constraints) {
        Arrays.sort(constraints, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o2.toString().compareTo(o1.toString());
            }
        });
        return constraints;
    }

    public String toResolvedString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fConstraints.length) {
            ITypeConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toResolvedString());
            ++i;
        }
        return buff.toString();
    }

    public boolean isSimpleTypeConstraint() {
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fConstraints.length) {
            ITypeConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toString());
            ++i;
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeOrTypeConstraint)) {
            return false;
        }
        CompositeOrTypeConstraint other = (CompositeOrTypeConstraint)obj;
        if (this.fConstraints.length != other.fConstraints.length) {
            return false;
        }
        int i = 0;
        while (i < this.fConstraints.length) {
            if (!this.fConstraints[i].equals(other.fConstraints[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.fConstraints.length) {
            hashCode ^= this.fConstraints[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public ITypeConstraint[] getConstraints() {
        return this.fConstraints;
    }
}

