/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    private Selection fSelection;
    private CodeGenerationSettings fSettings;
    private ISurroundWithTryCatchQuery fQuery;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fSaveChanges;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode fSelectedNode;
    private List fStatementsOfSelectedNode;
    private List fTryBody;

    private SurroundWithTryCatchRefactoring(ICompilationUnit cu, Selection selection, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fSettings = settings;
        this.fQuery = query;
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, ITextSelection selection, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(selection.getOffset(), selection.getLength()), settings, query);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(offset, length), settings, query);
    }

    public void setSaveChanges(boolean saveChanges) {
        this.fSaveChanges = saveChanges;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SurroundWithTryCatchRefactoring.name");
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection, this.fQuery);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        CompilationUnit rootNode = AST.parseCompilationUnit((ICompilationUnit)this.fCUnit, (boolean)true);
        return this.checkActivationBasics(rootNode, pm);
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompilationUnitChange compilationUnitChange;
        TextBuffer buffer = null;
        try {
            try {
                CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
                result.setSave(this.fSaveChanges);
                MultiTextEdit root = new MultiTextEdit();
                result.setEdit((TextEdit)root);
                buffer = TextBuffer.acquire(this.getFile());
                ASTNodes.expandRange(this.fAnalyzer.getSelectedNodes(), buffer, this.fSelection.getOffset(), this.fSelection.getLength());
                this.fRewriter = new ASTRewrite((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
                this.fImportRewrite = new ImportRewrite(this.fCUnit, this.fSettings);
                this.fScope = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
                this.fScope.setCursor(this.fSelection.getOffset());
                this.computeTargetNode();
                this.fTryBody = new ArrayList(2);
                List newStatements = this.createLocals();
                newStatements.add(this.createTryCatchStatement(buffer.getLineDelimiter()));
                if (newStatements.size() == 1) {
                    this.fRewriter.markAsReplaced(this.fSelectedNode, (ASTNode)newStatements.get(0));
                } else {
                    List container = this.getSelectedNodeContainer();
                    if (this.selectedNodeIsDeclaration()) {
                        int index = container.indexOf(this.fSelectedNode);
                        Iterator iter = newStatements.iterator();
                        while (iter.hasNext()) {
                            ASTNode element = (ASTNode)iter.next();
                            this.fRewriter.markAsInserted(element);
                            container.add(++index, element);
                        }
                    } else if (newStatements.isEmpty()) {
                        this.fRewriter.markAsRemoved(this.fSelectedNode);
                    } else {
                        Statement[] collapsedTargetStatements = newStatements.toArray(new Statement[newStatements.size()]);
                        this.fRewriter.markAsReplaced(this.fSelectedNode, (ASTNode)this.fRewriter.getCollapseTargetPlaceholder(collapsedTargetStatements));
                    }
                }
                if (!this.fImportRewrite.isEmpty()) {
                    TextEdit edit = this.fImportRewrite.createEdit(buffer);
                    root.addChild(edit);
                    result.addGroupDescription(new GroupDescription("", new TextEdit[]{edit}));
                }
                MultiTextEdit change = new MultiTextEdit();
                this.fRewriter.rewriteNode(buffer, (TextEdit)change);
                root.addChild((TextEdit)change);
                result.addGroupDescription(new GroupDescription("", new TextEdit[]{change}));
                compilationUnitChange = result;
                Object var10_14 = null;
                this.fRewriter.removeModifications();
                if (buffer == null) return compilationUnitChange;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.fRewriter.removeModifications();
            if (buffer == null) throw throwable;
            TextBuffer.release(buffer);
            throw throwable;
        }
        TextBuffer.release(buffer);
        return compilationUnitChange;
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void computeTargetNode() {
        ASTNode[] nodes = this.fAnalyzer.getSelectedNodes();
        if (nodes.length == 1) {
            this.fSelectedNode = nodes[0];
        } else {
            List container = ASTNodes.getContainingList(nodes[0]);
            this.fSelectedNode = this.fRewriter.collapseNodes(container, container.indexOf(nodes[0]), nodes.length);
        }
    }

    private List getStatementsOfSelectedNode() {
        if (this.fStatementsOfSelectedNode != null) {
            return this.fStatementsOfSelectedNode;
        }
        if (this.fRewriter.isCollapsed(this.fSelectedNode)) {
            this.fStatementsOfSelectedNode = ((Block)this.fSelectedNode).statements();
        } else {
            this.fStatementsOfSelectedNode = ASTNodes.getContainingList(this.fSelectedNode);
            if (this.fStatementsOfSelectedNode == null) {
                Block block = this.getAST().newBlock();
                this.fStatementsOfSelectedNode = block.statements();
                this.fStatementsOfSelectedNode.add(this.fRewriter.createCopy(this.fSelectedNode));
                this.fRewriter.markAsRemoved(this.fSelectedNode);
            }
        }
        return this.fStatementsOfSelectedNode;
    }

    private List getSelectedNodeContainer() {
        List result = ASTNodes.getContainingList(this.fSelectedNode);
        if (result != null) {
            return result;
        }
        return this.getStatementsOfSelectedNode();
    }

    private List createLocals() {
        ArrayList result = new ArrayList(3);
        ArrayList<VariableDeclaration> locals = new ArrayList<VariableDeclaration>(Arrays.asList(this.fAnalyzer.getAffectedLocals()));
        if (locals.size() > 0) {
            VariableDeclarationStatement[] statements = this.getStatements(locals);
            int i = 0;
            while (i < statements.length) {
                VariableDeclarationStatement st = statements[i];
                result.addAll(this.handle(st, locals));
                ++i;
            }
        }
        return result;
    }

    private VariableDeclarationStatement[] getStatements(List locals) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(locals.size());
        int i = 0;
        while (i < locals.size()) {
            ASTNode parent = ((ASTNode)locals.get(i)).getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++i;
        }
        return result.toArray(new VariableDeclarationStatement[result.size()]);
    }

    private List handle(VariableDeclarationStatement statement, List locals) {
        boolean isSelectedNode = statement == this.fSelectedNode;
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        List fragments = statement.fragments();
        result.add(this.fRewriter.createCopy((ASTNode)statement));
        AST ast = this.getAST();
        ArrayList<ExpressionStatement> newAssignments = new ArrayList<ExpressionStatement>(2);
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            Expression initializer = fragment.getInitializer();
            if (initializer == null) continue;
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)fragment.getName()));
            assignment.setRightHandSide((Expression)this.fRewriter.createCopy((ASTNode)initializer));
            this.fRewriter.markAsRemoved((ASTNode)initializer);
            ExpressionStatement es = ast.newExpressionStatement((Expression)assignment);
            if (isSelectedNode) {
                this.fTryBody.add(es);
                continue;
            }
            newAssignments.add(es);
        }
        if (newAssignments.isEmpty()) {
            this.fRewriter.markAsRemoved((ASTNode)statement);
        } else {
            Statement[] collapsedTargetStatements = newAssignments.toArray(new Statement[newAssignments.size()]);
            this.fRewriter.markAsReplaced((ASTNode)statement, (ASTNode)this.fRewriter.getCollapseTargetPlaceholder(collapsedTargetStatements));
        }
        return result;
    }

    private TryStatement createTryCatchStatement(String lineDelimiter) throws CoreException {
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            String type = this.fImportRewrite.addImport(exception);
            CatchClause catchClause = this.getAST().newCatchClause();
            tryStatement.catchClauses().add(catchClause);
            SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
            String varName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.exception.name");
            String name = this.fScope.createName(varName, false);
            decl.setName(this.getAST().newSimpleName(name));
            decl.setType(ASTNodeFactory.newType(this.getAST(), type));
            catchClause.setException(decl);
            Statement st = this.getCatchBody(type, name, lineDelimiter);
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            ++i;
        }
        List statements = tryStatement.getBody().statements();
        if (this.selectedNodeIsDeclaration()) {
            statements.addAll(this.fTryBody);
        } else {
            statements.add(this.fRewriter.createCopy(this.fSelectedNode));
        }
        return tryStatement;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createPlaceholder(s, 4);
    }

    private IFile getFile() throws JavaModelException {
        return (IFile)JavaModelUtil.toOriginal(this.fCUnit).getResource();
    }

    private boolean selectedNodeIsDeclaration() {
        return this.fTryBody.size() > 0;
    }
}

