/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.surround.ExceptionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.LocalDeclarationAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.CodeAnalyzer;

public class SurroundWithTryCatchAnalyzer
extends CodeAnalyzer {
    private ISurroundWithTryCatchQuery fQuery;
    private ITypeBinding[] fExceptions;
    private VariableDeclaration[] fLocals;
    static /* synthetic */ Class class$0;

    public SurroundWithTryCatchAnalyzer(ICompilationUnit unit, Selection selection, ISurroundWithTryCatchQuery query) throws JavaModelException {
        super(unit, selection, false);
        this.fQuery = query;
    }

    public ITypeBinding[] getExceptions() {
        return this.fExceptions;
    }

    public VariableDeclaration[] getAffectedLocals() {
        return this.fLocals;
    }

    public BodyDeclaration getEnclosingBodyDeclaration() {
        ASTNode node = this.getFirstSelectedNode();
        if (node == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.BodyDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BodyDeclaration)ASTNodes.getParent(node, clazz);
    }

    protected boolean handleSelectionEndsIn(ASTNode node) {
        return true;
    }

    public void endVisit(CompilationUnit node) {
        this.postProcessSelectedNodes(this.internalGetSelectedNodes());
        BodyDeclaration enclosingNode = null;
        if (!this.getStatus().hasFatalError()) {
            if (!this.hasSelectedNodes()) {
                Block block;
                Message[] messages;
                ASTNode coveringNode = this.getLastCoveringNode();
                if (coveringNode instanceof Block && (messages = ASTNodes.getMessages((ASTNode)(block = (Block)coveringNode), 0)).length > 0) {
                    this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.compile_errors"), JavaStatusContext.create(this.getCompilationUnit(), (ASTNode)block));
                } else {
                    this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.doesNotCover"));
                }
            } else {
                ASTNode aSTNode = this.getFirstSelectedNode();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.BodyDeclaration;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((enclosingNode = (BodyDeclaration)ASTNodes.getParent(aSTNode, clazz)) instanceof MethodDeclaration) && !(enclosingNode instanceof Initializer)) {
                    this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.doesNotContain"));
                } else {
                    if (!this.onlyStatements()) {
                        this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.onlyStatements"));
                    }
                    this.fLocals = LocalDeclarationAnalyzer.perform(enclosingNode, this.getSelection());
                }
            }
        }
        super.endVisit(node);
        if (enclosingNode != null && !this.getStatus().hasFatalError()) {
            this.fExceptions = ExceptionAnalyzer.perform(enclosingNode, this.getSelection());
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                if (this.fQuery == null) {
                    this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.noUncaughtExceptions"));
                } else if (this.fQuery.catchRuntimeException()) {
                    this.fExceptions = new ITypeBinding[]{node.getAST().resolveWellKnownType("java.lang.RuntimeException")};
                }
            }
        }
    }

    public void endVisit(SuperConstructorInvocation node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.cannotHandleSuper"), JavaStatusContext.create(this.fCUnit, (ASTNode)node));
        }
        super.endVisit(node);
    }

    public void endVisit(ConstructorInvocation node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.getString("SurroundWithTryCatchAnalyzer.cannotHandleThis"), JavaStatusContext.create(this.fCUnit, (ASTNode)node));
        }
        super.endVisit(node);
    }

    protected void postProcessSelectedNodes(List selectedNodes) {
        ASTNode node;
        if (selectedNodes == null || selectedNodes.size() == 0) {
            return;
        }
        if (selectedNodes.size() == 1 && (node = (ASTNode)selectedNodes.get(0)) instanceof Expression && node.getParent() instanceof ExpressionStatement) {
            selectedNodes.clear();
            selectedNodes.add(node.getParent());
        }
    }

    private boolean onlyStatements() {
        ASTNode[] nodes = this.getSelectedNodes();
        int i = 0;
        while (i < nodes.length) {
            if (!(nodes[i] instanceof Statement)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

