/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.RefactoringWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class UseSupertypeWherePossibleRefactoring
extends Refactoring {
    private IType fInputType;
    private TextChangeManager fChangeManager;
    private IType fSuperTypeToUse;
    private IType[] fSuperTypes;
    private boolean fUseSupertypeInInstanceOf;
    private CodeGenerationSettings fCodeGenerationSettings;

    private UseSupertypeWherePossibleRefactoring(IType clazz, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(codeGenerationSettings);
        this.fInputType = clazz;
        this.fUseSupertypeInInstanceOf = false;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public static UseSupertypeWherePossibleRefactoring create(IType type, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!UseSupertypeWherePossibleRefactoring.isAvailable(type)) {
            return null;
        }
        return new UseSupertypeWherePossibleRefactoring(type, codeGenerationSettings);
    }

    public static boolean isAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !type.isAnonymous();
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public void setUseSupertypeInInstanceOf(boolean use) {
        this.fUseSupertypeInInstanceOf = use;
    }

    public boolean getUseSupertypeInInstanceOf() {
        return this.fUseSupertypeInInstanceOf;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fInputType);
        if (orig == null || !orig.exists()) {
            String[] keys = new String[]{this.fInputType.getCompilationUnit().getElementName()};
            String message = RefactoringCoreMessages.getFormattedString("UseSupertypeWherePossibleRefactoring.deleted", keys);
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fInputType = orig;
        this.fSuperTypes = this.getSuperTypes(pm);
        if (Checks.isException(this.fInputType, pm)) {
            String message = RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.unavailable_on_Throwable");
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        return Checks.checkIfCuBroken((IMember)this.fInputType);
    }

    private IType[] getSuperTypes(IProgressMonitor pm) throws JavaModelException {
        return JavaModelUtil.getAllSuperTypes(this.fInputType, pm);
    }

    public IType[] getSuperTypes() throws JavaModelException {
        return this.fSuperTypes;
    }

    public void setSuperTypeToUse(IType superType) {
        Assert.isNotNull(superType);
        this.fSuperTypeToUse = superType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block7: {
            RefactoringStatus refactoringStatus2;
            block6: {
                pm.beginTask("", 1);
                try {
                    try {
                        RefactoringStatus result = new RefactoringStatus();
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            Object var3_7 = null;
                            break block6;
                        }
                        result.merge(this.validateModifiesFiles());
                        refactoringStatus = result;
                        break block7;
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        pm.beginTask("", 1);
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name");
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 1);
            pm.setTaskName(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.analyzing..."));
            TextChangeManager manager = new TextChangeManager();
            this.updateReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            textChangeManager = manager;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateReferences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        try {
            ExtractInterfaceUtil.updateReferences(manager, this.fInputType, this.fSuperTypeToUse, new RefactoringWorkingCopyOwner(), true, (IProgressMonitor)new SubProgressMonitor(pm, 1), status, this.fCodeGenerationSettings);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        pm.done();
    }
}

