/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultCollector;

public class ReferenceFinderUtil {
    private ReferenceFinderUtil() {
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchResult[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, pm);
        Set referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    private static SearchResult[] getTypeReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedFields = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedFields.addAll(ReferenceFinderUtil.getTypeReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedFields.toArray(new SearchResult[referencedFields.size()]);
    }

    private static List getTypeReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        SearchResultCollector collector = new SearchResultCollector(pm);
        new SearchEngine().searchDeclarationsOfReferencedTypes(ResourcesPlugin.getWorkspace(), element, (IJavaSearchResultCollector)collector);
        return collector.getResults();
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchResult[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, pm);
        Set referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    private static SearchResult[] getFieldReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedFields = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedFields.addAll(ReferenceFinderUtil.getFieldReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedFields.toArray(new SearchResult[referencedFields.size()]);
    }

    private static List getFieldReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        SearchResultCollector collector = new SearchResultCollector(pm);
        new SearchEngine().searchDeclarationsOfAccessedFields(ResourcesPlugin.getWorkspace(), element, (IJavaSearchResultCollector)collector);
        return collector.getResults();
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchResult[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, pm);
        Set referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IMethod[referencedMethods.size()]);
    }

    private static SearchResult[] getMethodReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedMethods = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedMethods.addAll(ReferenceFinderUtil.getMethodReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedMethods.toArray(new SearchResult[referencedMethods.size()]);
    }

    private static List getMethodReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        SearchResultCollector collector = new SearchResultCollector(pm);
        new SearchEngine().searchDeclarationsOfSentMessages(ResourcesPlugin.getWorkspace(), element, (IJavaSearchResultCollector)collector);
        return collector.getResults();
    }

    public static ITypeBinding[] getTypesReferencedInDeclarations(MethodDeclaration[] methods) throws JavaModelException {
        HashSet typesUsed = new HashSet();
        int i = 0;
        while (i < methods.length) {
            typesUsed.addAll(ReferenceFinderUtil.getTypesUsedInDeclaration(methods[i]));
            ++i;
        }
        return typesUsed.toArray(new ITypeBinding[typesUsed.size()]);
    }

    public static Set getTypesUsedInDeclaration(MethodDeclaration methodDeclaration) throws JavaModelException {
        if (methodDeclaration == null) {
            return new HashSet(0);
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        result.add(methodDeclaration.getReturnType().resolveBinding());
        Iterator iter = methodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            result.add(((SingleVariableDeclaration)iter.next()).getType().resolveBinding());
        }
        iter = methodDeclaration.thrownExceptions().iterator();
        while (iter.hasNext()) {
            result.add(((Name)iter.next()).resolveTypeBinding());
        }
        return result;
    }

    private static Set extractElements(SearchResult[] searchResults, int elementType) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
        int i = 0;
        while (i < searchResults.length) {
            IJavaElement el = searchResults[i].getEnclosingElement();
            if (el.exists() && el.getElementType() == elementType) {
                elements.add(el);
            }
            ++i;
        }
        return elements;
    }
}

