/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;

class ReferenceAnalyzer
extends MoveStaticMemberAnalyzer {
    public ReferenceAnalyzer(MoveStaticMembersRefactoring.ASTData ast, IBinding[] members, ITypeBinding target, ITypeBinding source) {
        super(ast, members, source, target);
    }

    public boolean needsTargetImport() {
        return this.fNeedsImport;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        if (this.isMovedMember((IBinding)node.resolveBinding())) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        if (node.isDeclaration() || !this.isMovedMember(node.resolveBinding()) || this.isProcessed((ASTNode)node)) {
            return false;
        }
        this.rewrite(node, this.fTarget);
        return super.visit(node);
    }

    public boolean visit(QualifiedName node) {
        if (!this.isMovedMember(node.resolveBinding())) {
            return super.visit(node);
        }
        if (node.getParent() instanceof ImportDeclaration) {
            this.fAst.imports.removeImport(node.resolveTypeBinding());
            this.fAst.imports.addImport(String.valueOf(this.fTarget.getQualifiedName()) + '.' + node.getName().getIdentifier());
            return false;
        }
        this.rewrite(node, this.fTarget);
        return false;
    }

    public boolean visit(FieldAccess node) {
        if (!this.isMovedMember((IBinding)node.resolveFieldBinding())) {
            return super.visit(node);
        }
        this.rewrite(node, this.fTarget);
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (!this.isMovedMember((IBinding)node.resolveMethodBinding())) {
            return super.visit(node);
        }
        this.rewrite(node, this.fTarget);
        return super.visit(node);
    }
}

