/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class PushDownRefactoring
extends Refactoring {
    private MemberActionInfo[] fMemberInfos;
    private IMember[] fSelectedMembers;
    private TextChangeManager fChangeManager;
    private final ImportRewriteManager fImportManager;
    private IType fCachedDeclaringClass;
    private ITypeHierarchy fCachedClassHierarchy;
    private IType[] fTypesReferencedInPushedDownMembers;

    private PushDownRefactoring(IMember[] members, CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(members);
        Assert.isNotNull(preferenceSettings);
        this.fSelectedMembers = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])members);
        this.fImportManager = new ImportRewriteManager(preferenceSettings);
    }

    public static PushDownRefactoring create(IMember[] members, CodeGenerationSettings preferenceSettings) throws JavaModelException {
        if (!PushDownRefactoring.isAvailable(members)) {
            return null;
        }
        if (PushDownRefactoring.isOneTypeWithPushableMembers(members)) {
            PushDownRefactoring result = new PushDownRefactoring(new IMember[0], preferenceSettings);
            result.fCachedDeclaringClass = PushDownRefactoring.getSingleTopLevelType(members);
            return result;
        }
        return new PushDownRefactoring(members, preferenceSettings);
    }

    public static boolean isAvailable(IMember[] members) throws JavaModelException {
        if (PushDownRefactoring.isOneTypeWithPushableMembers(members)) {
            return true;
        }
        return members != null && members.length != 0 && PushDownRefactoring.areAllPushable(members) && PushDownRefactoring.haveCommonDeclaringType(members);
    }

    private static boolean isOneTypeWithPushableMembers(IMember[] members) throws JavaModelException {
        IType singleTopLevelType = PushDownRefactoring.getSingleTopLevelType(members);
        return singleTopLevelType != null && PushDownRefactoring.getPushableMembers(singleTopLevelType).length != 0;
    }

    private static IType getSingleTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType(members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("PushDownRefactoring.name");
    }

    public IType getDeclaringClass() {
        if (this.fCachedDeclaringClass != null) {
            return this.fCachedDeclaringClass;
        }
        this.fCachedDeclaringClass = (IType)WorkingCopyUtil.getOriginal((IMember)this.fSelectedMembers[0].getDeclaringType());
        return this.fCachedDeclaringClass;
    }

    private ICompilationUnit getDeclaringWorkingCopy() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.getDeclaringClass().getCompilationUnit());
    }

    private static boolean haveCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType declaringType = members[0].getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        int i = 0;
        while (i < members.length) {
            if (!declaringType.equals(members[i].getDeclaringType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean areAllPushable(IMember[] members) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            if (!PushDownRefactoring.isPushable(members[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block7: {
            block6: {
                block5: {
                    RefactoringStatus refactoringStatus;
                    try {
                        pm.beginTask("", 1);
                        result = new RefactoringStatus();
                        this.fSelectedMembers = WorkingCopyUtil.getOriginals(this.fSelectedMembers);
                        result.merge(this.checkPossibleSubclasses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        if (!result.hasFatalError()) break block5;
                        refactoringStatus = result;
                        Object var3_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_11 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(this.checkDeclaringType());
                if (!result.hasFatalError()) break block6;
                RefactoringStatus refactoringStatus = result;
                Object var3_8 = null;
                pm.done();
                return refactoringStatus;
            }
            result.merge(this.checkIfMembersExist());
            if (!result.hasFatalError()) break block7;
            RefactoringStatus refactoringStatus = result;
            Object var3_9 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fMemberInfos = PushDownRefactoring.createInfosForAllPushableFieldsAndMethods(this.getDeclaringClass());
        this.setInfoAction(0, this.fSelectedMembers);
        RefactoringStatus refactoringStatus = result;
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    private void setInfoAction(int action, IMember[] members) {
        List<IMember> list = Arrays.asList(members);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (list.contains(info.getMember())) {
                info.setAction(action);
            }
            ++i;
        }
    }

    private RefactoringStatus checkPossibleSubclasses(IProgressMonitor pm) throws JavaModelException {
        IType[] modifiableSubclasses = this.getDestinationClassesForNonAbstractMembers(pm);
        if (modifiableSubclasses.length == 0) {
            String msg = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.no_subclasses", new String[]{PushDownRefactoring.createTypeLabel(this.getDeclaringClass())});
            return RefactoringStatus.createFatalErrorStatus(msg);
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkIfMembersExist() {
        int i = 0;
        while (i < this.fSelectedMembers.length) {
            IMember orig = this.fSelectedMembers[i];
            if (orig == null || !orig.exists()) {
                String message = RefactoringCoreMessages.getString("PushDownRefactoring.not_in_saved");
                return RefactoringStatus.createFatalErrorStatus(message);
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkDeclaringType() throws JavaModelException {
        IType declaringType = this.getDeclaringClass();
        if (declaringType.isInterface()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PushDownRefactoring.interface_members"));
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PushDownRefactoring.members_of_binary"));
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PushDownRefactoring.members_of_read-only"));
        }
        return new RefactoringStatus();
    }

    private static MemberActionInfo[] createInfosForAllPushableFieldsAndMethods(IType type) throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>();
        IMember[] pushableMembers = PushDownRefactoring.getPushableMembers(type);
        int i = 0;
        while (i < pushableMembers.length) {
            result.add(MemberActionInfo.create(pushableMembers[i]));
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private static IMember[] getPushableMembers(IType type) throws JavaModelException {
        ArrayList list = new ArrayList(3);
        PushDownRefactoring.addAllPushable((IMember[])type.getFields(), list);
        PushDownRefactoring.addAllPushable((IMember[])type.getMethods(), list);
        return list.toArray(new IMember[list.size()]);
    }

    private static void addAllPushable(IMember[] members, List list) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            if (PushDownRefactoring.isPushable(members[i])) {
                list.add(members[i]);
            }
            ++i;
        }
    }

    private static boolean isPushable(IMember member) throws JavaModelException {
        if (member.getElementType() != 9 && member.getElementType() != 8) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (JdtFlags.isStatic(member)) {
            return false;
        }
        if (member.getElementType() == 9) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
        }
        return true;
    }

    public MemberActionInfo[] getMemberActionInfos() {
        return this.fMemberInfos;
    }

    public void computeAdditionalRequiredMembersToPushDown(IProgressMonitor pm) throws JavaModelException {
        IMember[] additional = this.getAdditionalRequiredMembers(pm);
        this.setInfoAction(0, additional);
    }

    public IMember[] getAdditionalRequiredMembers(IProgressMonitor pm) throws JavaModelException {
        IMember current;
        IMember[] members = this.getMembersToBeCreatedInSubclasses();
        pm.beginTask(RefactoringCoreMessages.getString("PushDownRefactoring.calculating"), members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPushableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private void addAllRequiredPushableMembers(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        this.addAllRequiredPushableMethods(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addAllRequiredPushableFields(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private void addAllRequiredPushableFields(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, pm);
        int i = 0;
        while (i < requiredFields.length) {
            IField field = requiredFields[i];
            if (this.isRequiredPushableMember(queue, (IMember)field)) {
                queue.add(field);
            }
            ++i;
        }
    }

    private void addAllRequiredPushableMethods(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        SubProgressMonitor sPm = new SubProgressMonitor(pm, 1);
        sPm.beginTask("", requiredMethods.length);
        int i = 0;
        while (i < requiredMethods.length) {
            IMethod method = requiredMethods[i];
            if (!MethodChecks.isVirtual(method) && this.isRequiredPushableMember(queue, (IMember)method)) {
                queue.add(method);
            }
            ++i;
        }
        sPm.done();
    }

    private boolean isRequiredPushableMember(List queue, IMember member) throws JavaModelException {
        return member.getDeclaringType().equals(this.getDeclaringClass()) && !queue.contains(member) && PushDownRefactoring.isPushable(member);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block9: {
            RefactoringStatus refactoringStatus2;
            block8: {
                try {
                    try {
                        pm.beginTask(RefactoringCoreMessages.getString("PushDownRefactoring.creating_preview"), 5);
                        this.clearCaches();
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(this.checkMembersInDestinationClasses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        result.merge(this.checkElementsAccessedByModifiedMembers((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        result.merge(this.checkReferencesToPushedDownMembers((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        if (this.shouldMakeDeclaringClassAbstract()) {
                            result.merge(this.checkCallsToDeclaringClassConstructors((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        } else {
                            pm.worked(1);
                        }
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            Object var3_7 = null;
                            break block8;
                        }
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        result.merge(this.validateModifiesFiles());
                        refactoringStatus = result;
                        break block9;
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private void clearCaches() {
        this.fTypesReferencedInPushedDownMembers = null;
        this.fImportManager.clear();
    }

    private RefactoringStatus checkReferencesToPushedDownMembers(IProgressMonitor pm) throws JavaModelException {
        IMember[] membersToPush = this.getMembersToPushDown();
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> movedMembers = Arrays.asList(this.getMembersToBeCreatedInSubclasses());
        pm.beginTask("", membersToPush.length);
        int i = 0;
        while (i < membersToPush.length) {
            IMember member = membersToPush[i];
            String label = PushDownRefactoring.createLabel(member);
            IJavaElement[] referencing = PushDownRefactoring.getReferencingElementsFromSameClass(member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            int j = 0;
            while (j < referencing.length) {
                IJavaElement element = referencing[j];
                if (!movedMembers.contains(element) && element instanceof IMember) {
                    IMember referencingMember = (IMember)element;
                    Object[] keys = new Object[]{label, PushDownRefactoring.createLabel(referencingMember)};
                    String msg = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.referenced", keys);
                    result.addError(msg, JavaStatusContext.create(referencingMember));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private static IJavaElement[] getReferencingElementsFromSameClass(IMember member, IProgressMonitor pm) throws JavaModelException {
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern(new IJavaElement[]{member}, 2);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getDeclaringType()});
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pm, scope, pattern);
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(3);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            SearchResult[] results = group.getSearchResults();
            int j = 0;
            while (j < results.length) {
                SearchResult searchResult = results[i];
                result.add(searchResult.getEnclosingElement());
                ++j;
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private RefactoringStatus checkElementsAccessedByModifiedMembers(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.getString("PushDownRefactoring.checking"), 3);
        IType[] subclasses = this.getDestinationClassesForNonAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(this.checkAccessedTypes(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFields(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedMethods(subclasses, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypeReferencedInPushedDownMembers(pm);
        int i = 0;
        while (i < subclasses.length) {
            IType targetClass = subclasses[i];
            int j = 0;
            while (j < accessedTypes.length) {
                IType type = accessedTypes[j];
                if (!this.canBeAccessedFrom((IMember)type, targetClass)) {
                    String message = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.type_not_accessible", new String[]{PushDownRefactoring.createTypeLabel(type), PushDownRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)type));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedFields(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = this.getMembersToBeCreatedInSubclasses();
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])membersToPushDown, pm);
        int i = 0;
        while (i < subclasses.length) {
            IType targetClass = subclasses[i];
            int j = 0;
            while (j < accessedFields.length) {
                boolean isAccessible;
                IField field = accessedFields[j];
                boolean bl = isAccessible = pushedDownList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.field_not_accessible", new String[]{PushDownRefactoring.createFieldLabel(field), PushDownRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IType[] subclasses, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = this.getMembersToBeCreatedInSubclasses();
        List<IMember> pushedDownList = Arrays.asList(membersToPushDown);
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])membersToPushDown, pm);
        int i = 0;
        while (i < subclasses.length) {
            IType targetClass = subclasses[i];
            int j = 0;
            while (j < accessedMethods.length) {
                boolean isAccessible;
                IMethod method = accessedMethods[j];
                boolean bl = isAccessible = this.canBeAccessedFrom((IMember)method, targetClass) || pushedDownList.contains(method);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.method_not_accessible", new String[]{PushDownRefactoring.createMethodLabel(method), PushDownRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
                ++j;
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private boolean canBeAccessedFrom(IMember member, IType newHome) throws JavaModelException {
        Assert.isTrue(!(member instanceof IInitializer));
        if (!member.exists()) {
            return false;
        }
        if (newHome.equals(member.getDeclaringType())) {
            return true;
        }
        if (newHome.equals(member)) {
            return true;
        }
        if (JdtFlags.isPrivate(member)) {
            return false;
        }
        if (member.getDeclaringType() == null) {
            if (!(member instanceof IType)) {
                return false;
            }
            if (JdtFlags.isPublic(member)) {
                return true;
            }
            if (!JdtFlags.isPackageVisible(member)) {
                return false;
            }
            return JavaModelUtil.isSamePackage(((IType)member).getPackageFragment(), newHome.getPackageFragment());
        }
        IType enclosingType = member.getDeclaringType();
        if (!this.canBeAccessedFrom((IMember)enclosingType, newHome)) {
            return false;
        }
        boolean samePackage = JavaModelUtil.isSamePackage(enclosingType.getPackageFragment(), newHome.getPackageFragment());
        if (samePackage) {
            return true;
        }
        if (enclosingType.equals(this.getDeclaringClass())) {
            return JdtFlags.isPublic(member) || JdtFlags.isProtected(member);
        }
        return JdtFlags.isPublic(member);
    }

    private IType[] getTypeReferencedInPushedDownMembers(IProgressMonitor pm) throws JavaModelException {
        if (this.fTypesReferencedInPushedDownMembers == null) {
            this.fTypesReferencedInPushedDownMembers = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.getMembersToBeCreatedInSubclasses(), pm);
        }
        return this.fTypesReferencedInPushedDownMembers;
    }

    private IMember[] getMembersToBeCreatedInSubclasses() throws JavaModelException {
        return MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
    }

    private IMember[] getMembersToPushDown() {
        ArrayList<IMember> fields = new ArrayList<IMember>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBePushedDown()) {
                fields.add(info.getMember());
            }
            ++i;
        }
        return fields.toArray(new IMember[fields.size()]);
    }

    private RefactoringStatus checkCallsToDeclaringClassConstructors(IProgressMonitor pm) throws JavaModelException {
        SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(this.getDeclaringClass(), pm);
        String msg = RefactoringCoreMessages.getFormattedString("PushDownRefactoring.gets_instantiated", new Object[]{PushDownRefactoring.createTypeLabel(this.getDeclaringClass())});
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < groups.length) {
            ICompilationUnit cu = groups[i].getCompilationUnit();
            if (cu != null) {
                CompilationUnit cuNode = AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)false);
                ASTNode[] refNodes = ASTNodeSearchUtil.getAstNodes(groups[i].getSearchResults(), cuNode);
                int j = 0;
                while (j < refNodes.length) {
                    ASTNode node = refNodes[j];
                    if (node instanceof ClassInstanceCreation || ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(node)) {
                        Context context = JavaStatusContext.create(cu, node);
                        result.addError(msg, context);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkMembersInDestinationClasses(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        IMember[] membersToPushDown = this.getMembersToBeCreatedInSubclasses();
        IType[] destinationClassesForNonAbstract = this.getDestinationClassesForNonAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(this.checkNonAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForNonAbstract));
        IType[] destinationClassesForAbstract = this.getDestinationClassesForAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(this.checkAbstractMembersInDestinationClasses(membersToPushDown, destinationClassesForAbstract));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] abstractMembersToPushDown = PushDownRefactoring.getAbstractMembers(membersToPushDown);
        int i = 0;
        while (i < destinationClassesForAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(abstractMembersToPushDown, destinationClassesForAbstract[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkNonAbstractMembersInDestinationClasses(IMember[] membersToPushDown, IType[] destinationClassesForNonAbstract) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMember[] nonAbstractMembersToPushDown = PushDownRefactoring.getNonAbstractMembers(membersToPushDown);
        int i = 0;
        while (i < destinationClassesForNonAbstract.length) {
            result.merge(MemberCheckUtil.checkMembersInDestinationType(nonAbstractMembersToPushDown, destinationClassesForNonAbstract[i]));
            ++i;
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange("Push down", this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearCaches();
            throw throwable;
        }
        pm.done();
        this.clearCaches();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("PushDownRefactoring.preview"), 4);
            this.addImportsToSubclasses((IProgressMonitor)new SubProgressMonitor(pm, 1));
            TextChangeManager manager = new TextChangeManager();
            MemberActionInfo[] abstractMembersToCopyToSubclasses = this.getInfosForAbstractMembersToBeCreatedInSubclassesOfDeclaringClass();
            MemberActionInfo[] nonAbstractMembersToCopyToSubclasses = this.getInfosForNonAbstractMembersToBeCreatedInSubclassesOfDeclaringClass();
            IType[] destinationsForNonAbstract = this.getDestinationClassesForNonAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] destinationsForAbstract = this.getDestinationClassesForAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
            ICompilationUnit declaringCu = this.getDeclaringWorkingCopy();
            CompilationUnit declaringCuNode = AST.parseCompilationUnit((ICompilationUnit)declaringCu, (boolean)true);
            ICompilationUnit[] cus = this.getCusToProcess((IProgressMonitor)new SubProgressMonitor(pm, 1));
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                CompilationUnit cuNode = cu.equals(declaringCu) ? declaringCuNode : AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)true);
                ASTRewrite rewrite = new ASTRewrite((ASTNode)cuNode);
                if (cu.equals(declaringCu)) {
                    TypeDeclaration declaringClass = ASTNodeSearchUtil.getTypeDeclarationNode(this.getDeclaringClass(), cuNode);
                    if (this.shouldMakeDeclaringClassAbstract()) {
                        this.makeDeclaringClassAbstract(declaringClass, rewrite);
                    }
                    PushDownRefactoring.deleteDeclarationNodes(cuNode, rewrite, Arrays.asList(this.getMembersToDeleteFromDeclaringClass()));
                    this.makeMethodsAbstractInDeclaringClass(declaringCuNode, rewrite);
                }
                this.copyMembers(abstractMembersToCopyToSubclasses, destinationsForAbstract, declaringCuNode, cu, cuNode, rewrite);
                this.copyMembers(nonAbstractMembersToCopyToSubclasses, destinationsForNonAbstract, declaringCuNode, cu, cuNode, rewrite);
                this.addTextEditFromRewrite(manager, cu, rewrite);
                ++i;
            }
            textChangeManager = manager;
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void copyMembers(MemberActionInfo[] membersToCopyToSubclasses, IType[] destinationTypes, CompilationUnit declaringCuNode, ICompilationUnit cu, CompilationUnit cuNode, ASTRewrite rewrite) throws JavaModelException {
        int i = 0;
        while (i < destinationTypes.length) {
            IType dest = destinationTypes[i];
            if (cu.equals(WorkingCopyUtil.getWorkingCopyIfExists(dest.getCompilationUnit()))) {
                List bodyDeclarations = ASTNodeSearchUtil.getBodyDeclarationList(dest, cuNode);
                this.createAll(membersToCopyToSubclasses, bodyDeclarations, declaringCuNode, rewrite);
            }
            ++i;
        }
    }

    private void addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChange textChange = manager.get(cu);
        if (this.fImportManager.hasImportEditFor(cu)) {
            resultingEdits.addChild(this.fImportManager.getImportRewrite(cu).createEdit(textBuffer));
        }
        textChange.addTextEdit(RefactoringCoreMessages.getString("PushDownRefactoring.25"), (TextEdit)resultingEdits);
        rewrite.removeModifications();
    }

    private ICompilationUnit[] getCusToProcess(IProgressMonitor pm) throws JavaModelException {
        IType[] subTypes = this.getAllDirectSubclassesOfDeclaringClass(pm);
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(subTypes.length + 1);
        int i = 0;
        while (i < subTypes.length) {
            result.add(WorkingCopyUtil.getWorkingCopyIfExists(subTypes[i].getCompilationUnit()));
            ++i;
        }
        result.add(this.getDeclaringWorkingCopy());
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void addImportsToSubclasses(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 4);
        IMember[] allMembers = MemberActionInfo.getMembers(this.getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass());
        IMember[] nonAbstractMembers = PushDownRefactoring.getNonAbstractMembers(allMembers);
        IType[] destForNonAbstract = this.getDestinationClassesForNonAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addImportsToTypesReferencedInMembers(nonAbstractMembers, destForNonAbstract, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IMember[] abstractMembers = PushDownRefactoring.getAbstractMembers(allMembers);
        IType[] destForAbstract = this.getDestinationClassesForAbstractMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addImportsToTypesReferencedInMembers(abstractMembers, destForAbstract, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private void addImportsToTypesReferencedInMembers(IMember[] members, IType[] destinationClasses, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        IType[] typesReferenced = this.getTypesReferencedIn(members, pm);
        int i = 0;
        while (i < destinationClasses.length) {
            ICompilationUnit cu = this.getWorkingCopyOfCu((IMember)destinationClasses[i]);
            int j = 0;
            while (j < typesReferenced.length) {
                this.fImportManager.addImportTo(typesReferenced[j], cu);
                ++j;
            }
            ++i;
        }
        pm.done();
    }

    private IType[] getTypesReferencedIn(IMember[] members, IProgressMonitor pm) throws JavaModelException {
        return ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])members, pm);
    }

    private static void deleteDeclarationNodes(CompilationUnit cuNode, ASTRewrite rewrite, List members) throws JavaModelException {
        List declarationNodes = PushDownRefactoring.getDeclarationNodes(cuNode, members);
        Iterator iter = declarationNodes.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            if (node instanceof VariableDeclarationFragment) {
                if (!(node.getParent() instanceof FieldDeclaration)) continue;
                FieldDeclaration fd = (FieldDeclaration)node.getParent();
                if (PushDownRefactoring.areAllFragmentsDeleted(fd, declarationNodes)) {
                    rewrite.markAsRemoved((ASTNode)fd);
                    continue;
                }
                rewrite.markAsRemoved(node);
                continue;
            }
            rewrite.markAsRemoved(node);
        }
    }

    private static boolean areAllFragmentsDeleted(FieldDeclaration fd, List declarationNodes) {
        Iterator iter = fd.fragments().iterator();
        while (iter.hasNext()) {
            if (declarationNodes.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static List getDeclarationNodes(CompilationUnit cuNode, List members) throws JavaModelException {
        ArrayList<VariableDeclarationFragment> result = new ArrayList<VariableDeclarationFragment>(members.size());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            VariableDeclarationFragment declarationNode = null;
            if (member instanceof IField) {
                declarationNode = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, cuNode);
            } else if (member instanceof IType) {
                declarationNode = ASTNodeSearchUtil.getTypeDeclarationNode((IType)member, cuNode);
            } else if (member instanceof IMethod) {
                declarationNode = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, cuNode);
            }
            if (declarationNode == null) continue;
            result.add(declarationNode);
        }
        return result;
    }

    private IMember[] getMembersToDeleteFromDeclaringClass() {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeDeletedFromDeclaringClass()) {
                result.add(info.getMember());
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private void createAll(MemberActionInfo[] members, List bodyDeclarations, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            this.create(members[i], bodyDeclarations, declaringCuNode, rewrite);
            ++i;
        }
    }

    private void create(MemberActionInfo info, List bodyDeclarations, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        if (info.isFieldInfo()) {
            this.createField(info, bodyDeclarations, declaringCuNode, rewrite);
        } else {
            this.createMethod(info, bodyDeclarations, declaringCuNode, rewrite);
        }
    }

    private void createMethod(MemberActionInfo info, List bodyDeclarations, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        MethodDeclaration newMethod = this.createNewMethodDeclarationNode(info, declaringCuNode, rewrite);
        rewrite.markAsInserted((ASTNode)newMethod);
        bodyDeclarations.add(ASTNodes.getInsertionIndex((BodyDeclaration)newMethod, bodyDeclarations), newMethod);
    }

    private MethodDeclaration createNewMethodDeclarationNode(MemberActionInfo info, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        Assert.isTrue(!info.isFieldInfo());
        IMethod method = (IMethod)info.getMember();
        MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode(method, declaringCuNode);
        AST ast = PushDownRefactoring.getAST(rewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        PushDownRefactoring.copyBodyOfPushedDownMethod(rewrite, method, oldMethod, newMethod);
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoring.copyJavadocNode(rewrite, (IMember)method, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        }
        newMethod.setModifiers(this.getNewModifiersForCopiedMethod(info, oldMethod));
        newMethod.setName(ast.newSimpleName(oldMethod.getName().getIdentifier()));
        this.copyReturnType(rewrite, oldMethod, newMethod);
        this.copyParameters(rewrite, oldMethod, newMethod);
        this.copyThrownExceptions(oldMethod, newMethod);
        return newMethod;
    }

    private static void copyBodyOfPushedDownMethod(ASTRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        if (oldMethod.getBody() == null) {
            newMethod.setBody(null);
            return;
        }
        Block oldBody = oldMethod.getBody();
        String oldBodySource = PushDownRefactoring.getBufferText((ASTNode)oldBody, method.getCompilationUnit());
        String[] lines = Strings.convertIntoLines(oldBodySource);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        oldBodySource = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
        Block newBody = (Block)targetRewrite.createPlaceholder(oldBodySource, 2);
        newMethod.setBody(newBody);
    }

    private int getNewModifiersForCopiedMethod(MemberActionInfo info, MethodDeclaration oldMethod) throws JavaModelException {
        return info.getNewModifiersForCopyInSubclass(oldMethod.getModifiers());
    }

    private void copyThrownExceptions(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int i = 0;
        int n = oldMethod.thrownExceptions().size();
        while (i < n) {
            Name newException;
            Name oldException = (Name)oldMethod.thrownExceptions().get(i);
            if (oldException.isSimpleName()) {
                newException = ast.newSimpleName(((SimpleName)oldException).getIdentifier());
                newMethod.thrownExceptions().add(i, newException);
            } else {
                newException = (Name)ASTNode.copySubtree((AST)ast, (ASTNode)oldException);
                newMethod.thrownExceptions().add(i, newException);
            }
            ++i;
        }
    }

    private void copyParameters(ASTRewrite targetRewrite, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        int i = 0;
        int n = oldMethod.parameters().size();
        while (i < n) {
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)oldMethod.parameters().get(i);
            SingleVariableDeclaration newParam = PushDownRefactoring.createPlaceholderForSingleVariableDeclaration(oldParam, this.getDeclaringWorkingCopy(), targetRewrite);
            newMethod.parameters().add(i, newParam);
            ++i;
        }
    }

    private void copyReturnType(ASTRewrite targetRewrite, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        Type newReturnType = PushDownRefactoring.createPlaceholderForType(oldMethod.getReturnType(), this.getDeclaringWorkingCopy(), targetRewrite);
        newMethod.setReturnType(newReturnType);
    }

    private void createField(MemberActionInfo info, List bodyDeclarations, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        FieldDeclaration newField = this.createNewFieldDeclarationNode(info, declaringCuNode, rewrite);
        rewrite.markAsInserted((ASTNode)newField);
        bodyDeclarations.add(ASTNodes.getInsertionIndex((BodyDeclaration)newField, bodyDeclarations), newField);
    }

    private FieldDeclaration createNewFieldDeclarationNode(MemberActionInfo info, CompilationUnit declaringCuNode, ASTRewrite rewrite) throws JavaModelException {
        Assert.isTrue(info.isFieldInfo());
        IField field = (IField)info.getMember();
        AST ast = PushDownRefactoring.getAST(rewrite);
        VariableDeclarationFragment oldFieldFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, declaringCuNode);
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        if (oldFieldFragment.getInitializer() != null) {
            Expression newInitializer = PushDownRefactoring.createPlaceholderForExpression(oldFieldFragment.getInitializer(), this.getDeclaringWorkingCopy(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(ast.newSimpleName(oldFieldFragment.getName().getIdentifier()));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = ASTNodeSearchUtil.getFieldDeclarationNode(field, declaringCuNode);
        if (info.copyJavadocToCopiesInSubclasses()) {
            PushDownRefactoring.copyJavadocNode(rewrite, (IMember)field, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        }
        newField.setModifiers(this.getNewModifiersForCopiedField(info, oldField));
        Type newType = PushDownRefactoring.createPlaceholderForType(oldField.getType(), this.getDeclaringWorkingCopy(), rewrite);
        newField.setType(newType);
        return newField;
    }

    private int getNewModifiersForCopiedField(MemberActionInfo info, FieldDeclaration oldField) throws JavaModelException {
        return info.getNewModifiersForCopyInSubclass(oldField.getModifiers());
    }

    private static void copyJavadocNode(ASTRewrite rewrite, IMember member, BodyDeclaration oldDeclaration, BodyDeclaration newDeclaration) throws JavaModelException {
        Javadoc oldJavaDoc = oldDeclaration.getJavadoc();
        if (oldJavaDoc == null) {
            return;
        }
        String source = oldJavaDoc.getComment();
        String[] lines = Strings.convertIntoLines(source);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        source = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)member));
        Javadoc newJavaDoc = (Javadoc)rewrite.createPlaceholder(source, 8);
        newDeclaration.setJavadoc(newJavaDoc);
    }

    private static IType[] toTypeArray(IMember[] member) {
        List<IMember> list = Arrays.asList(member);
        return list.toArray(new IType[list.size()]);
    }

    private static IMember[] getNonAbstractMembers(IMember[] members) throws JavaModelException {
        ArrayList<IMember> list = new ArrayList<IMember>();
        list.addAll(Arrays.asList(members));
        list.removeAll(Arrays.asList(PushDownRefactoring.getAbstractMembers(members)));
        return list.toArray(new IMember[list.size()]);
    }

    private static IMember[] getAbstractMembers(IMember[] members) throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(members.length);
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            if (JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMember[result.size()]);
    }

    private IType[] getDestinationClassesForAbstractMembers(IProgressMonitor pm) throws JavaModelException {
        return PushDownRefactoring.toTypeArray(PushDownRefactoring.getAbstractMembers((IMember[])this.getDestinationClassesForNonAbstractMembers(pm)));
    }

    private IType[] getDestinationClassesForNonAbstractMembers(IProgressMonitor pm) throws JavaModelException {
        IType[] allDirectSubclasses = this.getAllDirectSubclassesOfDeclaringClass(pm);
        ArrayList<IType> result = new ArrayList<IType>(allDirectSubclasses.length);
        int i = 0;
        while (i < allDirectSubclasses.length) {
            IType subclass = allDirectSubclasses[i];
            if (PushDownRefactoring.isModifiable(subclass)) {
                result.add(subclass);
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static boolean isModifiable(IType clazz) throws JavaModelException {
        return clazz.exists() && !clazz.isBinary() && !clazz.isReadOnly() && clazz.getCompilationUnit() != null && clazz.isStructureKnown();
    }

    private IType[] getAllDirectSubclassesOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        return this.getHierarchyOfDeclaringClass(pm).getSubclasses(this.getDeclaringClass());
    }

    public ITypeHierarchy getHierarchyOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        block3: {
            ITypeHierarchy iTypeHierarchy;
            try {
                if (this.fCachedClassHierarchy == null) break block3;
                iTypeHierarchy = this.fCachedClassHierarchy;
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return iTypeHierarchy;
        }
        ITypeHierarchy iTypeHierarchy = this.fCachedClassHierarchy = this.getDeclaringClass().newTypeHierarchy(pm);
        Object var2_5 = null;
        pm.done();
        return iTypeHierarchy;
    }

    private MemberActionInfo[] getInfosForAbstractMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private MemberActionInfo[] getInfosForNonAbstractMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isToBeCreatedInSubclassesOfDeclaringClass() && !JdtFlags.isAbstract(info.getMember())) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private MemberActionInfo[] getInfosForMembersToBeCreatedInSubclassesOfDeclaringClass() throws JavaModelException {
        MemberActionInfo[] abs = this.getInfosForAbstractMembersToBeCreatedInSubclassesOfDeclaringClass();
        MemberActionInfo[] nonabs = this.getInfosForNonAbstractMembersToBeCreatedInSubclassesOfDeclaringClass();
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(abs.length + nonabs.length);
        result.addAll(Arrays.asList(abs));
        result.addAll(Arrays.asList(nonabs));
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private void makeDeclaringClassAbstract(TypeDeclaration declaration, ASTRewrite rewrite) {
        int newModifiers = this.createNewModifiersForMakingDeclaringClassAbstract(declaration);
        rewrite.markAsReplaced((ASTNode)declaration, 34, new Integer(newModifiers), null);
    }

    private int createNewModifiersForMakingDeclaringClassAbstract(TypeDeclaration declaration) {
        return 0x400 | declaration.getModifiers();
    }

    private boolean shouldMakeDeclaringClassAbstract() throws JavaModelException {
        return !JdtFlags.isAbstract((IMember)this.getDeclaringClass()) && this.getInfosForNewMethodsToBeDeclaredAbstract().length != 0;
    }

    private void makeMethodsAbstractInDeclaringClass(CompilationUnit cuNode, ASTRewrite rewrite) throws JavaModelException {
        MemberActionInfo[] methods = this.getInfosForNewMethodsToBeDeclaredAbstract();
        int i = 0;
        while (i < methods.length) {
            this.declareMethodAbstract(methods[i], cuNode, rewrite);
            ++i;
        }
    }

    private MemberActionInfo[] getInfosForNewMethodsToBeDeclaredAbstract() throws JavaModelException {
        ArrayList<MemberActionInfo> result = new ArrayList<MemberActionInfo>(this.fMemberInfos.length);
        int i = 0;
        while (i < this.fMemberInfos.length) {
            MemberActionInfo info = this.fMemberInfos[i];
            if (info.isNewMethodToBeDeclaredAbstract()) {
                result.add(info);
            }
            ++i;
        }
        return result.toArray(new MemberActionInfo[result.size()]);
    }

    private void declareMethodAbstract(MemberActionInfo info, CompilationUnit cuNode, ASTRewrite rewrite) throws JavaModelException {
        Assert.isTrue(!info.isFieldInfo());
        IMethod method = (IMethod)info.getMember();
        if (JdtFlags.isAbstract((IMember)method)) {
            return;
        }
        MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, cuNode);
        rewrite.markAsRemoved((ASTNode)declaration.getBody());
        int newModifiers = this.createModifiersForMethodMadeAbstract(info, declaration.getModifiers());
        rewrite.markAsReplaced((ASTNode)declaration, 34, new Integer(newModifiers), null);
    }

    private int createModifiersForMethodMadeAbstract(MemberActionInfo info, int oldModifiers) throws JavaModelException {
        return info.getNewModifiersForOriginal(oldModifiers);
    }

    private ICompilationUnit getWorkingCopyOfCu(IMember member) {
        return WorkingCopyUtil.getWorkingCopyIfExists(member.getCompilationUnit());
    }

    private static AST getAST(ASTRewrite rewrite) {
        return rewrite.getAST();
    }

    private static String createLabel(IMember member) {
        if (member instanceof IType) {
            return PushDownRefactoring.createTypeLabel((IType)member);
        }
        if (member instanceof IMethod) {
            return PushDownRefactoring.createMethodLabel((IMethod)member);
        }
        if (member instanceof IField) {
            return PushDownRefactoring.createFieldLabel((IField)member);
        }
        if (member instanceof IInitializer) {
            return RefactoringCoreMessages.getString("PushDownRefactoring.initializer");
        }
        Assert.isTrue(false);
        return null;
    }

    private static String createTypeLabel(IType type) {
        return JavaModelUtil.getFullyQualifiedName(type);
    }

    private static String createFieldLabel(IField field) {
        return field.getElementName();
    }

    private static String createMethodLabel(IMethod method) {
        return JavaElementUtil.createMethodSignature(method);
    }

    private static String getBufferText(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        return cu.getBuffer().getText(node.getStartPosition(), node.getLength());
    }

    private static Expression createPlaceholderForExpression(Expression expression, ICompilationUnit cu, ASTRewrite rewrite) throws JavaModelException {
        return (Expression)rewrite.createPlaceholder(PushDownRefactoring.getBufferText((ASTNode)expression, cu), 3);
    }

    private static SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, ICompilationUnit cu, ASTRewrite rewrite) throws JavaModelException {
        return (SingleVariableDeclaration)rewrite.createPlaceholder(PushDownRefactoring.getBufferText((ASTNode)declaration, cu), 5);
    }

    private static Type createPlaceholderForType(Type type, ICompilationUnit cu, ASTRewrite rewrite) throws JavaModelException {
        return (Type)rewrite.createPlaceholder(PushDownRefactoring.getBufferText((ASTNode)type, cu), 6);
    }

    public static class MemberActionInfo
    implements IMemberActionInfo {
        private final IMember fMember;
        private int fAction;
        public static final int PUSH_DOWN_ACTION = 0;
        public static final int PUSH_ABSTRACT_ACTION = 1;
        public static final int NO_ACTION = 2;

        private MemberActionInfo(IMember member, int action) {
            MemberActionInfo.assertValidAction(member, action);
            Assert.isTrue(member instanceof IField || member instanceof IMethod);
            this.fMember = member;
            this.fAction = action;
        }

        public void setAction(int action) {
            MemberActionInfo.assertValidAction(this.fMember, action);
            if (this.isFieldInfo()) {
                Assert.isTrue(action != 1);
            }
            this.fAction = action;
        }

        public int[] getAvailableActions() {
            if (this.isFieldInfo()) {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            return nArray;
        }

        private static void assertValidAction(IMember member, int action) {
            if (member instanceof IMethod) {
                Assert.isTrue(action == 1 || action == 2 || action == 0);
            } else if (member instanceof IField) {
                Assert.isTrue(action == 2 || action == 0);
            }
        }

        public static MemberActionInfo create(IMember member) {
            return new MemberActionInfo(member, 2);
        }

        public boolean isToBePushedDown() {
            return this.fAction == 0;
        }

        boolean isToBeDeletedFromDeclaringClass() {
            return this.isToBePushedDown();
        }

        boolean isNewMethodToBeDeclaredAbstract() throws JavaModelException {
            return !this.isFieldInfo() && !JdtFlags.isAbstract(this.fMember) && this.fAction == 1;
        }

        boolean isToBeCreatedInSubclassesOfDeclaringClass() {
            return this.fAction != 2;
        }

        public IMember getMember() {
            return this.fMember;
        }

        public int getAction() {
            return this.fAction;
        }

        boolean isFieldInfo() {
            return this.fMember instanceof IField;
        }

        int getNewModifiersForCopyInSubclass(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract() && !JdtFlags.isPublic(this.fMember)) {
                modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
            }
            return modifiers;
        }

        int getNewModifiersForOriginal(int oldModifiers) throws JavaModelException {
            if (this.isFieldInfo()) {
                return oldModifiers;
            }
            if (this.isToBeDeletedFromDeclaringClass()) {
                return oldModifiers;
            }
            int modifiers = oldModifiers;
            if (this.isNewMethodToBeDeclaredAbstract()) {
                modifiers = JdtFlags.clearFlag(272, oldModifiers);
                modifiers |= 0x400;
                if (!JdtFlags.isPublic(this.fMember)) {
                    modifiers = 4 | JdtFlags.clearAccessModifiers(modifiers);
                }
            }
            return modifiers;
        }

        public boolean isEditable() {
            if (this.isFieldInfo()) {
                return false;
            }
            return this.getAction() != 2;
        }

        boolean copyJavadocToCopiesInSubclasses() {
            return this.isToBeDeletedFromDeclaringClass();
        }

        static IMember[] getMembers(MemberActionInfo[] infos) {
            IMember[] result = new IMember[infos.length];
            int i = 0;
            while (i < result.length) {
                result[i] = infos[i].getMember();
                ++i;
            }
            return result;
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }
    }
}

