/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;

class MovedMemberAnalyzer
extends MoveStaticMemberAnalyzer {
    public MovedMemberAnalyzer(MoveStaticMembersRefactoring.ASTData ast, IBinding[] members, ITypeBinding source, ITypeBinding target) {
        super(ast, members, source, target);
    }

    public boolean targetNeedsSourceImport() {
        return this.fNeedsImport;
    }

    public boolean visit(SimpleName node) {
        if (node.isDeclaration() || this.isProcessed((ASTNode)node)) {
            return super.visit(node);
        }
        IBinding binding = node.resolveBinding();
        if (this.isMovedMember(binding)) {
            return super.visit(node);
        }
        if (this.isSourceAccess(binding)) {
            this.rewrite(node, this.fSource);
        }
        return super.visit(node);
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (this.isMovedMember(binding)) {
            return super.visit(node);
        }
        if (this.isSourceAccess(binding)) {
            this.rewrite(node, this.fSource);
            return false;
        }
        if (this.isTargetAccess(binding)) {
            SimpleName replace = (SimpleName)this.fAst.rewriter.createCopy((ASTNode)node.getName());
            this.fAst.rewriter.markAsReplaced((ASTNode)node, (ASTNode)replace);
        }
        return super.visit(node);
    }

    public boolean visit(FieldAccess node) {
        IVariableBinding binding = node.resolveFieldBinding();
        if (this.isMovedMember((IBinding)binding)) {
            return super.visit(node);
        }
        if (this.isSourceAccess((IBinding)binding)) {
            this.rewrite(node, this.fSource);
        }
        if (this.isTargetAccess((IBinding)binding)) {
            this.fAst.rewriter.markAsRemoved((ASTNode)node.getExpression());
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (this.isMovedMember((IBinding)binding)) {
            return super.visit(node);
        }
        if (this.isSourceAccess((IBinding)binding)) {
            this.rewrite(node, this.fSource);
        }
        if (this.isTargetAccess((IBinding)binding)) {
            this.fAst.rewriter.markAsRemoved((ASTNode)node.getExpression());
        }
        return super.visit(node);
    }

    private boolean isSourceAccess(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return Modifier.isStatic((int)method.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)method.getDeclaringClass());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            return Modifier.isStatic((int)type.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)type.getDeclaringClass());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding field = (IVariableBinding)binding;
            return field.isField() && Modifier.isStatic((int)field.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)field.getDeclaringClass());
        }
        return false;
    }

    private boolean isTargetAccess(IBinding binding) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return Modifier.isStatic((int)method.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)method.getDeclaringClass());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            return Modifier.isStatic((int)type.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)type.getDeclaringClass());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding field = (IVariableBinding)binding;
            return field.isField() && Modifier.isStatic((int)field.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)field.getDeclaringClass());
        }
        return false;
    }
}

