/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MovedMemberAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class MoveStaticMembersRefactoring
extends Refactoring {
    private IMember[] fMembersToMove;
    private IType fDestinationType;
    private String fDestinationTypeName;
    private CodeGenerationSettings fPreferences;
    private CompositeChange fChange;
    private ASTData fSource;
    private ITypeBinding fSourceBinding;
    private ASTData fTarget;
    private IBinding[] fMemberBindings;
    private BodyDeclaration[] fMemberDeclarations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private MoveStaticMembersRefactoring(IMember[] elements, CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(elements);
        Assert.isNotNull(preferenceSettings);
        this.fMembersToMove = elements;
        this.fPreferences = preferenceSettings;
    }

    public static MoveStaticMembersRefactoring create(IMember[] elements, CodeGenerationSettings preferenceSettings) throws JavaModelException {
        if (!MoveStaticMembersRefactoring.isAvailable(elements)) {
            return null;
        }
        return new MoveStaticMembersRefactoring(elements, preferenceSettings);
    }

    public static boolean isAvailable(IMember[] elements) throws JavaModelException {
        if (elements == null) {
            return false;
        }
        if (elements.length == 0) {
            return false;
        }
        if (!MoveStaticMembersRefactoring.areAllMoveable(elements)) {
            return false;
        }
        return MoveStaticMembersRefactoring.haveCommonDeclaringType(elements);
    }

    private static boolean areAllMoveable(IMember[] elements) throws JavaModelException {
        int i = 0;
        while (i < elements.length) {
            if (!MoveStaticMembersRefactoring.isMoveable(elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isMoveable(IMember member) throws JavaModelException {
        if (member.getElementType() != 9 && member.getElementType() != 8 && member.getElementType() != 7) {
            return false;
        }
        if (member.getDeclaringType() == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member.getElementType() == 9 && member.getDeclaringType().isInterface()) {
            return false;
        }
        if (member.getElementType() == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (member.getElementType() == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (member.getElementType() == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return member.getDeclaringType().isInterface() || JdtFlags.isStatic(member);
    }

    private static boolean haveCommonDeclaringType(IMember[] members) {
        IType declaringType = members[0].getDeclaringType();
        int i = 0;
        while (i < members.length) {
            if (!declaringType.equals(members[i].getDeclaringType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveMembersRefactoring.Move_Members");
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public void setDestinationTypeFullyQualifiedName(String fullyQualifiedTypeName) throws JavaModelException {
        Assert.isNotNull(fullyQualifiedTypeName);
        this.fDestinationType = this.resolveType(fullyQualifiedTypeName);
        if (this.fDestinationType != null) {
            this.fDestinationType = (IType)JavaModelUtil.toWorkingCopy((IMember)this.fDestinationType);
        }
        this.fDestinationTypeName = fullyQualifiedTypeName;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    public IType getDeclaringType() {
        return this.fMembersToMove[0].getDeclaringType();
    }

    private IType resolveType(String fullyQualifiedTypeName) throws JavaModelException {
        return this.getDeclaringType().getJavaProject().findType(fullyQualifiedTypeName);
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block4: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 1);
                result = new RefactoringStatus();
                result.merge(this.checkDeclaringType());
                pm.worked(1);
                if (!result.hasFatalError()) break block4;
                refactoringStatus = result;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fSource = new ASTData(this.fMembersToMove[0].getCompilationUnit(), true);
        this.fSourceBinding = this.getSourceBinding();
        this.fMemberBindings = this.getMemberBindings();
        if (this.fSourceBinding == null || this.hasUnresolvedMemberBinding()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.compile_errors", this.fSource.unit.getElementName()));
        }
        this.fMemberDeclarations = this.getASTMembers(result);
        RefactoringStatus refactoringStatus = result;
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean hasUnresolvedMemberBinding() {
        int i = 0;
        while (i < this.fMemberBindings.length) {
            if (this.fMemberBindings[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private RefactoringStatus checkDeclaringType() throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        if (JavaModelUtil.getFullyQualifiedName(declaringType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.Object"));
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.binary"));
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.read_only"));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block17: {
            RefactoringStatus refactoringStatus2;
            block16: {
                RefactoringStatus refactoringStatus3;
                block15: {
                    RefactoringStatus refactoringStatus4;
                    block14: {
                        RefactoringStatus refactoringStatus5;
                        block13: {
                            RefactoringStatus refactoringStatus6;
                            block12: {
                                RefactoringStatus refactoringStatus7;
                                block11: {
                                    try {
                                        try {
                                            pm.beginTask(RefactoringCoreMessages.getString("MoveMembersRefactoring.Checking_preconditions"), 10);
                                            RefactoringStatus result = new RefactoringStatus();
                                            this.fSource.reset(this.fPreferences);
                                            result.merge(this.checkDestinationType());
                                            if (result.hasFatalError()) {
                                                refactoringStatus7 = result;
                                                Object var3_12 = null;
                                                break block11;
                                            }
                                            result.merge(this.checkDestinationInsideTypeToMove());
                                            if (result.hasFatalError()) {
                                                refactoringStatus6 = result;
                                                break block12;
                                            }
                                            result.merge(MemberCheckUtil.checkMembersInDestinationType(this.fMembersToMove, this.fDestinationType));
                                            if (result.hasFatalError()) {
                                                refactoringStatus5 = result;
                                                break block13;
                                            }
                                            result.merge(this.checkAccessedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                            if (result.hasFatalError()) {
                                                refactoringStatus4 = result;
                                                break block14;
                                            }
                                            result.merge(this.checkMovedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                            if (result.hasFatalError()) {
                                                refactoringStatus3 = result;
                                                break block15;
                                            }
                                            result.merge(this.checkNativeMovedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                            if (result.hasFatalError()) {
                                                refactoringStatus2 = result;
                                                break block16;
                                            }
                                            this.createChange(result, (IProgressMonitor)new SubProgressMonitor(pm, 7));
                                            refactoringStatus = result;
                                            break block17;
                                        }
                                        catch (JavaModelException e) {
                                            throw e;
                                        }
                                        catch (CoreException e) {
                                            throw new JavaModelException(e);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_19 = null;
                                        pm.done();
                                        throw throwable;
                                    }
                                }
                                pm.done();
                                return refactoringStatus7;
                            }
                            Object var3_13 = null;
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var3_14 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var3_15 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_16 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_17 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_18 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkDestinationType() throws JavaModelException {
        if (this.fDestinationType == null) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.not_found", this.fDestinationTypeName);
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (this.fDestinationType.equals(this.getDeclaringType())) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.same", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (!this.fDestinationType.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.not_exist", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (this.fDestinationType.isBinary()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.dest_binary", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        RefactoringStatus result = new RefactoringStatus();
        if (this.fDestinationType.isInterface() && !this.getDeclaringType().isInterface()) {
            result.merge(this.checkFieldsForInterface());
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (!MoveStaticMembersRefactoring.canDeclareStaticMembers(this.fDestinationType)) {
            String message = RefactoringCoreMessages.getString("MoveMembersRefactoring.static_declaration");
            result.addError(message);
        }
        return result;
    }

    private RefactoringStatus checkDestinationInsideTypeToMove() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IType type;
            if (this.fMembersToMove[i] instanceof IType && (this.fDestinationType.equals(type = (IType)this.fMembersToMove[i]) || JavaElementUtil.isAncestorOf((IJavaElement)type, (IJavaElement)this.fDestinationType))) {
                String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.inside", new String[]{JavaModelUtil.getFullyQualifiedName(type), JavaModelUtil.getFullyQualifiedName(this.fDestinationType)});
                Context context = JavaStatusContext.create(this.fDestinationType.getCompilationUnit(), this.fDestinationType.getNameRange());
                result.addFatalError(message, context);
                return result;
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkFieldsForInterface() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (!this.canMoveToInterface(this.fMembersToMove[i])) {
                String message = RefactoringCoreMessages.getString("MoveMembersRefactoring.only_public_static_final");
                result.addError(message, JavaStatusContext.create(this.fMembersToMove[i]));
            }
            ++i;
        }
        return result;
    }

    private boolean canMoveToInterface(IMember member) throws JavaModelException {
        if (member.getElementType() != 8) {
            return false;
        }
        int flags = member.getFlags();
        if (!(Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && Flags.isFinal((int)flags))) {
            return false;
        }
        VariableDeclarationFragment declaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, this.fSource.root);
        return declaration.getInitializer() != null;
    }

    private static boolean canDeclareStaticMembers(IType type) throws JavaModelException {
        return JdtFlags.isStatic((IMember)type) || type.getDeclaringType() == null;
    }

    private RefactoringStatus checkAccessedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessedMethodsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFieldsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedTypesAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethodsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        MoveStaticMembersRefactoring.toWorkingCopies((IMember[])accessedMethods);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedMethods.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedMethods[i]) && JdtFlags.isStatic((IMember)accessedMethods[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedMethods[i], accessedMethods[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedMethods[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedMethods[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedTypesAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        MoveStaticMembersRefactoring.toWorkingCopies((IMember[])accessedTypes);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedTypes.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedTypes[i]) && JdtFlags.isStatic((IMember)accessedTypes[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedTypes[i], accessedTypes[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedTypes[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedTypes[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFieldsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToMove, pm);
        MoveStaticMembersRefactoring.toWorkingCopies((IMember[])accessedFields);
        List<IMember> movedElementList = Arrays.asList(this.fMembersToMove);
        int i = 0;
        while (i < accessedFields.length) {
            if (!this.containsAncestorOf(movedElementList, (IMember)accessedFields[i]) && JdtFlags.isStatic((IMember)accessedFields[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedFields[i], accessedFields[i].getDeclaringType(), this.fDestinationType)) {
                String msg = this.createNonAccessibleMemberMessage((IMember)accessedFields[i], this.fDestinationType, false);
                result.addError(msg, JavaStatusContext.create((IMember)accessedFields[i]));
            }
            ++i;
        }
        return result;
    }

    private boolean containsAncestorOf(List movedElementList, IMember accessedMember) {
        IMember element = accessedMember;
        do {
            if (!movedElementList.contains(element)) continue;
            return true;
        } while ((element = element.getParent()) instanceof IMember);
        return false;
    }

    private static void toWorkingCopies(IMember[] accessedFields) {
        int i = 0;
        while (i < accessedFields.length) {
            accessedFields[i] = JavaModelUtil.toWorkingCopy(accessedFields[i]);
            ++i;
        }
    }

    private RefactoringStatus checkMovedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("Check availability of members after move.", this.fMembersToMove.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            result.merge(this.checkMovedMemberAvailability(this.fMembersToMove[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkMovedMemberAvailability(IMember memberToMove, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (memberToMove instanceof IType) {
            IJavaElement[] typeMembers = ((IType)memberToMove).getChildren();
            pm.beginTask("", typeMembers.length + 1);
            int i = 0;
            while (i < typeMembers.length) {
                if (typeMembers[i] instanceof IInitializer) {
                    pm.worked(1);
                } else {
                    result.merge(this.checkMovedMemberAvailability((IMember)typeMembers[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                }
                ++i;
            }
        } else {
            pm.beginTask("", 1);
        }
        IType[] blindAccessorTypes = this.getTypesNotSeeingMovedMember(memberToMove, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        int k = 0;
        while (k < blindAccessorTypes.length) {
            String message = this.createNonAccessibleMemberMessage(memberToMove, blindAccessorTypes[k], true);
            result.addError(message, JavaStatusContext.create(memberToMove));
            ++k;
        }
        pm.done();
        return result;
    }

    private IType[] getTypesNotSeeingMovedMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        if (JdtFlags.isPublic(member) && JdtFlags.isPublic((IMember)this.fDestinationType)) {
            return new IType[0];
        }
        HashSet<IType> blindAccessorTypes = new HashSet<IType>();
        SearchResultGroup[] references = MoveStaticMembersRefactoring.getReferences(member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        int i = 0;
        while (i < references.length) {
            SearchResult[] searchResults = references[i].getSearchResults();
            int k = 0;
            while (k < searchResults.length) {
                SearchResult searchResult = searchResults[k];
                IJavaElement element = WorkingCopyUtil.getWorkingCopyIfExists(searchResult.getEnclosingElement());
                IType type = (IType)element.getAncestor(7);
                if (!(type == null || blindAccessorTypes.contains(type) || this.isWithinMemberToMove(searchResult) || MoveStaticMembersRefactoring.isVisibleFrom(member, this.getDestinationType(), type))) {
                    blindAccessorTypes.add(type);
                }
                ++k;
            }
            ++i;
        }
        return blindAccessorTypes.toArray(new IType[blindAccessorTypes.size()]);
    }

    private String createNonAccessibleMemberMessage(IMember member, IType accessingType, boolean moved) throws JavaModelException {
        IType declaringType = moved ? this.getDestinationType() : this.getDeclaringType();
        switch (member.getElementType()) {
            case 8: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_field", new String[]{JavaElementUtil.createFieldSignature((IField)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_field", new String[]{JavaElementUtil.createFieldSignature((IField)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
            case 9: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_method", new String[]{JavaElementUtil.createMethodSignature((IMethod)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_method", new String[]{JavaElementUtil.createMethodSignature((IMethod)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
            case 7: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_type", new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), JavaModelUtil.getFullyQualifiedName(accessingType), JavaModelUtil.getFullyQualifiedName(declaringType)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_type", new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), JavaModelUtil.getFullyQualifiedName(accessingType)});
                return message;
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static SearchResultGroup[] getReferences(IMember member, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)member);
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)member, (int)2);
        SearchResultGroup[] references = RefactoringSearchEngine.search(pm, scope, pattern);
        return references;
    }

    private static boolean isVisibleFrom(IMember member, IType newMemberDeclaringType, IType accessingType) throws JavaModelException {
        int memberVisibility = JdtFlags.getLowerVisibility(JdtFlags.getVisibilityCode(member), JdtFlags.getVisibilityCode((IMember)newMemberDeclaringType));
        IType declaringType = newMemberDeclaringType.getDeclaringType();
        while (declaringType != null) {
            memberVisibility = JdtFlags.getLowerVisibility(memberVisibility, JdtFlags.getVisibilityCode((IMember)declaringType));
            declaringType = declaringType.getDeclaringType();
        }
        switch (memberVisibility) {
            case 2: {
                return MoveStaticMembersRefactoring.isEqualOrEnclosedType(accessingType, newMemberDeclaringType);
            }
            case 0: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment());
            }
            case 4: {
                return JavaModelUtil.isSamePackage(accessingType.getPackageFragment(), newMemberDeclaringType.getPackageFragment()) || accessingType.newSupertypeHierarchy(null).contains(newMemberDeclaringType);
            }
            case 1: {
                return true;
            }
        }
        Assert.isTrue(false);
        return false;
    }

    private static boolean isEqualOrEnclosedType(IType inner, IType outer) {
        while (inner != null) {
            if (inner.equals(outer)) {
                return true;
            }
            inner = inner.getDeclaringType();
        }
        return false;
    }

    private boolean isWithinMemberToMove(SearchResult result) throws JavaModelException {
        ICompilationUnit referenceCU = JavaModelUtil.toWorkingCopy(result.getCompilationUnit());
        if (!referenceCU.equals(this.fSource.unit)) {
            return false;
        }
        int referenceStart = result.getStart();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (MoveStaticMembersRefactoring.liesWithin(this.fMembersToMove[i].getSourceRange(), referenceStart)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean liesWithin(ISourceRange range, int offset) {
        return range.getOffset() <= offset && range.getOffset() + range.getLength() >= offset;
    }

    private RefactoringStatus checkNativeMovedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fMembersToMove.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToMove.length) {
            if (this.fMembersToMove[i].getElementType() == 9 && JdtFlags.isNative(this.fMembersToMove[i])) {
                String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.native", JavaElementUtil.createMethodSignature((IMethod)this.fMembersToMove[i]));
                result.addWarning(message, JavaStatusContext.create(this.fMembersToMove[i]));
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        pm.done();
        return this.fChange;
    }

    private void createChange(RefactoringStatus status, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 4);
        this.fChange = new CompositeChange(RefactoringCoreMessages.getString("MoveMembersRefactoring.move_members"));
        this.fTarget = this.getASTData(this.fDestinationType.getCompilationUnit());
        ITypeBinding targetBinding = this.getDestinationBinding();
        if (targetBinding == null) {
            status.addFatalError(RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.compile_errors", this.fTarget.unit.getElementName()));
            pm.done();
            return;
        }
        String[] memberSources = this.getUpdatedMemberSource(status, this.fMemberDeclarations, targetBinding);
        pm.worked(1);
        if (status.hasFatalError()) {
            return;
        }
        ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 1), RefactoringScopeFactory.create(this.fMembersToMove), RefactoringSearchEngine.createSearchPattern((IJavaElement[])this.fMembersToMove, 2));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
        sub.beginTask("", affectedCUs.length);
        int i = 0;
        while (i < affectedCUs.length) {
            ICompilationUnit unit = affectedCUs[i];
            ASTData ast = this.getASTData(unit);
            ReferenceAnalyzer analyzer = new ReferenceAnalyzer(ast, this.fMemberBindings, targetBinding, this.fSourceBinding);
            ast.root.accept((ASTVisitor)analyzer);
            status.merge(analyzer.getStatus());
            status.merge(Checks.validateEdit(unit));
            if (status.hasFatalError()) {
                this.fChange = null;
                return;
            }
            if (analyzer.needsTargetImport()) {
                ast.imports.addImport(targetBinding);
            }
            if (!this.isSourceOrTarget(unit)) {
                this.fChange.add(ast.createChange());
            }
            sub.worked(1);
            ++i;
        }
        status.merge(this.moveMembers(this.fMemberDeclarations, memberSources));
        this.fChange.add(this.fSource.createChange());
        status.merge(Checks.validateEdit(this.fSource.unit));
        if (!this.fSource.unit.equals(this.fTarget.unit)) {
            this.fChange.add(this.fTarget.createChange());
            status.merge(Checks.validateEdit(this.fTarget.unit));
        }
        pm.worked(1);
    }

    private ASTData getASTData(ICompilationUnit unit) throws CoreException {
        if (this.fSource.unit.equals(unit)) {
            return this.fSource;
        }
        if (this.fTarget != null && this.fTarget.unit.equals(unit)) {
            return this.fTarget;
        }
        return new ASTData(unit, true, this.fPreferences);
    }

    private boolean isSourceOrTarget(ICompilationUnit unit) {
        return this.fSource.unit.equals(unit) || this.fTarget.unit.equals(unit);
    }

    private ITypeBinding getDestinationBinding() throws JavaModelException {
        ASTNode node = NodeFinder.perform((ASTNode)this.fTarget.root, this.fDestinationType.getNameRange());
        return (ITypeBinding)((SimpleName)node).resolveBinding();
    }

    private ITypeBinding getSourceBinding() throws JavaModelException {
        ASTNode node = NodeFinder.perform((ASTNode)this.fSource.root, this.fMembersToMove[0].getDeclaringType().getNameRange());
        return (ITypeBinding)((SimpleName)node).resolveBinding();
    }

    private IBinding[] getMemberBindings() throws JavaModelException {
        IBinding[] result = new IBinding[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            SimpleName name = (SimpleName)NodeFinder.perform((ASTNode)this.fSource.root, member.getNameRange());
            result[i] = name.resolveBinding();
            ++i;
        }
        return result;
    }

    private String[] getUpdatedMemberSource(RefactoringStatus status, BodyDeclaration[] members, ITypeBinding target) throws CoreException {
        ArrayList typeRefs = new ArrayList();
        boolean targetNeedsSourceImport = false;
        int i = 0;
        while (i < members.length) {
            BodyDeclaration declaration = members[i];
            typeRefs.addAll(TypeReferenceFinder.perform((ASTNode)declaration));
            MovedMemberAnalyzer analyzer = new MovedMemberAnalyzer(this.fSource, this.fMemberBindings, this.fSourceBinding, target);
            declaration.accept((ASTVisitor)analyzer);
            if (this.getDeclaringType().isInterface() && !this.fDestinationType.isInterface()) {
                FieldDeclaration fieldDecl = (FieldDeclaration)declaration;
                int psfModifiers = 25;
                if ((fieldDecl.getModifiers() & psfModifiers) != psfModifiers) {
                    this.fSource.rewriter.markAsReplaced((ASTNode)fieldDecl, 34, new Integer(psfModifiers), null);
                }
            }
            this.fSource.rewriter.markAsTracked((ASTNode)declaration, new GroupDescription("moved member declaration"));
            targetNeedsSourceImport |= analyzer.targetNeedsSourceImport();
            status.merge(analyzer.getStatus());
            ++i;
        }
        if (targetNeedsSourceImport && this.fTarget != this.fSource) {
            this.fTarget.imports.addImport(this.fSourceBinding);
        }
        Iterator iter = typeRefs.iterator();
        while (iter.hasNext()) {
            ITypeBinding binding = (ITypeBinding)iter.next();
            this.fTarget.imports.addImport(binding);
        }
        String[] updatedMemberSources = new String[members.length];
        TextBuffer buffer = TextBuffer.create(this.fSource.unit.getSource());
        TextBufferEditor editor = new TextBufferEditor(buffer);
        MultiTextEdit edit = new MultiTextEdit();
        this.fSource.rewriter.rewriteNode(buffer, (TextEdit)edit);
        editor.add((TextEdit)edit);
        editor.performEdits((IProgressMonitor)new NullProgressMonitor());
        int i2 = 0;
        while (i2 < members.length) {
            updatedMemberSources[i2] = this.getUpdatedMember(buffer, members[i2]);
            ++i2;
        }
        this.fSource.clearRewrite();
        return updatedMemberSources;
    }

    private String getUpdatedMember(TextBuffer buffer, BodyDeclaration declaration) {
        GroupDescription groupDescription = this.fSource.rewriter.getTrackedNodeData((ASTNode)declaration);
        IRegion textRange = groupDescription.getTextRange();
        String newSource = buffer.getContent(textRange.getOffset(), textRange.getLength());
        return Strings.trimIndentation(newSource, this.fPreferences.tabWidth, false);
    }

    private RefactoringStatus moveMembers(BodyDeclaration[] members, String[] sources) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        TypeDeclaration destination = this.getDestinationDeclaration();
        List container = destination.bodyDeclarations();
        GroupDescription delete = this.fSource.createGroupDescription(RefactoringCoreMessages.getString("MoveMembersRefactoring.deleteMembers"));
        GroupDescription add = this.fTarget.createGroupDescription(RefactoringCoreMessages.getString("MoveMembersRefactoring.addMembers"));
        int i = 0;
        while (i < members.length) {
            BodyDeclaration declaration = members[i];
            this.fSource.rewriter.markAsRemoved((ASTNode)declaration, delete);
            ASTNode node = this.fTarget.rewriter.createPlaceholder(sources[i], ASTRewrite.getPlaceholderType((ASTNode)declaration));
            this.fTarget.rewriter.markAsInserted(node, add);
            container.add(ASTNodes.getInsertionIndex((BodyDeclaration)node, container), node);
            ++i;
        }
        return result;
    }

    private BodyDeclaration[] getASTMembers(RefactoringStatus status) throws JavaModelException {
        BodyDeclaration[] result = new BodyDeclaration[this.fMembersToMove.length];
        int i = 0;
        while (i < this.fMembersToMove.length) {
            IMember member = this.fMembersToMove[i];
            ASTNode node = NodeFinder.perform((ASTNode)this.fSource.root, member.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.jdt.core.dom.BodyDeclaration;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result[i] = (BodyDeclaration)ASTNodes.getParent(node, clazz);
            if (result[i] instanceof FieldDeclaration && ((FieldDeclaration)result[i]).fragments().size() != 1) {
                status.addFatalError(RefactoringCoreMessages.getString("MoveMembersRefactoring.multi_var_fields"));
                return result;
            }
            ++i;
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((BodyDeclaration)o1).getStartPosition() - ((BodyDeclaration)o2).getStartPosition();
            }
        });
        return result;
    }

    private TypeDeclaration getDestinationDeclaration() throws JavaModelException {
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fTarget.root, this.fDestinationType.getNameRange());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.core.dom.TypeDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static class ASTData {
        public ICompilationUnit unit;
        public CompilationUnit root;
        public ASTRewrite rewriter;
        public List groups;
        public ImportRewrite imports;

        public ASTData(ICompilationUnit u, boolean resolveBindings) throws JavaModelException {
            this.unit = u;
            this.root = AST.parseCompilationUnit((ICompilationUnit)this.unit, (boolean)resolveBindings);
            this.rewriter = new ASTRewrite((ASTNode)this.root);
        }

        public ASTData(ICompilationUnit u, boolean resolveBindings, CodeGenerationSettings settings) throws CoreException {
            this(u, resolveBindings);
            this.groups = new ArrayList();
            this.imports = new ImportRewrite(this.unit, settings);
        }

        public GroupDescription createGroupDescription(String name) {
            GroupDescription result = new GroupDescription(name);
            this.groups.add(result);
            return result;
        }

        public void reset(CodeGenerationSettings settings) throws CoreException {
            this.clearRewrite();
            this.imports = new ImportRewrite(this.unit, settings);
        }

        public void clearRewrite() {
            this.rewriter.removeModifications();
            this.groups = new ArrayList();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TextChange createChange() throws CoreException {
            CompilationUnitChange result = new CompilationUnitChange(this.unit.getElementName(), this.unit);
            TextBuffer buffer = TextBuffer.acquire(ASTData.getFile(this.unit));
            try {
                MultiTextEdit edit = new MultiTextEdit();
                this.rewriter.rewriteNode(buffer, (TextEdit)edit);
                if (!this.imports.isEmpty()) {
                    edit.addChild(this.imports.createEdit(buffer));
                }
                result.setEdit((TextEdit)edit);
                result.addGroupDescriptions(this.groups.toArray(new GroupDescription[this.groups.size()]));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                TextBuffer.release(buffer);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            TextBuffer.release(buffer);
            return result;
        }

        private static IFile getFile(ICompilationUnit cu) throws CoreException {
            return (IFile)WorkingCopyUtil.getOriginal(cu).getResource();
        }
    }

    private static class TypeReferenceFinder
    extends ASTVisitor {
        List fResult = new ArrayList();
        Set fDefined = new HashSet();

        TypeReferenceFinder() {
        }

        public static List perform(ASTNode root) {
            TypeReferenceFinder visitor = new TypeReferenceFinder();
            root.accept((ASTVisitor)visitor);
            return visitor.fResult;
        }

        public boolean visit(TypeDeclaration node) {
            this.fDefined.add(node.resolveBinding());
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof ITypeBinding)) {
                return true;
            }
            if (!this.fDefined.contains(binding)) {
                this.fResult.add(binding);
            }
            return true;
        }
    }
}

