/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;

class MoveStaticMemberAnalyzer
extends ASTVisitor {
    protected RefactoringStatus fStatus = new RefactoringStatus();
    protected ITypeBinding fSource;
    protected ITypeBinding fTarget;
    protected MoveStaticMembersRefactoring.ASTData fAst;
    protected IBinding[] fMembers;
    protected boolean fNeedsImport;
    protected Set fProcessed;
    protected static final String REFERENCE_UPDATE = RefactoringCoreMessages.getString("MoveMembersRefactoring.referenceUpdate");

    public MoveStaticMemberAnalyzer(MoveStaticMembersRefactoring.ASTData ast, IBinding[] members, ITypeBinding source, ITypeBinding target) {
        this.fAst = ast;
        this.fMembers = members;
        this.fSource = source;
        this.fTarget = target;
        this.fProcessed = new HashSet();
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected boolean isProcessed(ASTNode node) {
        return this.fProcessed.contains(node);
    }

    protected void rewrite(SimpleName node, ITypeBinding type) {
        AST ast = node.getAST();
        QualifiedName name = ast.newQualifiedName((Name)ast.newSimpleName(type.getName()), (SimpleName)this.fAst.rewriter.createCopy((ASTNode)node));
        this.fAst.rewriter.markAsReplaced((ASTNode)node, (ASTNode)name, this.fAst.createGroupDescription(REFERENCE_UPDATE));
        this.fProcessed.add(node);
        this.fNeedsImport = true;
    }

    protected void rewrite(QualifiedName node, ITypeBinding type) {
        this.rewriteName(node.getQualifier(), type);
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(FieldAccess node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            exp = node.getAST().newSimpleName(type.getName());
            this.fAst.rewriter.markAsInserted((ASTNode)exp, this.fAst.createGroupDescription(REFERENCE_UPDATE));
            node.setExpression(exp);
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MethodInvocation node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            exp = node.getAST().newSimpleName(type.getName());
            this.fAst.rewriter.markAsInserted((ASTNode)exp, this.fAst.createGroupDescription(REFERENCE_UPDATE));
            node.setExpression(exp);
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    private void rewriteName(Name name, ITypeBinding type) {
        SimpleName left;
        AST creator = name.getAST();
        boolean fullyQualified = false;
        if (name instanceof QualifiedName && (left = ASTNodes.getLeftMostSimpleName((QualifiedName)name)).resolveBinding() instanceof IPackageBinding) {
            fullyQualified = true;
        }
        if (fullyQualified) {
            this.fAst.rewriter.markAsReplaced((ASTNode)name, (ASTNode)ASTNodeFactory.newName(creator, type.getQualifiedName()), this.fAst.createGroupDescription(REFERENCE_UPDATE));
        } else {
            this.fAst.rewriter.markAsReplaced((ASTNode)name, (ASTNode)creator.newSimpleName(type.getName()), this.fAst.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        }
    }

    private void rewriteExpression(ASTNode node, Expression exp, ITypeBinding type) {
        SimpleName replace = node.getAST().newSimpleName(type.getName());
        this.fAst.rewriter.markAsReplaced((ASTNode)exp, (ASTNode)replace, this.fAst.createGroupDescription(REFERENCE_UPDATE));
        this.fNeedsImport = true;
        this.nonStaticAccess(node);
    }

    protected void nonStaticAccess(ASTNode node) {
        this.fStatus.addWarning(RefactoringCoreMessages.getString("MoveStaticMemberAnalyzer.nonStatic"), JavaStatusContext.create(this.fAst.unit, node));
    }

    protected boolean isStaticAccess(Expression exp, ITypeBinding type) {
        if (!(exp instanceof Name)) {
            return false;
        }
        return Bindings.equals((IBinding)type, ((Name)exp).resolveBinding());
    }

    protected boolean isMovedMember(IBinding binding) {
        if (binding == null) {
            return false;
        }
        int i = 0;
        while (i < this.fMembers.length) {
            if (Bindings.equals(this.fMembers[i], binding)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

