/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.ExceptionInfo;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ChangeSignatureRefactoring
extends Refactoring {
    private final List fParameterInfos;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private final ImportRewriteManager fImportManager;
    private CompilationUnit fCU;
    private List fExceptionInfos;
    private TextChangeManager fChangeManager;
    private IMethod fMethod;
    private IMethod[] fRippleMethods;
    private SearchResultGroup[] fOccurrences;
    private String fReturnTypeName;
    private int fVisibility;
    private static final String CONST_CLASS_DECL = "class A{";
    private static final String CONST_ASSIGN = " i=";
    private static final String CONST_CLOSE = ";}";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private ChangeSignatureRefactoring(IMethod method, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        Assert.isNotNull(method);
        this.fMethod = method;
        this.fParameterInfos = ChangeSignatureRefactoring.createParameterInfoList(method);
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fImportManager = new ImportRewriteManager(this.fCodeGenerationSettings);
        this.fReturnTypeName = this.getInitialReturnTypeName();
        this.fVisibility = this.getInitialMethodVisibility();
    }

    public static ChangeSignatureRefactoring create(IMethod method, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!ChangeSignatureRefactoring.isAvailable(method)) {
            return null;
        }
        return new ChangeSignatureRefactoring(method, codeGenerationSettings);
    }

    public static boolean isAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        return Checks.isAvailable((IJavaElement)method);
    }

    private String getInitialReturnTypeName() throws JavaModelException {
        return Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature()));
    }

    private int getInitialMethodVisibility() throws JavaModelException {
        return JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private static List createParameterInfoList(IMethod method) {
        try {
            String[] typeNames = method.getParameterTypes();
            String[] oldNames = method.getParameterNames();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(typeNames.length);
            int i = 0;
            while (i < oldNames.length) {
                result.add(new ParameterInfo(Signature.toString((String)typeNames[i]), oldNames[i], i));
                ++i;
            }
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new ArrayList(0);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ChangeSignatureRefactoring.modify_Parameters");
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public void setNewReturnTypeName(String newReturnTypeName) {
        Assert.isNotNull(newReturnTypeName);
        this.fReturnTypeName = newReturnTypeName;
    }

    public boolean canChangeReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
        this.fVisibility = visibility;
    }

    public int[] getAvailableVisibilities() throws JavaModelException {
        if (this.fMethod.getDeclaringType().isInterface()) {
            return new int[]{1};
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public List getExceptionInfos() {
        return this.fExceptionInfos;
    }

    public RefactoringStatus checkSignature() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.checkForDuplicateNames(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkParameters(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkReturnType(result);
        return result;
    }

    public boolean isSignatureSameAsInitial() throws JavaModelException {
        if (!this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (!this.isReturnTypeSameAsInitial()) {
            return false;
        }
        if (!this.areExceptionsSameAsInitial()) {
            return false;
        }
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && !this.areAnyParametersDeleted() && this.areParameterTypesSameAsInitial();
    }

    private boolean areParameterTypesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnTypeSameAsInitial() throws JavaModelException {
        return this.fReturnTypeName.equals(this.getInitialReturnTypeName());
    }

    private boolean areAnyParametersDeleted() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            return true;
        }
        return false;
    }

    private boolean areExceptionsSameAsInitial() {
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isOld()) continue;
            return false;
        }
        return true;
    }

    private void checkParameters(RefactoringStatus result) {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isDeleted()) continue;
            this.checkParameterType(result, info);
            if (result.hasFatalError()) {
                return;
            }
            result.merge(Checks.checkTempName(info.getNewName()));
            if (result.hasFatalError()) {
                return;
            }
            if (!info.isAdded()) continue;
            this.checkParameterDefaultValue(result, info);
        }
    }

    private void checkReturnType(RefactoringStatus result) {
        if (!ChangeSignatureRefactoring.isValidTypeName(this.fReturnTypeName, true)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_return_type", new String[]{this.fReturnTypeName});
            result.addFatalError(msg);
        }
    }

    private void checkParameterDefaultValue(RefactoringStatus result, ParameterInfo info) {
        if (info.getDefaultValue().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.default_value", new String[]{info.getNewName()});
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidExpression(info.getDefaultValue())) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_expression", new String[]{info.getDefaultValue()});
            result.addFatalError(msg);
        }
    }

    private void checkParameterType(RefactoringStatus result, ParameterInfo info) {
        if (!info.isAdded() && !info.isTypeNameChanged()) {
            return;
        }
        if (info.getNewTypeName().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_type", new String[]{info.getNewName()});
            if (info.isAdded() && info.getNewName().trim().equals("")) {
                msg = RefactoringCoreMessages.getString("ChangeSignatureRefactoring.new_parameter");
            }
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidTypeName(info.getNewTypeName(), false)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_type_name", new String[]{info.getNewTypeName()});
            result.addFatalError(msg);
        }
    }

    private static boolean isValidTypeName(String string, boolean isVoidAllowed) {
        if ("".equals(string.trim())) {
            return false;
        }
        if (!string.trim().equals(string)) {
            return false;
        }
        if (PrimitiveType.toCode((String)string) == PrimitiveType.VOID) {
            return isVoidAllowed;
        }
        if (!Checks.checkTypeName(string).hasFatalError()) {
            return true;
        }
        if (ChangeSignatureRefactoring.isPrimitiveTypeName(string)) {
            return true;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL);
        int offset = cuBuff.length();
        cuBuff.append(string).append(CONST_ASSIGN).append("null").append(CONST_CLOSE);
        CompilationUnit cu = AST.parseCompilationUnit((char[])cuBuff.toString().toCharArray());
        Selection selection = Selection.createFromStartLength(offset, string.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (!(selected instanceof Type)) {
            return false;
        }
        Type type = (Type)selected;
        if (ChangeSignatureRefactoring.isVoidArrayType(type)) {
            return false;
        }
        return string.equals(cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type)));
    }

    public static boolean isValidParameterTypeName(String string) {
        return ChangeSignatureRefactoring.isValidTypeName(string, false);
    }

    private static boolean isVoidArrayType(Type type) {
        if (!type.isArrayType()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)type;
        if (!arrayType.getComponentType().isPrimitiveType()) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
        return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
    }

    private static boolean isValidExpression(String string) {
        String trimmed = string.trim();
        if ("".equals(trimmed)) {
            return false;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL).append("Object").append(CONST_ASSIGN);
        int offset = cuBuff.length();
        cuBuff.append(trimmed).append(CONST_CLOSE);
        CompilationUnit cu = AST.parseCompilationUnit((char[])cuBuff.toString().toCharArray());
        Selection selection = Selection.createFromStartLength(offset, trimmed.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        return selected instanceof Expression && trimmed.equals(cuBuff.substring(selected.getStartPosition(), ASTNodes.getExclusiveEnd(selected)));
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block11: {
            block9: {
                block10: {
                    IMethod orig;
                    block8: {
                        block7: {
                            RefactoringStatus refactoringStatus;
                            try {
                                pm.beginTask("", 2);
                                result = Checks.checkIfCuBroken((IMember)this.fMethod);
                                if (!result.hasFatalError()) break block7;
                                refactoringStatus = result;
                                Object var5_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_15 = null;
                                pm.done();
                                throw throwable;
                            }
                            pm.done();
                            return refactoringStatus;
                        }
                        orig = (IMethod)WorkingCopyUtil.getOriginal((IMember)this.fMethod);
                        if (orig != null && orig.exists()) break block8;
                        String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.method_deleted", this.fMethod.getCompilationUnit().getElementName());
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus(message);
                        Object var5_10 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    this.fMethod = orig;
                    if (!MethodChecks.isVirtual(this.fMethod) || this.fMethod.getDeclaringType().isInterface()) break block9;
                    result.merge(MethodChecks.checkIfComesFromInterface(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    if (!result.hasFatalError()) break block10;
                    RefactoringStatus refactoringStatus = result;
                    Object var5_11 = null;
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (!result.hasFatalError()) break block9;
                RefactoringStatus refactoringStatus = result;
                Object var5_12 = null;
                pm.done();
                return refactoringStatus;
            }
            if (!this.fMethod.getDeclaringType().isInterface()) break block11;
            result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!result.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus = result;
            Object var5_13 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fCU = AST.parseCompilationUnit((ICompilationUnit)this.getCu(), (boolean)true);
        this.fExceptionInfos = this.createExceptionInfoList();
        RefactoringStatus refactoringStatus = result;
        Object var5_14 = null;
        pm.done();
        return refactoringStatus;
    }

    private List createExceptionInfoList() {
        try {
            IJavaProject project = this.fMethod.getJavaProject();
            ASTNode nameNode = NodeFinder.perform((ASTNode)this.fCU, this.fMethod.getNameRange());
            if (nameNode == null || !(nameNode instanceof Name) || !(nameNode.getParent() instanceof MethodDeclaration)) {
                return new ArrayList(0);
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)nameNode.getParent();
            List exceptions = methodDeclaration.thrownExceptions();
            ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(exceptions.size());
            int i = 0;
            while (i < exceptions.size()) {
                Name name = (Name)exceptions.get(i);
                ITypeBinding typeBinding = name.resolveTypeBinding();
                IType type = Bindings.findType(typeBinding, project);
                result.add(ExceptionInfo.createInfoForOldException(type, typeBinding));
                ++i;
            }
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new ArrayList(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block18: {
            RefactoringStatus refactoringStatus2;
            block17: {
                RefactoringStatus refactoringStatus3;
                block16: {
                    RefactoringStatus refactoringStatus4;
                    block15: {
                        RefactoringStatus refactoringStatus5;
                        block14: {
                            try {
                                try {
                                    pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 7);
                                    RefactoringStatus result = new RefactoringStatus();
                                    this.clearManagers();
                                    if (this.isSignatureSameAsInitial()) {
                                        refactoringStatus5 = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.unchanged"));
                                        Object var3_10 = null;
                                        break block14;
                                    }
                                    result.merge(this.checkSignature());
                                    if (result.hasFatalError()) {
                                        refactoringStatus4 = result;
                                        break block15;
                                    }
                                    this.fRippleMethods = RippleMethodFinder.getRelatedMethods(this.fMethod, (IProgressMonitor)new SubProgressMonitor(pm, 1), null);
                                    this.fOccurrences = this.findOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                    result.merge(this.checkVisibilityChanges());
                                    if (!this.isOrderSameAsInitial()) {
                                        result.merge(this.checkReorderings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                    } else {
                                        pm.worked(1);
                                    }
                                    if (!this.areNamesSameAsInitial()) {
                                        result.merge(this.checkRenamings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                    } else {
                                        pm.worked(1);
                                    }
                                    if (result.hasFatalError()) {
                                        refactoringStatus3 = result;
                                        break block16;
                                    }
                                    result.merge(this.collectAndCheckImports((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                    result.merge(this.checkIfDeletedParametersUsed());
                                    if (this.mustAnalyzeAstOfDeclaringCu()) {
                                        result.merge(this.checkCompilationofDeclaringCu());
                                    }
                                    if (result.hasFatalError()) {
                                        refactoringStatus2 = result;
                                        break block17;
                                    }
                                    result.merge(this.validateModifiesFiles());
                                    refactoringStatus = result;
                                    break block18;
                                }
                                catch (JavaModelException e) {
                                    throw e;
                                }
                                catch (CoreException e) {
                                    throw new JavaModelException(e);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var3_15 = null;
                                pm.done();
                                throw throwable;
                            }
                        }
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var3_11 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_12 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_13 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_14 = null;
        pm.done();
        return refactoringStatus;
    }

    private void clearManagers() {
        this.fImportManager.clear();
    }

    private RefactoringStatus collectAndCheckImports(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        List notDeletedParams = this.getNotDeletedInfos();
        List addedExceptions = this.getAddedExceptions();
        pm.beginTask("", notDeletedParams.size() + addedExceptions.size());
        Iterator iter = notDeletedParams.iterator();
        while (iter.hasNext()) {
            String typeName;
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isTypeNameChanged() || ChangeSignatureRefactoring.isPrimitiveTypeName(typeName = ChangeSignatureRefactoring.getSimpleParameterTypeName(info)) || this.tryResolvingType(typeName)) continue;
            result.merge(this.tryFinidingInTypeCache(typeName, info, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        iter = addedExceptions.iterator();
        while (iter.hasNext()) {
            ExceptionInfo exInfo = (ExceptionInfo)iter.next();
            String fullName = JavaModelUtil.getFullyQualifiedName(exInfo.getType());
            this.importToAllCusOfRippleMethods(fullName);
        }
        pm.done();
        return result;
    }

    private boolean tryResolvingType(String typeName) throws CoreException {
        String[][] fqns = this.getMethod().getDeclaringType().resolveType(typeName);
        if (fqns == null || fqns.length != 1) {
            return false;
        }
        String fullName = JavaModelUtil.concatenateName(fqns[0][0], fqns[0][1]);
        this.importToAllCusOfRippleMethods(fullName);
        return true;
    }

    private RefactoringStatus tryFinidingInTypeCache(String typeName, ParameterInfo info, IProgressMonitor pm) throws CoreException {
        List typeRefsFound = this.findTypeInfos(typeName, pm);
        if (typeRefsFound.size() == 0) {
            String[] keys = new String[]{info.getNewTypeName()};
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.not_unique", keys);
            return RefactoringStatus.createErrorStatus(msg);
        }
        if (typeRefsFound.size() == 1) {
            TypeInfo typeInfo = (TypeInfo)typeRefsFound.get(0);
            String fullName = typeInfo.getFullyQualifiedName();
            this.importToAllCusOfRippleMethods(fullName);
            return new RefactoringStatus();
        }
        Assert.isTrue(typeRefsFound.size() > 1);
        String[] keys = new String[]{info.getNewTypeName(), String.valueOf(typeRefsFound.size())};
        String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.ambiguous", keys);
        return RefactoringStatus.createErrorStatus(msg);
    }

    private List findTypeInfos(String typeName, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.getMethod().getJavaProject()}, (boolean)true);
        IPackageFragment currPackage = this.getMethod().getDeclaringType().getPackageFragment();
        TypeInfo[] infos = AllTypesCache.getTypesForName(typeName, scope, pm);
        ArrayList<TypeInfo> typeRefsFound = new ArrayList<TypeInfo>();
        int i = 0;
        while (i < infos.length) {
            TypeInfo curr = infos[i];
            IType type = curr.resolveType(scope);
            if (type != null && JavaModelUtil.isVisible((IMember)type, currPackage)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound;
    }

    private void importToAllCusOfRippleMethods(String fullName) throws CoreException {
        int i = 0;
        while (i < this.fRippleMethods.length) {
            ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(this.fRippleMethods[i].getCompilationUnit());
            this.fImportManager.addImportTo(fullName, wc);
            ++i;
        }
    }

    private static boolean isPrimitiveTypeName(String typeName) {
        return PrimitiveType.toCode((String)typeName) != null;
    }

    private static String getSimpleParameterTypeName(ParameterInfo info) {
        String typeName = info.getNewTypeName();
        if (typeName.indexOf(91) != -1) {
            typeName = typeName.substring(0, typeName.indexOf(91));
        }
        return typeName.trim();
    }

    private RefactoringStatus checkIfDeletedParametersUsed() {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fOccurrences.length) {
            SearchResultGroup group = this.fOccurrences[i];
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(group.getCompilationUnit());
            if (cu != null) {
                CompilationUnit cuNode = cu.equals(this.getCu()) ? this.fCU : AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)true);
                ASTNode[] methodOccurrences = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cuNode);
                int j = 0;
                while (j < methodOccurrences.length) {
                    MethodDeclaration decl;
                    ASTNode methodOccurrence = methodOccurrences[j];
                    if (!ChangeSignatureRefactoring.isReferenceNode(methodOccurrence) && (decl = ChangeSignatureRefactoring.getMethodDeclaration(methodOccurrence)) != null) {
                        String typeName = this.getFullTypeName(decl);
                        Iterator iter = this.getDeletedInfos().iterator();
                        while (iter.hasNext()) {
                            ParameterInfo info = (ParameterInfo)iter.next();
                            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)decl.parameters().get(info.getOldIndex());
                            ASTNode[] paramRefs = TempOccurrenceFinder.findTempOccurrenceNodes((VariableDeclaration)paramDecl, true, false);
                            if (paramRefs.length <= 0) continue;
                            Context context = JavaStatusContext.create(cu, paramRefs[0]);
                            Object[] keys = new String[]{paramDecl.getName().getIdentifier(), decl.getName().getIdentifier(), typeName};
                            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_used", keys);
                            result.addWarning(msg, context);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private String getFullTypeName(MethodDeclaration decl) {
        AnonymousClassDeclaration anonymous;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.TypeDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TypeDeclaration typeDecl = (TypeDeclaration)ASTNodes.getParent((ASTNode)decl, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.jdt.core.dom.AnonymousClassDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)decl, clazz2)) != null && ASTNodes.isParent((ASTNode)typeDecl, (ASTNode)anonymous)) {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("[Lorg.eclipse.jdt.core.dom.ClassInstanceCreation;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassInstanceCreation cic = (ClassInstanceCreation)ASTNodes.getParent((ASTNode)decl, clazz3);
            return RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.anonymous_subclass", new String[]{ASTNodes.asString((ASTNode)cic.getName())});
        }
        return typeDecl.getName().getIdentifier();
    }

    private RefactoringStatus checkVisibilityChanges() throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return null;
        }
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        Assert.isTrue(this.getInitialMethodVisibility() != 2);
        if (this.fVisibility == 2) {
            return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.non-virtual"));
        }
        return null;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getPreviewOfVisibityString());
        if (Flags.isStatic((int)this.getMethod().getFlags())) {
            buff.append("static ");
        }
        if (!this.getMethod().isConstructor()) {
            buff.append(this.getReturnTypeString()).append(' ');
        }
        buff.append(this.getMethod().getElementName()).append('(').append(this.getMethodParameters()).append(')');
        buff.append(this.getMethodThrows());
        return buff.toString();
    }

    private String getPreviewOfVisibityString() {
        String visibilityString = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibilityString)) {
            return visibilityString;
        }
        return String.valueOf(visibilityString) + ' ';
    }

    private String getMethodThrows() throws JavaModelException {
        StringBuffer buff = new StringBuffer(" throws ");
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isDeleted()) continue;
            buff.append(info.getType().getElementName());
            buff.append(", ");
        }
        if (buff.length() == " throws ".length()) {
            return "";
        }
        buff.delete(buff.length() - 2, buff.length());
        return buff.toString();
    }

    private void checkForDuplicateNames(RefactoringStatus result) {
        HashSet<String> found = new HashSet<String>();
        HashSet<String> doubled = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            String newName = info.getNewName();
            if (found.contains(newName) && !doubled.contains(newName)) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.duplicate_name", newName));
                doubled.add(newName);
                continue;
            }
            found.add(newName);
        }
    }

    private ICompilationUnit getCu() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.fMethod.getCompilationUnit());
    }

    private boolean mustAnalyzeAstOfDeclaringCu() throws JavaModelException {
        if (JdtFlags.isAbstract((IMember)this.getMethod())) {
            return false;
        }
        if (JdtFlags.isNative((IMember)this.getMethod())) {
            return false;
        }
        return !this.getMethod().getDeclaringType().isInterface();
    }

    private RefactoringStatus checkCompilationofDeclaringCu() throws CoreException {
        ICompilationUnit cu = this.getCu();
        TextChange change = this.fChangeManager.get(cu);
        String newCuSource = change.getPreviewContent();
        CompilationUnit newCUNode = AST.parseCompilationUnit((char[])newCuSource.toCharArray(), (String)cu.getElementName(), (IJavaProject)cu.getJavaProject());
        IProblem[] problems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCU);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (this.shouldReport(problem)) {
                result.addEntry(JavaRefactorings.createStatusEntry(problem, newCuSource));
            }
            ++i;
        }
        return result;
    }

    private boolean shouldReport(IProblem problem) {
        if (!problem.isError()) {
            return false;
        }
        return problem.getID() != 67109234;
    }

    public String getReturnTypeString() {
        return this.fReturnTypeName;
    }

    private String getMethodParameters() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureRefactoring.createDeclarationString(info));
            ++i;
        }
        return buff.toString();
    }

    private List getDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private List getNotDeletedInfos() {
        ArrayList all = new ArrayList(this.fParameterInfos);
        all.removeAll(this.getDeletedInfos());
        return all;
    }

    private List getAddedExceptions() {
        ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>(1);
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (!info.isAdded()) continue;
            result.add(info);
        }
        return result;
    }

    private boolean areNamesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isRenamed()) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int i = 0;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.getOldIndex() != i) {
                return false;
            }
            if (info.isAdded()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkReorderings(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 1);
            refactoringStatus = this.checkNativeMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkRenamings(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 1);
            refactoringStatus = this.checkParameterNamesInRippleMethods();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkParameterNamesInRippleMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        Set newParameterNames = this.getNewParameterNamesList();
        int i = 0;
        while (i < this.fRippleMethods.length) {
            String[] paramNames = this.fRippleMethods[i].getParameterNames();
            int j = 0;
            while (j < paramNames.length) {
                if (newParameterNames.contains(paramNames[j])) {
                    String[] args = new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), paramNames[j]};
                    String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.already_has", args);
                    Context context = JavaStatusContext.create(this.fRippleMethods[i].getCompilationUnit(), this.fRippleMethods[i].getNameRange());
                    result.addError(msg, context);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Set getNewParameterNamesList() {
        Set oldNames = this.getOriginalParameterNames();
        Set currentNames = this.getNamesOfNotDeletedParameters();
        currentNames.removeAll(oldNames);
        return currentNames;
    }

    private Set getNamesOfNotDeletedParameters() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            result.add(info.getNewName());
        }
        return result;
    }

    private Set getOriginalParameterNames() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded()) continue;
            result.add(info.getOldName());
        }
        return result;
    }

    private RefactoringStatus checkNativeMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fRippleMethods.length) {
            if (JdtFlags.isNative((IMember)this.fRippleMethods[i])) {
                String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.native", new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), JavaModelUtil.getFullyQualifiedName(this.fRippleMethods[i].getDeclaringType())});
                result.addError(message, JavaStatusContext.create((IMember)this.fRippleMethods[i]));
            }
            ++i;
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        pm.beginTask("", 1);
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.restructure_parameters"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearManagers();
            throw throwable;
        }
        pm.done();
        this.clearManagers();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.preview"), 2);
        TextChangeManager manager = new TextChangeManager();
        boolean isNoArgConstructor = this.isNoArgConstructor();
        Map namedSubclassMapping = null;
        if (isNoArgConstructor) {
            namedSubclassMapping = this.createNamedSubclassMapping((IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            pm.worked(1);
        }
        int i = 0;
        while (i < this.fOccurrences.length) {
            SearchResultGroup group = this.fOccurrences[i];
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(group.getCompilationUnit());
            if (cu != null) {
                CompilationUnit cuNode = cu.equals(this.getCu()) ? this.fCU : AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)true);
                ASTRewrite rewrite = new ASTRewrite((ASTNode)cuNode);
                ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(group.getSearchResults(), cuNode);
                int j = 0;
                while (j < nodes.length) {
                    this.updateMethodOccurrenceNode(rewrite, nodes[j]);
                    ++j;
                }
                if (isNoArgConstructor && namedSubclassMapping.containsKey(cu)) {
                    Set subtypes = (Set)namedSubclassMapping.get(cu);
                    Iterator iter = subtypes.iterator();
                    while (iter.hasNext()) {
                        IType subtype = (IType)iter.next();
                        TypeDeclaration subtypeNode = ASTNodeSearchUtil.getTypeDeclarationNode(subtype, cuNode);
                        if (subtypeNode == null) continue;
                        this.modifyImplicitCallsToNoArgConstructor(subtypeNode, rewrite);
                    }
                }
                this.addTextEditFromRewrite(manager, cu, rewrite);
            }
            ++i;
        }
        pm.done();
        return manager;
    }

    private void updateMethodOccurrenceNode(ASTRewrite rewrite, ASTNode node) throws JavaModelException {
        if (ChangeSignatureRefactoring.isReferenceNode(node)) {
            this.updateReferenceNode(node, rewrite);
        } else {
            this.updateDeclarationNode(node, rewrite);
        }
    }

    private Map createNamedSubclassMapping(IProgressMonitor pm) throws JavaModelException {
        IType[] subclasses = this.getSubclasses(pm);
        HashMap result = new HashMap();
        int i = 0;
        while (i < subclasses.length) {
            IType subclass = subclasses[i];
            if (!subclass.isAnonymous()) {
                ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(subclass.getCompilationUnit());
                if (!result.containsKey(cu)) {
                    result.put(cu, new HashSet());
                }
                ((Set)result.get(cu)).add(subclass);
            }
            ++i;
        }
        return result;
    }

    private void modifyImplicitCallsToNoArgConstructor(TypeDeclaration subclass, ASTRewrite rewrite) {
        MethodDeclaration[] constructors = this.getAllConstructors(subclass);
        if (constructors.length == 0) {
            this.addNewConstructorToSubclass(subclass, rewrite);
        } else {
            int i = 0;
            while (i < constructors.length) {
                if (ChangeSignatureRefactoring.containsImplicitCallToSuperConstructor(constructors[i])) {
                    SuperConstructorInvocation superCall = this.addExplicitSuperConstructorCall(constructors[i], rewrite);
                    rewrite.markAsInserted((ASTNode)superCall);
                }
                ++i;
            }
        }
    }

    private SuperConstructorInvocation addExplicitSuperConstructorCall(MethodDeclaration constructor, ASTRewrite rewrite) {
        SuperConstructorInvocation superCall = constructor.getAST().newSuperConstructorInvocation();
        this.addArgumentsToNewSuperConstructorCall(superCall, rewrite);
        constructor.getBody().statements().add(0, superCall);
        return superCall;
    }

    private void addArgumentsToNewSuperConstructorCall(SuperConstructorInvocation superCall, ASTRewrite rewrite) {
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            superCall.arguments().add(i, ChangeSignatureRefactoring.createNewExpression(rewrite, info, false));
            ++i;
        }
    }

    private static boolean containsImplicitCallToSuperConstructor(MethodDeclaration constructor) {
        Assert.isTrue(constructor.isConstructor());
        Block body = constructor.getBody();
        if (body == null) {
            return false;
        }
        if (body.statements().size() == 0) {
            return true;
        }
        if (body.statements().get(0) instanceof ConstructorInvocation) {
            return false;
        }
        return !(body.statements().get(0) instanceof SuperConstructorInvocation);
    }

    private void addNewConstructorToSubclass(TypeDeclaration subclass, ASTRewrite rewrite) {
        AST ast = subclass.getAST();
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setName(ast.newSimpleName(subclass.getName().getIdentifier()));
        newConstructor.setConstructor(true);
        newConstructor.setBody(ast.newBlock());
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.setModifiers(ChangeSignatureRefactoring.getAccessModifier(subclass));
        newConstructor.setReturnType((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        this.addExplicitSuperConstructorCall(newConstructor, rewrite);
        subclass.bodyDeclarations().add(0, newConstructor);
        rewrite.markAsInserted((ASTNode)newConstructor);
    }

    private static int getAccessModifier(TypeDeclaration subclass) {
        int modifiers = subclass.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return 1;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return 4;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return 2;
        }
        return 0;
    }

    private MethodDeclaration[] getAllConstructors(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(1);
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                result.add(methods[i]);
            }
            ++i;
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private IType[] getSubclasses(IProgressMonitor pm) throws JavaModelException {
        return this.fMethod.getDeclaringType().newTypeHierarchy(pm).getSubclasses(this.fMethod.getDeclaringType());
    }

    private boolean isNoArgConstructor() throws JavaModelException {
        return this.fMethod.isConstructor() && this.fMethod.getNumberOfParameters() == 0;
    }

    private void addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        if (this.fImportManager.hasImportEditFor(cu)) {
            resultingEdits.addChild(this.fImportManager.getImportRewrite(cu).createEdit(textBuffer));
        }
        if (resultingEdits.hasChildren() || manager.containsChangesIn(cu)) {
            TextChange textChange = manager.get(cu);
            textChange.addTextEdit(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.modify_parameters"), (TextEdit)resultingEdits);
        }
        rewrite.removeModifications();
    }

    private void updateDeclarationNode(ASTNode methodOccurrence, ASTRewrite rewrite) throws JavaModelException {
        MethodDeclaration methodDeclaration = ChangeSignatureRefactoring.getMethodDeclaration(methodOccurrence);
        if (methodDeclaration == null) {
            return;
        }
        this.changeParameterNames(methodDeclaration, rewrite);
        if (!methodDeclaration.isConstructor()) {
            this.changeReturnType(methodDeclaration, rewrite);
        }
        this.changeParameterTypes(methodDeclaration, rewrite);
        if (this.needsVisibilityUpdate(methodDeclaration)) {
            this.changeVisibility(methodDeclaration, rewrite);
        }
        this.reshuffleElements(methodOccurrence, methodDeclaration.parameters(), rewrite);
        this.changeExceptions(methodDeclaration, rewrite);
    }

    private void changeParameterTypes(MethodDeclaration methodDeclaration, ASTRewrite rewrite) {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)methodDeclaration.parameters().get(info.getOldIndex());
            this.replaceTypeNode(oldParam.getType(), info.getNewTypeName(), rewrite);
            this.removeExtraDimensions(oldParam, rewrite);
        }
    }

    private void removeExtraDimensions(SingleVariableDeclaration oldParam, ASTRewrite rewrite) {
        if (oldParam.getExtraDimensions() != 0) {
            rewrite.markAsReplaced((ASTNode)oldParam, 17, new Integer(0), null);
        }
    }

    private void replaceTypeNode(Type typeNode, String newTypeName, ASTRewrite rewrite) {
        Type newParamType = (Type)rewrite.createPlaceholder(newTypeName, 6);
        rewrite.markAsReplaced((ASTNode)typeNode, (ASTNode)newParamType);
    }

    private void changeReturnType(MethodDeclaration methodDeclaration, ASTRewrite rewrite) throws JavaModelException {
        if (!this.isReturnTypeSameAsInitial()) {
            this.replaceTypeNode(methodDeclaration.getReturnType(), this.fReturnTypeName, rewrite);
        }
    }

    private void changeVisibility(MethodDeclaration methodDeclaration, ASTRewrite rewrite) {
        int newModifiers = this.getNewModifiers(methodDeclaration);
        rewrite.markAsReplaced((ASTNode)methodDeclaration, 34, new Integer(newModifiers), null);
    }

    private void updateReferenceNode(ASTNode methodOccurrence, ASTRewrite rewrite) {
        this.reshuffleElements(methodOccurrence, ChangeSignatureRefactoring.getArguments(methodOccurrence), rewrite);
    }

    private void reshuffleElements(ASTNode methodOccurrence, List elementList, ASTRewrite rewrite) {
        ParameterInfo info;
        AST ast = methodOccurrence.getAST();
        boolean isReference = ChangeSignatureRefactoring.isReferenceNode(methodOccurrence);
        boolean isRecursiveReference = isReference ? ChangeSignatureRefactoring.isRecursiveReference(methodOccurrence) : false;
        ASTNode[] nodes = ChangeSignatureRefactoring.getSubNodesOfMethodOccurrenceNode(methodOccurrence);
        this.deleteExcessiveElements(rewrite, nodes);
        List nonDeletedInfos = this.getNotDeletedInfos();
        ASTNode[] newPermutation = new ASTNode[nonDeletedInfos.size()];
        int i = 0;
        while (i < newPermutation.length) {
            info = (ParameterInfo)nonDeletedInfos.get(i);
            newPermutation[i] = info.isAdded() ? this.createNewElementForList(rewrite, ast, info, isReference, isRecursiveReference) : (info.getOldIndex() != i ? (rewrite.isReplaced(nodes[info.getOldIndex()]) ? rewrite.getReplacingNode(nodes[info.getOldIndex()]) : rewrite.createCopy(nodes[info.getOldIndex()])) : nodes[i]);
            ++i;
        }
        i = 0;
        while (i < Math.min(nodes.length, newPermutation.length)) {
            if (nodes[i] != newPermutation[i]) {
                rewrite.markAsReplaced(nodes[i], newPermutation[i]);
            }
            ++i;
        }
        i = nodes.length;
        while (i < newPermutation.length) {
            info = (ParameterInfo)nonDeletedInfos.get(i);
            if (info.isAdded()) {
                ASTNode newElement = this.createNewElementForList(rewrite, ast, info, isReference, isRecursiveReference);
                elementList.add(i, newElement);
                rewrite.markAsInserted(newElement);
            } else {
                elementList.add(i, newPermutation[i]);
                rewrite.markAsInserted(newPermutation[i]);
            }
            ++i;
        }
    }

    private void deleteExcessiveElements(ASTRewrite rewrite, ASTNode[] nodes) {
        int i = this.getNotDeletedInfos().size();
        while (i < nodes.length) {
            rewrite.markAsRemoved(nodes[i]);
            ++i;
        }
    }

    private ASTNode createNewElementForList(ASTRewrite rewrite, AST ast, ParameterInfo info, boolean isReferenceNode, boolean isRecursiveReference) {
        if (isReferenceNode) {
            return ChangeSignatureRefactoring.createNewExpression(rewrite, info, isRecursiveReference);
        }
        return ChangeSignatureRefactoring.createNewSingleVariableDeclaration(rewrite, ast, info);
    }

    private static SingleVariableDeclaration createNewSingleVariableDeclaration(ASTRewrite rewrite, AST ast, ParameterInfo info) {
        SingleVariableDeclaration newP = ast.newSingleVariableDeclaration();
        newP.setName(ast.newSimpleName(info.getNewName()));
        newP.setType((Type)rewrite.createPlaceholder(info.getNewTypeName(), 6));
        return newP;
    }

    private static Expression createNewExpression(ASTRewrite rewrite, ParameterInfo info, boolean isRecursiveReference) {
        if (isRecursiveReference) {
            return (Expression)rewrite.createPlaceholder(info.getNewName(), 3);
        }
        return (Expression)rewrite.createPlaceholder(info.getDefaultValue(), 3);
    }

    private int getNewModifiers(MethodDeclaration md) {
        return JdtFlags.clearAccessModifiers(md.getModifiers()) | this.fVisibility;
    }

    private boolean needsVisibilityUpdate(MethodDeclaration methodDeclaration) throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (this.isIncreasingVisibility()) {
            return JdtFlags.isHigherVisibility(this.fVisibility, JdtFlags.getVisibilityCode((BodyDeclaration)methodDeclaration));
        }
        return JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((BodyDeclaration)methodDeclaration), this.fVisibility);
    }

    private boolean isIncreasingVisibility() throws JavaModelException {
        return JdtFlags.isHigherVisibility(this.fVisibility, JdtFlags.getVisibilityCode((IMember)this.fMethod));
    }

    private boolean isVisibilitySameAsInitial() throws JavaModelException {
        return this.fVisibility == JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    private SearchResultGroup[] findOccurrences(IProgressMonitor pm) throws JavaModelException {
        if (this.fMethod.isConstructor()) {
            return ConstructorReferenceFinder.getConstructorOccurrences(this.fMethod, pm);
        }
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern((IJavaElement[])this.fRippleMethods, 3);
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), pattern);
    }

    private void changeParameterNames(MethodDeclaration methodDeclaration, ASTRewrite rewrite) throws JavaModelException {
        Iterator iterator = this.getParameterInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo info = (ParameterInfo)iterator.next();
            if (info.isAdded() || !info.isRenamed()) continue;
            SingleVariableDeclaration param = (SingleVariableDeclaration)methodDeclaration.parameters().get(info.getOldIndex());
            if (!info.getOldName().equals(param.getName().getIdentifier())) continue;
            ASTNode[] paramOccurrences = TempOccurrenceFinder.findTempOccurrenceNodes((VariableDeclaration)param, true, true);
            int j = 0;
            while (j < paramOccurrences.length) {
                ASTNode occurence = paramOccurrences[j];
                if (occurence instanceof SimpleName) {
                    SimpleName newName = occurence.getAST().newSimpleName(info.getNewName());
                    rewrite.markAsReplaced(occurence, (ASTNode)newName);
                }
                ++j;
            }
        }
    }

    private void changeExceptions(MethodDeclaration methodDeclaration, ASTRewrite rewrite) {
        Iterator iter = this.fExceptionInfos.iterator();
        while (iter.hasNext()) {
            ExceptionInfo info = (ExceptionInfo)iter.next();
            if (info.isOld()) continue;
            if (info.isDeleted()) {
                this.removeExceptionFromNodeList(info, methodDeclaration.thrownExceptions(), rewrite);
                continue;
            }
            this.addExceptionToNodeList(info, methodDeclaration.thrownExceptions(), rewrite);
        }
    }

    private void removeExceptionFromNodeList(ExceptionInfo toRemove, List exceptionsNodeList, ASTRewrite rewrite) {
        ITypeBinding typeToRemove = toRemove.getTypeBinding();
        Iterator iter = exceptionsNodeList.iterator();
        while (iter.hasNext()) {
            Name currentName = (Name)iter.next();
            ITypeBinding currentType = currentName.resolveTypeBinding();
            if (!typeToRemove.getQualifiedName().equals(currentType.getQualifiedName())) continue;
            rewrite.markAsRemoved((ASTNode)currentName);
        }
    }

    private void addExceptionToNodeList(ExceptionInfo exceptionInfo, List exceptionsNodeList, ASTRewrite rewrite) {
        String fullyQualified = JavaModelUtil.getFullyQualifiedName(exceptionInfo.getType());
        Iterator iter = exceptionsNodeList.iterator();
        while (iter.hasNext()) {
            Name exName = (Name)iter.next();
            if (!exName.resolveTypeBinding().getQualifiedName().equals(fullyQualified)) continue;
            return;
        }
        String simple = exceptionInfo.getType().getElementName();
        ASTNode exNode = rewrite.createPlaceholder(simple, 7);
        exceptionsNodeList.add(exNode);
        rewrite.markAsInserted(exNode);
    }

    private static ASTNode[] getSubNodesOfMethodOccurrenceNode(ASTNode occurrenceNode) {
        if (ChangeSignatureRefactoring.isReferenceNode(occurrenceNode)) {
            return ChangeSignatureRefactoring.getArguments(occurrenceNode).toArray(new Expression[ChangeSignatureRefactoring.getArguments(occurrenceNode).size()]);
        }
        return ChangeSignatureRefactoring.getSubNodesOfMethodDeclarationNode(occurrenceNode);
    }

    private static SingleVariableDeclaration[] getSubNodesOfMethodDeclarationNode(ASTNode occurrenceNode) {
        Assert.isTrue(!ChangeSignatureRefactoring.isReferenceNode(occurrenceNode));
        MethodDeclaration methodDeclaration = ChangeSignatureRefactoring.getMethodDeclaration(occurrenceNode);
        if (methodDeclaration == null) {
            return new SingleVariableDeclaration[0];
        }
        return methodDeclaration.parameters().toArray(new SingleVariableDeclaration[methodDeclaration.parameters().size()]);
    }

    private static MethodDeclaration getMethodDeclaration(ASTNode node) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[Lorg.eclipse.jdt.core.dom.MethodDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent(node, clazz);
    }

    private static String createDeclarationString(ParameterInfo info) {
        return String.valueOf(info.getNewTypeName()) + " " + info.getNewName();
    }

    private static List getArguments(ASTNode node) {
        if (node instanceof SimpleName && node.getParent() instanceof MethodInvocation) {
            return ((MethodInvocation)node.getParent()).arguments();
        }
        if (node instanceof SimpleName && node.getParent() instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node.getParent()).arguments();
        }
        if (node instanceof SimpleName && node.getParent() instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)node.getParent()).arguments();
        }
        if (node instanceof ExpressionStatement && ChangeSignatureRefactoring.isReferenceNode((ASTNode)((ExpressionStatement)node).getExpression())) {
            return ChangeSignatureRefactoring.getArguments((ASTNode)((ExpressionStatement)node).getExpression());
        }
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).arguments();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).arguments();
        }
        if (node instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)node).arguments();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).arguments();
        }
        if (node instanceof SuperConstructorInvocation) {
            return ((SuperConstructorInvocation)node).arguments();
        }
        return null;
    }

    private static boolean isReferenceNode(ASTNode node) {
        if (node instanceof SimpleName && node.getParent() instanceof MethodInvocation) {
            return true;
        }
        if (node instanceof SimpleName && node.getParent() instanceof SuperMethodInvocation) {
            return true;
        }
        if (node instanceof SimpleName && node.getParent() instanceof ClassInstanceCreation) {
            return true;
        }
        if (node instanceof ExpressionStatement && ChangeSignatureRefactoring.isReferenceNode((ASTNode)((ExpressionStatement)node).getExpression())) {
            return true;
        }
        if (node instanceof MethodInvocation) {
            return true;
        }
        if (node instanceof SuperMethodInvocation) {
            return true;
        }
        if (node instanceof ClassInstanceCreation) {
            return true;
        }
        if (node instanceof ConstructorInvocation) {
            return true;
        }
        return node instanceof SuperConstructorInvocation;
    }

    private static boolean isRecursiveReference(ASTNode node) {
        MethodDeclaration enclosingMethodDeclaration = ChangeSignatureRefactoring.getMethodDeclaration(node);
        if (enclosingMethodDeclaration == null) {
            return false;
        }
        IMethodBinding enclosingMethodBinding = enclosingMethodDeclaration.resolveBinding();
        if (node instanceof SimpleName && node.getParent() instanceof MethodInvocation) {
            return enclosingMethodBinding == ((MethodInvocation)node.getParent()).resolveMethodBinding();
        }
        if (node instanceof SimpleName && node.getParent() instanceof SuperMethodInvocation) {
            IMethodBinding methodBinding = ((SuperMethodInvocation)node.getParent()).resolveMethodBinding();
            return ChangeSignatureRefactoring.isSameMethod(methodBinding, enclosingMethodBinding);
        }
        if (node instanceof SimpleName && node.getParent() instanceof ClassInstanceCreation) {
            return enclosingMethodBinding == ((ClassInstanceCreation)node.getParent()).resolveConstructorBinding();
        }
        if (node instanceof ExpressionStatement && ChangeSignatureRefactoring.isReferenceNode((ASTNode)((ExpressionStatement)node).getExpression())) {
            return ChangeSignatureRefactoring.isRecursiveReference((ASTNode)((ExpressionStatement)node).getExpression());
        }
        if (node instanceof MethodInvocation) {
            return enclosingMethodBinding == ((MethodInvocation)node).resolveMethodBinding();
        }
        if (node instanceof SuperMethodInvocation) {
            IMethodBinding methodBinding = ((SuperMethodInvocation)node).resolveMethodBinding();
            return ChangeSignatureRefactoring.isSameMethod(methodBinding, enclosingMethodBinding);
        }
        if (node instanceof ClassInstanceCreation) {
            return enclosingMethodBinding == ((ClassInstanceCreation)node).resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            return enclosingMethodBinding == ((ConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            return false;
        }
        Assert.isTrue(false);
        return false;
    }

    private static boolean isSameMethod(IMethodBinding m1, IMethodBinding m2) {
        if (m1.isConstructor() ? !m2.isConstructor() : !m1.getName().equals(m2.getName())) {
            return false;
        }
        return Bindings.equals((IBinding[])m1.getParameterTypes(), (IBinding[])m2.getParameterTypes());
    }
}

