/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class SelfEncapsulateFieldRefactoring
extends Refactoring {
    private IField fField;
    private TextChangeManager fChangeManager;
    private CompilationUnit fRoot;
    private VariableDeclarationFragment fFieldDeclaration;
    private ASTRewrite fRewriter;
    private int fVisibility;
    private String fGetterName;
    private String fSetterName;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass;
    private List fUsedReadNames;
    private List fUsedModifyNames;
    private static final String NO_NAME = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private SelfEncapsulateFieldRefactoring(IField field) throws JavaModelException {
        Assert.isNotNull(field);
        this.fField = field;
        this.fChangeManager = new TextChangeManager();
        this.fGetterName = GetterSetterUtil.getGetterName(field, null);
        this.fSetterName = GetterSetterUtil.getSetterName(field, null);
        this.fEncapsulateDeclaringClass = true;
        this.fArgName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags());
        this.checkArgName();
    }

    public static boolean isAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field);
    }

    public static SelfEncapsulateFieldRefactoring create(IField field) throws JavaModelException {
        if (Checks.checkAvailability((IJavaElement)field).hasFatalError()) {
            return null;
        }
        return new SelfEncapsulateFieldRefactoring(field);
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String name) {
        this.fGetterName = name;
        Assert.isNotNull(this.fGetterName);
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String name) {
        this.fSetterName = name;
        Assert.isNotNull(this.fSetterName);
    }

    public void setInsertionIndex(int index) {
        this.fInsertionIndex = index;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setEncapsulateDeclaringClass(boolean encapsulateDeclaringClass) {
        this.fEncapsulateDeclaringClass = encapsulateDeclaringClass;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        this.fVisibility = this.fField.getFlags() & 7;
        RefactoringStatus result = new RefactoringStatus();
        this.fRoot = AST.parseCompilationUnit((ICompilationUnit)this.fField.getCompilationUnit(), (boolean)true);
        ISourceRange sourceRange = this.fField.getNameRange();
        ASTNode node = NodeFinder.perform((ASTNode)this.fRoot, sourceRange.getOffset(), sourceRange.getLength());
        if (node == null) {
            return this.mappingErrorFound(result, node);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.VariableDeclarationFragment;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFieldDeclaration = (VariableDeclarationFragment)ASTNodes.getParent(node, clazz);
        if (this.fFieldDeclaration == null) {
            return this.mappingErrorFound(result, node);
        }
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(result, node)) {
                result.addFatalError(RefactoringCoreMessages.getString("SelfEncapsulateField.type_not_resolveable"));
            }
            return result;
        }
        result.merge(Checks.validateModifiesFiles(new IFile[]{ResourceUtil.getFile(this.fField.getCompilationUnit())}));
        if (result.hasFatalError()) {
            return result;
        }
        this.computeUsedNames();
        this.fRewriter = new ASTRewrite((ASTNode)this.fRoot);
        return result;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_field", new String[]{this.fField.getElementName(), messages[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.cannot_analyze_selected_field", new String[]{this.fField.getElementName()});
    }

    public RefactoringStatus checkMethodNames() {
        RefactoringStatus result = new RefactoringStatus();
        IType declaringType = this.fField.getDeclaringType();
        SelfEncapsulateFieldRefactoring.checkName(result, this.fGetterName, this.fUsedReadNames, declaringType);
        SelfEncapsulateFieldRefactoring.checkName(result, this.fSetterName, this.fUsedModifyNames, declaringType);
        return result;
    }

    private static void checkName(RefactoringStatus status, String name, List usedNames, IType type) {
        if (NO_NAME.equals(name)) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.Choose_name"));
            return;
        }
        status.merge(Checks.checkMethodName(name));
        Iterator iter = usedNames.iterator();
        while (iter.hasNext()) {
            IMethodBinding method = (IMethodBinding)iter.next();
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            status.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.method_exists", new String[]{Bindings.asString((IBinding)method), type.getElementName()}));
        }
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.fChangeManager.clear();
            pm.beginTask(NO_NAME, 11);
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.checking_preconditions"));
            result.merge(this.checkMethodNames());
            pm.worked(1);
            if (result.hasFatalError()) {
                return result;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.searching_for_cunits"));
            ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 5), RefactoringScopeFactory.create((IJavaElement)this.fField), SearchEngine.createSearchPattern((IJavaElement)this.fField, (int)2));
            this.checkInHierarchy(result);
            if (result.hasFatalError()) {
                return result;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.analyzing"));
            SubProgressMonitor sub = new SubProgressMonitor(pm, 5);
            sub.beginTask(NO_NAME, affectedCUs.length);
            IVariableBinding fieldIdentifier = this.fFieldDeclaration.resolveBinding();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.core.dom.TypeDeclaration;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITypeBinding declaringClass = ((TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding();
            ArrayList ownerDescriptions = new ArrayList();
            ICompilationUnit owner = this.fField.getCompilationUnit();
            int i = 0;
            while (i < affectedCUs.length) {
                ArrayList descriptions;
                ICompilationUnit unit = affectedCUs[i];
                sub.subTask(unit.getElementName());
                CompilationUnit root = null;
                ASTRewrite rewriter = null;
                if (owner.equals(unit)) {
                    root = this.fRoot;
                    rewriter = this.fRewriter;
                    descriptions = ownerDescriptions;
                } else {
                    root = AST.parseCompilationUnit((ICompilationUnit)unit, (boolean)true);
                    rewriter = new ASTRewrite((ASTNode)root);
                    descriptions = new ArrayList();
                }
                this.checkCompileErrors(result, root, unit);
                AccessAnalyzer analyzer = new AccessAnalyzer(this, unit, fieldIdentifier, declaringClass, rewriter);
                root.accept((ASTVisitor)analyzer);
                result.merge(analyzer.getStatus());
                if (!this.fSetterMustReturnValue) {
                    this.fSetterMustReturnValue = analyzer.getSetterMustReturnValue();
                }
                if (result.hasFatalError()) {
                    this.fChangeManager.clear();
                    return result;
                }
                descriptions.addAll(analyzer.getGroupDescriptions());
                if (!owner.equals(unit)) {
                    this.createEdits(unit, rewriter, descriptions);
                }
                sub.worked(1);
                ++i;
            }
            ownerDescriptions.addAll(this.addGetterSetterChanges(this.fRoot, this.fRewriter));
            this.createEdits(owner, this.fRewriter, ownerDescriptions);
            sub.done();
            result.merge(this.validateModifiesFiles());
            return result;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createEdits(ICompilationUnit unit, ASTRewrite rewriter, List groups) throws CoreException {
        TextChange change = this.fChangeManager.get(unit);
        TextBuffer buffer = TextBuffer.acquire(SelfEncapsulateFieldRefactoring.getFile(unit));
        try {
            MultiTextEdit root = new MultiTextEdit();
            rewriter.rewriteNode(buffer, (TextEdit)root);
            change.setEdit((TextEdit)root);
            change.addGroupDescriptions(groups.toArray(new GroupDescription[groups.size()]));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            TextBuffer.release(buffer);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        TextBuffer.release(buffer);
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange result = new CompositeChange(this.getName());
        TextChange[] changes = this.fChangeManager.getAllChanges();
        pm.beginTask(NO_NAME, changes.length);
        pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.create_changes"));
        int i = 0;
        while (i < changes.length) {
            result.add(changes[i]);
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SelfEncapsulateField.name");
    }

    private void checkCompileErrors(RefactoringStatus result, CompilationUnit root, ICompilationUnit element) {
        Message[] messages = root.getMessages();
        if (messages.length != 0) {
            result.addError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_update", element.getElementName()), JavaStatusContext.create(element));
        }
    }

    private void checkInHierarchy(RefactoringStatus status) throws CoreException {
        TypeDeclaration declaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 55);
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            ITypeBinding fieldType = this.fFieldDeclaration.resolveBinding().getType();
            status.merge(Checks.checkMethodInHierarchy(type, this.fGetterName, fieldType, new ITypeBinding[0], this.fField.getJavaProject()));
            status.merge(Checks.checkMethodInHierarchy(type, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{fieldType}, this.fField.getJavaProject()));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList(0);
        this.fUsedModifyNames = new ArrayList(0);
        IVariableBinding binding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding type = binding.getType();
        IMethodBinding[] methods = binding.getDeclaringClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            ITypeBinding[] parameters = methods[i].getParameterTypes();
            if (parameters == null || parameters.length == 0) {
                this.fUsedReadNames.add(method);
            } else if (parameters.length == 1 && parameters[0] == type) {
                this.fUsedModifyNames.add(method);
            }
            ++i;
        }
    }

    private List addGetterSetterChanges(CompilationUnit root, ASTRewrite rewriter) throws CoreException {
        GroupDescription description;
        Class<?> clazz;
        ArrayList<GroupDescription> result = new ArrayList<GroupDescription>(2);
        AST ast = root.getAST();
        if (!JdtFlags.isPrivate((IMember)this.fField)) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("[Lorg.eclipse.jdt.core.dom.FieldDeclaration;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FieldDeclaration decl = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz2);
            int newModifiers = ASTNodes.changeVisibility(decl.getModifiers(), 2);
            GroupDescription description2 = new GroupDescription(RefactoringCoreMessages.getString("SelfEncapsulateField.change_visibility"));
            result.add(description2);
            rewriter.markAsReplaced((ASTNode)decl, 34, new Integer(newModifiers), description2);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.core.dom.TypeDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TypeDeclaration type = (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        int position = 0;
        int numberOfMethods = 0;
        List members = type.bodyDeclarations();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            BodyDeclaration element = (BodyDeclaration)iter.next();
            if (element.getNodeType() == 31) {
                if (this.fInsertionIndex == -1) break;
                if (this.fInsertionIndex == numberOfMethods) {
                    ++position;
                    break;
                }
                ++numberOfMethods;
            }
            ++position;
        }
        if (!JdtFlags.isFinal((IMember)this.fField)) {
            description = new GroupDescription(RefactoringCoreMessages.getString("SelfEncapsulateField.add_setter"));
            result.add(description);
            members.add(position++, this.createSetterMethod(ast, rewriter, description));
        }
        description = new GroupDescription(RefactoringCoreMessages.getString("SelfEncapsulateField.add_getter"));
        result.add(description);
        members.add(position, this.createGetterMethod(ast, rewriter, description));
        return result;
    }

    private MethodDeclaration createSetterMethod(AST ast, ASTRewrite rewriter, GroupDescription description) throws JavaModelException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.jdt.core.dom.FieldDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        rewriter.markAsInserted((ASTNode)result, description);
        result.setName(ast.newSimpleName(this.fSetterName));
        result.setModifiers(this.createModifiers());
        if (this.fSetterMustReturnValue) {
            result.setReturnType((Type)rewriter.createCopy((ASTNode)type));
        }
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        result.parameters().add(param);
        param.setName(ast.newSimpleName(this.fArgName));
        param.setType((Type)rewriter.createCopy((ASTNode)type));
        Block block = ast.newBlock();
        result.setBody(block);
        Assignment ass = ast.newAssignment();
        ass.setLeftHandSide(this.createFieldAccess(ast));
        ass.setRightHandSide((Expression)ast.newSimpleName(this.fArgName));
        if (this.fSetterMustReturnValue) {
            ReturnStatement rs = ast.newReturnStatement();
            rs.setExpression((Expression)ass);
            block.statements().add(rs);
        } else {
            block.statements().add(ast.newExpressionStatement((Expression)ass));
        }
        return result;
    }

    private MethodDeclaration createGetterMethod(AST ast, ASTRewrite rewriter, GroupDescription description) throws JavaModelException {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.jdt.core.dom.FieldDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldDeclaration field = (FieldDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz);
        Type type = field.getType();
        MethodDeclaration result = ast.newMethodDeclaration();
        rewriter.markAsInserted((ASTNode)result, description);
        result.setName(ast.newSimpleName(this.fGetterName));
        result.setModifiers(this.createModifiers());
        result.setReturnType((Type)rewriter.createCopy((ASTNode)type));
        Block block = ast.newBlock();
        result.setBody(block);
        ReturnStatement rs = ast.newReturnStatement();
        rs.setExpression((Expression)ast.newSimpleName(this.fField.getElementName()));
        block.statements().add(rs);
        return result;
    }

    private int createModifiers() throws JavaModelException {
        int result = 0;
        if (Flags.isPublic((int)this.fVisibility)) {
            result |= 1;
        } else if (Flags.isProtected((int)this.fVisibility)) {
            result |= 4;
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            result |= 2;
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            result |= 8;
        }
        return result;
    }

    private Expression createFieldAccess(AST ast) throws JavaModelException {
        String fieldName = this.fField.getElementName();
        if (this.fArgName.equals(fieldName)) {
            if (JdtFlags.isStatic((IMember)this.fField)) {
                return ast.newQualifiedName((Name)ast.newSimpleName(this.fField.getDeclaringType().getElementName()), ast.newSimpleName(fieldName));
            }
            FieldAccess result = ast.newFieldAccess();
            result.setExpression((Expression)ast.newThisExpression());
            result.setName(ast.newSimpleName(fieldName));
            return result;
        }
        return ast.newSimpleName(fieldName);
    }

    private void checkArgName() {
        String fieldName = this.fField.getElementName();
        boolean isStatic = true;
        try {
            isStatic = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException javaModelException) {}
        if (isStatic && this.fArgName.equals(fieldName) && fieldName.equals(this.fField.getDeclaringType().getElementName())) {
            this.fArgName = "_" + fieldName;
        }
    }

    private static IFile getFile(ICompilationUnit cu) throws CoreException {
        return (IFile)WorkingCopyUtil.getOriginal(cu).getResource();
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }
}

