/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

class ReorgPolicyFactory {
    private ReorgPolicyFactory() {
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, javaElements, settings);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, javaElements, settings);
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IJavaElement[] selectedJavaElements, CodeGenerationSettings settings) throws JavaModelException {
        Object[] javaElements;
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedJavaElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        if (ReorgPolicyFactory.isNothingToReorg((IResource[])resources, (IJavaElement[])(javaElements = selectionComputer.getActualJavaElementsToReorg())) || ReorgPolicyFactory.containsNull(resources) || ReorgPolicyFactory.containsNull(javaElements) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 2) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 1) || ReorgUtils.hasElementsOfType((IResource[])resources, 12) || !ReorgPolicyFactory.haveCommonParent((IResource[])resources, (IJavaElement[])javaElements)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 4)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 3)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 3) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 5)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements), settings);
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])javaElements)) {
            Assert.isTrue(resources.length == 0);
            Assert.isTrue(!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5));
            Assert.isTrue(!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 6));
            Assert.isTrue(!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IJavaElement[])javaElements));
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            return new MoveSubCuElementsPolicy((IJavaElement[])javaElements);
        }
        return NO;
    }

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isInsideCompilationUnit(javaElements[i])) {
                return true;
            }
            if (ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(javaElements[i]) && !ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean haveCommonParent(IResource[] resources, IJavaElement[] javaElements) {
        return new ParentChecker(resources, javaElements).haveCommonParent();
    }

    private static boolean isNothingToReorg(IResource[] resources, IJavaElement[] javaElements) {
        return resources.length + javaElements.length == 0;
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private IResource fResourceDestination;
        private IJavaElement fJavaElementDestination;

        ReorgPolicy() {
        }

        public final RefactoringStatus setDestination(IResource destination) throws JavaModelException {
            Assert.isNotNull(destination);
            this.resetDestinations();
            this.fResourceDestination = destination;
            return this.verifyDestination(destination);
        }

        public final RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull(destination);
            this.resetDestinations();
            this.fJavaElementDestination = destination;
            return this.verifyDestination(destination);
        }

        protected abstract RefactoringStatus verifyDestination(IJavaElement var1) throws JavaModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws JavaModelException;

        private void resetDestinations() {
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
        }

        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        public final IJavaElement getJavaElementDestination() {
            return this.fJavaElementDestination;
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            Assert.isNotNull(reorgQueries);
            return Checks.validateModifiesFiles(this.getAllModifiedFiles());
        }

        public boolean hasAllInputSet() {
            return this.fJavaElementDestination != null || this.fResourceDestination != null;
        }

        public boolean canUpdateReferences() {
            return false;
        }

        public boolean getUpdateReferences() {
            Assert.isTrue(false);
            return false;
        }

        public void setUpdateReferences(boolean update) {
            Assert.isTrue(false);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        public boolean canUpdateQualifiedNames() {
            Assert.isTrue(false);
            return false;
        }

        public String getFilePatterns() {
            Assert.isTrue(false);
            return null;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue(false);
            return false;
        }

        public void setFilePatterns(String patterns) {
            Assert.isTrue(false);
        }

        public void setUpdateQualifiedNames(boolean update) {
            Assert.isTrue(false);
        }

        public boolean canEnable() throws JavaModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IJavaElement[] javaElements = this.getJavaElements();
            int i2 = 0;
            while (i2 < javaElements.length) {
                IJavaElement element = javaElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        private ICompilationUnit[] fCus;
        private IFolder[] fFolders;
        private IFile[] fFiles;

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            IOpenable openable;
            Assert.isNotNull(javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.doesnotexist0"));
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.jmodel"));
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.readonly"));
            }
            if (!javaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.structure"));
            }
            if (javaElement instanceof IOpenable && !(openable = (IOpenable)javaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.inconsistent"));
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.archive"));
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.external"));
                }
            }
            if (ReorgUtils.isInsideCompilationUnit(javaElement)) {
                ICompilationUnit cu = ReorgUtils.getCompilationUnit(javaElement);
                if (cu != null) {
                    return this.verifyDestination((IJavaElement)cu);
                }
                return RefactoringStatus.createFatalErrorStatus("The selected element is not located in a compilation unit and cannot be the destination of this operation.");
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.linked"));
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            Assert.isNotNull(resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.phantom"));
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.inaccessible"));
            }
            Assert.isTrue(resource.getType() != 8);
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.not_this_resource"));
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.linked"));
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IJavaElement jelDest = this.getJavaElementDestination();
            Assert.isNotNull(jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(jelDest));
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IJavaElement je = JavaCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment javaAsPackage = FilesFoldersAndCusReorgPolicy.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            if (javaAsPackage != null) {
                return javaAsPackage;
            }
            return FilesFoldersAndCusReorgPolicy.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        private static IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement javaDest) {
            if (javaDest == null || !javaDest.exists()) {
                return null;
            }
            if (javaDest instanceof IPackageFragment) {
                return (IPackageFragment)javaDest;
            }
            if (javaDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)javaDest).getPackageFragment("");
            }
            return (IPackageFragment)javaDest.getAncestor(4);
        }

        private static IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) {
            if (resource instanceof IFile) {
                return FilesFoldersAndCusReorgPolicy.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            RefactoringStatus status = super.checkInput(pm, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setFiles(this.fFiles);
            oh.setFolders(this.fFolders);
            oh.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                oh.confirmOverwritting(reorgQueries, (IJavaElement)destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    oh.confirmOverwritting(reorgQueries, (IResource)destinationAsContainer);
                }
            }
            this.fFiles = oh.getFilesWithoutUnconfirmedOnes();
            this.fFolders = oh.getFoldersWithoutUnconfirmedOnes();
            this.fCus = oh.getCusWithoutUnconfirmedOnes();
        }
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        private final IJavaElement[] fJavaElements;

        SubCuElementReorgPolicy(IJavaElement[] javaElements) {
            Assert.isNotNull(javaElements);
            this.fJavaElements = javaElements;
        }

        protected final RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.no_resource"));
        }

        protected final ICompilationUnit getSourceCu() {
            return (ICompilationUnit)this.fJavaElements[0].getAncestor(5);
        }

        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        public final IResource[] getResources() {
            return new IResource[0];
        }

        protected final ICompilationUnit getDestinationCu() {
            return SubCuElementReorgPolicy.getDestinationCu(this.getJavaElementDestination());
        }

        protected static final ICompilationUnit getDestinationCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        protected static TextChange addTextEditFromRewrite(ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
            TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
            MultiTextEdit resultingEdits = new MultiTextEdit();
            rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
            CompilationUnitChange textChange = new CompilationUnitChange(cu.getElementName(), cu);
            if (textChange instanceof TextFileChange) {
                TextFileChange tfc = textChange;
                tfc.setSave(!cu.isWorkingCopy());
            }
            String message = RefactoringCoreMessages.getString("ReorgPolicyFactory.copy");
            textChange.addTextEdit(message, (TextEdit)resultingEdits);
            rewrite.removeModifications();
            return textChange;
        }

        protected void copyToDestination(IJavaElement element, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            switch (element.getElementType()) {
                case 8: {
                    this.copyFieldToDestination((IField)element, rewrite, sourceCuNode, destinationCuNode);
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)element, rewrite, sourceCuNode, destinationCuNode);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)element, rewrite, sourceCuNode, destinationCuNode);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)element, rewrite, destinationCuNode);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)element, rewrite, destinationCuNode);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)element, rewrite, sourceCuNode, destinationCuNode);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)element, rewrite, destinationCuNode);
                    break;
                }
                default: {
                    Assert.isTrue(false);
                }
            }
        }

        private void copyFieldToDestination(IField field, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            FieldDeclaration copiedNode = this.createNewFieldDeclarationNode(field, SubCuElementReorgPolicy.getAST(targetRewrite), sourceCuNode);
            targetRewrite.markAsInserted((ASTNode)copiedNode);
            TypeDeclaration targetClass = this.getTargetType(destinationCuNode);
            targetClass.bodyDeclarations().add(copiedNode);
        }

        private FieldDeclaration createNewFieldDeclarationNode(IField field, AST targetAst, CompilationUnit sourceCuNode) throws JavaModelException {
            FieldDeclaration fieldDeclaration = ASTNodeSearchUtil.getFieldDeclarationNode(field, sourceCuNode);
            if (fieldDeclaration.fragments().size() == 1) {
                return (FieldDeclaration)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration);
            }
            VariableDeclarationFragment originalFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, sourceCuNode);
            VariableDeclarationFragment copiedFragment = (VariableDeclarationFragment)ASTNode.copySubtree((AST)targetAst, (ASTNode)originalFragment);
            FieldDeclaration newFieldDeclaration = targetAst.newFieldDeclaration(copiedFragment);
            if (fieldDeclaration.getJavadoc() != null) {
                newFieldDeclaration.setJavadoc((Javadoc)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration.getJavadoc()));
            }
            newFieldDeclaration.setModifiers(fieldDeclaration.getModifiers());
            newFieldDeclaration.setType((Type)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration.getType()));
            return newFieldDeclaration;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            IJavaElement[] importDeclarations = container.getChildren();
            int i = 0;
            while (i < importDeclarations.length) {
                Assert.isTrue(importDeclarations[i] instanceof IImportDeclaration);
                IImportDeclaration importDeclaration = (IImportDeclaration)importDeclarations[i];
                this.copyImportToDestination(importDeclaration, rewrite, sourceCuNode, destinationCuNode);
                ++i;
            }
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
            ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)SubCuElementReorgPolicy.getAST(targetRewrite), (ASTNode)sourceNode);
            targetRewrite.markAsInserted((ASTNode)copiedNode);
            destinationCuNode.imports().add(copiedNode);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            PackageDeclaration sourceNode = ASTNodeSearchUtil.getPackageDeclarationNode(declaration, sourceCuNode);
            Initializer copiedNode = (Initializer)ASTNode.copySubtree((AST)SubCuElementReorgPolicy.getAST(targetRewrite), (ASTNode)sourceNode);
            targetRewrite.markAsInserted((ASTNode)copiedNode);
            destinationCuNode.types().add(copiedNode);
        }

        private void copyInitializerToDestination(IInitializer initializer, ASTRewrite targetRewrite, CompilationUnit destinationCuNode) throws JavaModelException {
            BodyDeclaration newInitializer = (BodyDeclaration)targetRewrite.createPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)initializer), 13);
            targetRewrite.markAsInserted((ASTNode)newInitializer);
            TypeDeclaration targetClass = this.getTargetType(destinationCuNode);
            targetClass.bodyDeclarations().add(newInitializer);
        }

        private void copyTypeToDestination(IType type, ASTRewrite targetRewrite, CompilationUnit destinationCuNode) throws JavaModelException {
            TypeDeclaration newType = (TypeDeclaration)targetRewrite.createPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)type), 10);
            targetRewrite.markAsInserted((ASTNode)newType);
            destinationCuNode.types().add(newType);
        }

        private void copyMethodToDestination(IMethod method, ASTRewrite targetRewrite, CompilationUnit destinationCuNode) throws JavaModelException {
            BodyDeclaration newMethod = (BodyDeclaration)targetRewrite.createPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)method), 12);
            targetRewrite.markAsInserted((ASTNode)newMethod);
            TypeDeclaration targetClass = this.getTargetType(destinationCuNode);
            targetClass.bodyDeclarations().add(newMethod);
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws JavaModelException {
            Assert.isTrue(sourceReference instanceof IJavaElement);
            String[] lines = Strings.convertIntoLines(sourceReference.getSource());
            Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
            return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)sourceReference));
        }

        private static AST getAST(ASTRewrite rewrite) {
            return rewrite.getAST();
        }

        private TypeDeclaration getTargetType(CompilationUnit destinationCuNode) throws JavaModelException {
            return ASTNodeSearchUtil.getTypeDeclarationNode(this.getDestinationAsType(), destinationCuNode);
        }

        private IType getDestinationAsType() throws JavaModelException {
            IJavaElement destination = this.getJavaElementDestination();
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(destination);
            if (enclosingType != null) {
                return enclosingType;
            }
            ICompilationUnit enclosingCu = SubCuElementReorgPolicy.getEnclosingCu(destination);
            Assert.isNotNull(enclosingCu);
            IType mainType = JavaElementUtil.getMainType(enclosingCu);
            Assert.isNotNull(mainType);
            return mainType;
        }

        private static ICompilationUnit getEnclosingCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement destination) {
            if (destination instanceof IType) {
                return (IType)destination;
            }
            return (IType)destination.getAncestor(7);
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fJavaElements.length) {
                IMember member;
                if (this.fJavaElements[i] instanceof IMember && (member = (IMember)this.fJavaElements[i]).isBinary() && member.getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull(destination);
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.doesnotexist1"));
            }
            if (destination instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.jmodel"));
            }
            if (!(destination instanceof ICompilationUnit) && !ReorgUtils.isInsideCompilationUnit(destination)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot"));
            }
            ICompilationUnit destinationCu = SubCuElementReorgPolicy.getDestinationCu(destination);
            Assert.isNotNull(destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot_modify"));
            }
            switch (destination.getElementType()) {
                case 5: {
                    int[] types0 = new int[]{8, 10, 9};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types0)) break;
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot"));
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.package_decl"));
                }
                case 12: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot"));
                }
                case 13: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot"));
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.verifyDestination(destination.getParent());
                }
                case 7: {
                    int[] types1 = new int[]{13, 12, 11};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types1)) break;
                    return this.verifyDestination(destination.getParent());
                }
            }
            return new RefactoringStatus();
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] roots) {
            Assert.isNotNull(roots);
            this.fPackageFragmentRoots = roots;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                if (!ReorgUtils.isSourceFolder((IJavaElement)this.fPackageFragmentRoots[i])) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.src2proj"));
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull(javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot1"));
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.jmodel"));
            }
            if (!(javaElement instanceof IJavaProject)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.src2proj"));
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.src2writable"));
            }
            if (ReorgUtils.isPackageFragmentRoot((IJavaProject)javaElement)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.src2nosrc"));
            }
            return new RefactoringStatus();
        }

        protected IJavaProject getDestinationJavaProject() {
            return (IJavaProject)this.getJavaElementDestination();
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            RefactoringStatus status = super.checkInput(pm, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject javaProject = this.getDestinationJavaProject();
            oh.confirmOverwritting(reorgQueries, (IJavaElement)javaProject);
            this.fPackageFragmentRoots = oh.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        public PackagesReorgPolicy(IPackageFragment[] packageFragments) {
            Assert.isNotNull(packageFragments);
            this.fPackageFragments = packageFragments;
        }

        public boolean canEnable() throws JavaModelException {
            int i = 0;
            while (i < this.fPackageFragments.length) {
                if (JavaElementUtil.isDefaultPackage(this.fPackageFragments[i]) || this.fPackageFragments[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.packages"));
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement javaElement) throws JavaModelException {
            IPackageFragment pack;
            if (javaElement == null) {
                return null;
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)javaElement;
            }
            if (javaElement instanceof IPackageFragment && (pack = (IPackageFragment)javaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)pack.getParent();
            }
            if (javaElement instanceof IJavaProject) {
                return ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaElement);
            }
            return null;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull(javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.cannot1"));
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.jmodel"));
            }
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot(javaElement);
            if (!ReorgUtils.isSourceFolder((IJavaElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.packages"));
            }
            return new RefactoringStatus();
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            RefactoringStatus refactoringStatus = super.checkInput(pm, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackages(this.fPackageFragments);
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot();
            oh.confirmOverwritting(reorgQueries, (IJavaElement)destRoot);
            this.fPackageFragments = oh.getPackagesWithoutUnconfirmedOnes();
        }
    }

    private static class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        CopySubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        public IChange createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit destinationCu = this.getDestinationCu();
                CompilationUnit destinationCuNode = AST.parseCompilationUnit((ICompilationUnit)destinationCu, (boolean)false);
                ASTRewrite rewrite = new ASTRewrite((ASTNode)destinationCuNode);
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], rewrite, sourceCuNode, destinationCuNode);
                    ++i;
                }
                return SubCuElementReorgPolicy.addTextEditFromRewrite(destinationCu, rewrite);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue(this.getSourceCu() != null || this.getSourceClassFile() != null);
            Assert.isTrue(this.getSourceCu() == null || this.getSourceClassFile() == null);
            if (this.getSourceCu() != null) {
                return AST.parseCompilationUnit((ICompilationUnit)this.getSourceCu(), (boolean)false);
            }
            return AST.parseCompilationUnit((IClassFile)this.getSourceClassFile(), (boolean)false);
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }
    }

    private static class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        public IChange createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            CompositeChange composite = new CompositeChange();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private IChange createChange(ICompilationUnit unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        private static IChange copyFileToContainer(ICompilationUnit cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource((IJavaElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private IChange createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static IChange createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        private static IChange copyCuToPackage(ICompilationUnit cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtils.getResource((IJavaElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = ResourceUtil.getResource(cu).getParent().getFullPath().append(newName);
                INewNameQuery nameQuery = copyQueries.createNewCompilationUnitNameQuery(cu, newName);
                return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }
    }

    private static class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        public IChange createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            CompositeChange composite = new CompositeChange();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull(destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination, nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private IChange createChange(IPackageFragmentRoot root, IJavaProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageFragmentRootNameQuery(root, newName);
            return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, null);
        }
    }

    private static class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        public CopyPackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        public IChange createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws JavaModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            CompositeChange composite = new CompositeChange();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                composite.add(this.createChange(fragments[i], root, nameProposer, newNameQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private IChange createChange(IPackageFragment pack, IPackageFragmentRoot destination, NewNameProposer nameProposer, INewNameQueries copyQueries) throws JavaModelException {
            String newName = nameProposer.createNewName(pack, destination);
            if (newName == null || JavaConventions.validatePackageName((String)newName).getSeverity() < 4) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyPackageChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }
    }

    private static class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        NoCopyPolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.noCopying"));
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.noCopying"));
        }

        public IChange createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }
    }

    private static class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        NewNameProposer() {
        }

        public String createNewName(ICompilationUnit cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.cu.copyOf1", cu.getElementName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.cu.copyOfMore", new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return NewNameProposer.removeTrailingJava(newName);
                }
                ++i;
            }
        }

        private static String removeTrailingJava(String name) {
            Assert.isTrue(name.endsWith(".java"));
            return name.substring(0, name.length() - ".java".length());
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.resource.copyOf1", res.getName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.resource.copyOfMore", new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? RefactoringCoreMessages.getFormattedString("CopyRefactoring.package.copyOf1", pack.getElementName()) : RefactoringCoreMessages.getFormattedString("CopyRefactoring.package.copyOfMore", new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getCompilationUnit(newName).exists();
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }
    }

    private static class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        public IChange createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            CompositeChange composite = new CompositeChange();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull(destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private IChange createChange(IPackageFragmentRoot root, IJavaProject destination) {
            return new MovePackageFragmentRootChange(root, destination.getProject(), null);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(javaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.element2parent"));
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IJavaProject javaProject, IPackageFragmentRoot[] roots) {
            int i = 0;
            while (i < roots.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(roots[i], javaProject)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            try {
                RefactoringStatus status = super.checkInput(pm, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }
    }

    private static class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        MovePackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.package2parent"));
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IPackageFragmentRoot root, IPackageFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public IChange createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            CompositeChange result = new CompositeChange();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                result.add(this.createChange(fragments[i], root));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        private IChange createChange(IPackageFragment pack, IPackageFragmentRoot destination) {
            return new MovePackageChange(pack, destination);
        }

        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            try {
                RefactoringStatus status = super.checkInput(pm, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }
    }

    private static class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private boolean fUpdateReferences;
        private boolean fUpdateQualifiedNames;
        private QualifiedNameSearchResult fQualifiedNameSearchResult;
        private String fFilePatterns;
        private TextChangeManager fChangeManager;
        private final CodeGenerationSettings fSettings;

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus, CodeGenerationSettings settings) {
            super(files, folders, cus);
            Assert.isNotNull(settings);
            this.fUpdateReferences = true;
            this.fUpdateQualifiedNames = false;
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
            this.fSettings = settings;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            return superStatus;
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            IJavaElement destinationContainerAsPackage = this.getDestinationContainerAsJavaElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.parent"));
            }
            return superStatus;
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        public IChange createChange(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateReferences) {
                if (this.fUpdateQualifiedNames) {
                    return this.createMoveAndUpdateQualifiedNameChange(pm);
                }
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        private IChange createReferenceUpdatingMoveChange(IProgressMonitor pm) throws JavaModelException {
            CompositeChange compositeChange;
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                IChange fileMove;
                CompositeChange composite = new CompositeChange();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles());
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                MoveFilesFoldersAndCusPolicy.addAllChildren(composite, new CompositeChange(RefactoringCoreMessages.getString("MoveRefactoring.reorganize_elements"), this.fChangeManager.getAllChanges()));
                if (this.fUpdateQualifiedNames) {
                    this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    composite.addAll(this.fQualifiedNameSearchResult.getAllChanges());
                }
                if ((fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1))) instanceof ICompositeChange) {
                    MoveFilesFoldersAndCusPolicy.addAllChildren(composite, (ICompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                compositeChange = composite;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return compositeChange;
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm) throws JavaModelException {
            block5: {
                block4: {
                    TextChangeManager textChangeManager;
                    pm.beginTask("", 1);
                    try {
                        if (this.fUpdateReferences) break block4;
                        textChangeManager = new TextChangeManager();
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest == null) break block5;
                MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.getCus(), packageDest, this.fSettings);
                TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Object var4_6 = null;
                pm.done();
                return textChangeManager;
            }
            TextChangeManager textChangeManager = new TextChangeManager();
            Object var4_7 = null;
            pm.done();
            return textChangeManager;
        }

        private IChange createMoveAndUpdateQualifiedNameChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 2);
            IChange simpleCopyChange = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
            CompositeChange result = new CompositeChange(this, RefactoringCoreMessages.getString("MoveRefactoring.reorganize_elements"), 2){
                final /* synthetic */ MoveFilesFoldersAndCusPolicy this$1;
                {
                    this.this$1 = moveFilesFoldersAndCusPolicy;
                }

                public boolean isUndoable() {
                    return false;
                }
            };
            if (simpleCopyChange instanceof ICompositeChange) {
                MoveFilesFoldersAndCusPolicy.addAllChildren(result, (ICompositeChange)simpleCopyChange);
            } else {
                result.add(simpleCopyChange);
            }
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.addAll(this.fQualifiedNameSearchResult.getAllChanges());
            return result;
        }

        private IChange createSimpleMoveChange(IProgressMonitor pm) throws JavaModelException {
            CompositeChange result = new CompositeChange();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            int i = 0;
            while (i < files.length) {
                result.add(this.createChange((IResource)files[i]));
                pm.worked(1);
                ++i;
            }
            i = 0;
            while (i < folders.length) {
                result.add(this.createChange((IResource)folders[i]));
                pm.worked(1);
                ++i;
            }
            i = 0;
            while (i < cus.length) {
                result.add(this.createChange(cus[i]));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        private IChange createChange(ICompilationUnit cu) throws JavaModelException {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        private static IChange moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
            IResource resource = ResourceUtil.getResource(cu);
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveCompilationUnitChange(cu, dest);
        }

        private static IChange moveFileToContainer(ICompilationUnit cu, IContainer dest) {
            return new MoveResourceChange(ResourceUtil.getResource(cu), dest);
        }

        private IChange createChange(IResource res) throws JavaModelException {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private static void addAllChildren(CompositeChange collector, ICompositeChange composite) {
            collector.addAll(composite.getChildren());
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment destination = this.getDestinationAsPackageFragment();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length);
            pm.subTask(RefactoringCoreMessages.getString("MoveRefactoring.scanning_qualified_names"));
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                IType[] types = cu.getTypes();
                SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                typesMonitor.beginTask("", types.length);
                int j = 0;
                while (j < types.length) {
                    this.handleType(types[j], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                    ++j;
                }
                typesMonitor.done();
                ++i;
            }
            pm.done();
        }

        private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) throws JavaModelException {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, type.getFullyQualifiedName(), String.valueOf(destination.getElementName()) + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RefactoringStatus checkInput(IProgressMonitor pm, IReorgQueries reorgQueries) throws JavaModelException {
            RefactoringStatus refactoringStatus;
            try {
                try {
                    RefactoringStatus status;
                    pm.beginTask("", 2);
                    this.confirmMovingReadOnly(reorgQueries);
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    refactoringStatus = status = super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1), reorgQueries);
                    Object var4_7 = null;
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public IFile[] getAllModifiedFiles() {
            ArrayList<IFile> result = new ArrayList<IFile>();
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (this.getDestinationAsPackageFragment() != null) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        public boolean canUpdateReferences() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack == null || pack.isDefaultPackage()) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return !JavaElementUtil.isDefaultPackage(commonParent);
        }

        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        public boolean canUpdateQualifiedNames() {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            return this.canEnableQualifiedNameUpdating() && pack != null && !pack.isDefaultPackage();
        }

        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        public void setFilePatterns(String patterns) {
            Assert.isNotNull(patterns);
            this.fFilePatterns = patterns;
        }
    }

    private static class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        MoveSubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent) || destination.getParent().equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.element2parent"));
            }
            return superStatus;
        }

        private CompilationUnit createSourceCuNode() {
            return AST.parseCompilationUnit((ICompilationUnit)this.getSourceCu(), (boolean)false);
        }

        public IChange createChange(IProgressMonitor pm) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit destinationCu = this.getDestinationCu();
                CompilationUnit destinationCuNode = this.getSourceCu().equals(destinationCu) ? sourceCuNode : AST.parseCompilationUnit((ICompilationUnit)destinationCu, (boolean)false);
                ASTRewrite targetRewrite = new ASTRewrite((ASTNode)destinationCuNode);
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewrite, sourceCuNode, destinationCuNode);
                    ++i;
                }
                ASTRewrite sourceRewrite = this.getSourceCu().equals(destinationCu) ? targetRewrite : new ASTRewrite((ASTNode)sourceCuNode);
                ASTNodeDeleteUtil.markAsDeleted(javaElements, sourceCuNode, sourceRewrite);
                TextChange targetCuChange = SubCuElementReorgPolicy.addTextEditFromRewrite(destinationCu, targetRewrite);
                if (this.getSourceCu().equals(destinationCu)) {
                    return targetCuChange;
                }
                CompositeChange result = new CompositeChange();
                result.add(targetCuChange);
                if (Arrays.asList(this.getJavaElements()).containsAll(Arrays.asList(this.getSourceCu().getTypes()))) {
                    result.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{this.getSourceCu()}));
                } else {
                    result.add(SubCuElementReorgPolicy.addTextEditFromRewrite(this.getSourceCu(), sourceRewrite));
                }
                return result;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getSourceCu()), ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }
    }

    private static class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        NoMovePolicy() {
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.noMoving"));
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ReorgPolicyFactory.noMoving"));
        }

        public IChange createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }
    }

    private static class ActualSelectionComputer {
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;

        public ActualSelectionComputer(IJavaElement[] javaElements, IResource[] resources) {
            this.fJavaElements = javaElements;
            this.fResources = resources;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                if (element != null && !ReorgUtils.isDeletedFromEditor(element)) {
                    if ((element = WorkingCopyUtil.getWorkingCopyIfExists(element)) instanceof IType) {
                        IType type = (IType)element;
                        ICompilationUnit cu = type.getCompilationUnit();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!result.contains(element)) {
                        result.add(element);
                    }
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IJavaElement> javaElementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                IJavaElement element;
                if (!(this.fResources[i] == null || (element = JavaCore.create((IResource)this.fResources[i])) != null && element.exists() && javaElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }
}

