/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private ICompilationUnit[] fCus = new ICompilationUnit[0];
    private IPackageFragmentRoot[] fRoots = new IPackageFragmentRoot[0];
    private IPackageFragment[] fPackageFragments = new IPackageFragment[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] files) {
        Assert.isNotNull(files);
        this.fFiles = files;
    }

    public void setFolders(IFolder[] folders) {
        Assert.isNotNull(folders);
        this.fFolders = folders;
    }

    public void setCus(ICompilationUnit[] cus) {
        Assert.isNotNull(cus);
        this.fCus = cus;
    }

    public void setPackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull(roots);
        this.fRoots = roots;
    }

    public void setPackages(IPackageFragment[] fragments) {
        Assert.isNotNull(fragments);
        this.fPackageFragments = fragments;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public ICompilationUnit[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IPackageFragmentRoot[] getPackageFragmentRootsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IPackageFragment[] getPackagesWithoutUnconfirmedOnes() {
        return this.fPackageFragments;
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IJavaElement destination) {
        Assert.isNotNull(destination);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IResource destination) {
        Assert.isNotNull(destination);
        Assert.isNotNull(reorgQueries);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    private void confirmOverwritting(IReorgQueries reorgQueries) {
        IConfirmQuery overwriteQuery = reorgQueries.createYesYesToAllNoNoToAllQuery(RefactoringCoreMessages.getString("OverwriteHelper.0"), true, 6);
        this.confirmFileOverwritting(overwriteQuery);
        this.confirmFolderOverwritting(overwriteQuery);
        this.confirmCuOverwritting(overwriteQuery);
        this.confirmPackageFragmentRootOverwritting(overwriteQuery);
        this.confirmPackageOverwritting(overwriteQuery);
    }

    private void confirmPackageFragmentRootOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragmentRoot> toNotOverwrite = new ArrayList<IPackageFragmentRoot>(1);
        int i = 0;
        while (i < this.fRoots.length) {
            IPackageFragmentRoot root = this.fRoots[i];
            if (this.canOverwrite(root) && !OverwriteHelper.overwrite((IJavaElement)root, overwriteQuery)) {
                toNotOverwrite.add(root);
            }
            ++i;
        }
        IPackageFragmentRoot[] roots = toNotOverwrite.toArray(new IPackageFragmentRoot[toNotOverwrite.size()]);
        this.fRoots = ArrayTypeConverter.toPackageFragmentRootArray(ReorgUtils.setMinus((IJavaElement[])this.fRoots, (IJavaElement[])roots));
    }

    private void confirmCuOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<ICompilationUnit> cusToNotOverwrite = new ArrayList<ICompilationUnit>(1);
        int i = 0;
        while (i < this.fCus.length) {
            ICompilationUnit cu = this.fCus[i];
            if (this.canOverwrite(cu) && !OverwriteHelper.overwrite((IJavaElement)cu, overwriteQuery)) {
                cusToNotOverwrite.add(cu);
            }
            ++i;
        }
        ICompilationUnit[] cus = cusToNotOverwrite.toArray(new ICompilationUnit[cusToNotOverwrite.size()]);
        this.fCus = ArrayTypeConverter.toCuArray(ReorgUtils.setMinus((IJavaElement[])this.fCus, (IJavaElement[])cus));
    }

    private void confirmFolderOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFolder> foldersToNotOverwrite = new ArrayList<IFolder>(1);
        int i = 0;
        while (i < this.fFolders.length) {
            IFolder folder = this.fFolders[i];
            if (this.canOverwrite((IResource)folder) && !OverwriteHelper.overwrite((IResource)folder, overwriteQuery)) {
                foldersToNotOverwrite.add(folder);
            }
            ++i;
        }
        IFolder[] folders = foldersToNotOverwrite.toArray(new IFolder[foldersToNotOverwrite.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtils.setMinus((IResource[])this.fFolders, (IResource[])folders));
    }

    private void confirmFileOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFile> filesToNotOverwrite = new ArrayList<IFile>(1);
        int i = 0;
        while (i < this.fFiles.length) {
            IFile file = this.fFiles[i];
            if (this.canOverwrite((IResource)file) && !OverwriteHelper.overwrite((IResource)file, overwriteQuery)) {
                filesToNotOverwrite.add(file);
            }
            ++i;
        }
        IFile[] files = filesToNotOverwrite.toArray(new IFile[filesToNotOverwrite.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtils.setMinus((IResource[])this.fFiles, (IResource[])files));
    }

    private void confirmPackageOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragment> toNotOverwrite = new ArrayList<IPackageFragment>(1);
        int i = 0;
        while (i < this.fPackageFragments.length) {
            IPackageFragment pack = this.fPackageFragments[i];
            if (this.canOverwrite(pack) && !OverwriteHelper.overwrite((IJavaElement)pack, overwriteQuery)) {
                toNotOverwrite.add(pack);
            }
            ++i;
        }
        IPackageFragment[] packages = toNotOverwrite.toArray(new IPackageFragment[toNotOverwrite.size()]);
        this.fPackageFragments = ArrayTypeConverter.toPackageArray(ReorgUtils.setMinus((IJavaElement[])this.fPackageFragments, (IJavaElement[])packages));
    }

    private boolean canOverwrite(IPackageFragment pack) {
        Assert.isTrue(this.fDestination instanceof IPackageFragmentRoot);
        IPackageFragmentRoot destination = (IPackageFragmentRoot)this.fDestination;
        return !destination.equals(pack.getParent()) && destination.getPackageFragment(pack.getElementName()).exists();
    }

    private boolean canOverwrite(IResource resource) {
        IFolder folder;
        IResource member;
        if (resource == null) {
            return false;
        }
        IResource destinationResource = ResourceUtil.getResource(this.fDestination);
        if (destinationResource.equals((Object)resource.getParent())) {
            return false;
        }
        return destinationResource instanceof IFolder && (member = (folder = (IFolder)destinationResource).findMember(resource.getName())) != null && member.exists();
    }

    private boolean canOverwrite(IPackageFragmentRoot root) {
        Assert.isTrue(this.fDestination instanceof IJavaProject);
        IJavaProject destination = (IJavaProject)this.fDestination;
        return !destination.equals(root.getParent()) && destination.getProject().getFolder(root.getElementName()).exists();
    }

    private boolean canOverwrite(ICompilationUnit cu) {
        if (this.fDestination instanceof IPackageFragment) {
            IPackageFragment destination = (IPackageFragment)this.fDestination;
            return !destination.equals(cu.getParent()) && destination.getCompilationUnit(cu.getElementName()).exists();
        }
        return this.canOverwrite(ReorgUtils.getResource((IJavaElement)cu));
    }

    private static boolean overwrite(IResource resource, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(resource.getName(), overwriteQuery);
    }

    private static boolean overwrite(IJavaElement element, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(element.getElementName(), overwriteQuery);
    }

    private static boolean overwrite(String name, IConfirmQuery overwriteQuery) {
        String question = RefactoringCoreMessages.getFormattedString("OverwriteHelper.1", name);
        return overwriteQuery.confirm(question);
    }
}

