/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.util.Resources;

public class MoveRefactoring
extends Refactoring
implements IQualifiedNameUpdatingRefactoring {
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private boolean fWasCanceled;

    public static boolean isAvailable(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        if (javaElements != null) {
            int i = 0;
            while (i < javaElements.length) {
                IJavaElement element = javaElements[i];
                if (element instanceof IType && ((IType)element).isLocal()) {
                    return false;
                }
                ++i;
            }
        }
        return MoveRefactoring.isAvailable(ReorgPolicyFactory.createMovePolicy(resources, javaElements, settings));
    }

    public static MoveRefactoring create(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        IReorgPolicy.IMovePolicy movePolicy = ReorgPolicyFactory.createMovePolicy(resources, javaElements, settings);
        if (!MoveRefactoring.isAvailable(movePolicy)) {
            return null;
        }
        return new MoveRefactoring(movePolicy);
    }

    private MoveRefactoring(IReorgPolicy.IMovePolicy movePolicy) {
        this.fMovePolicy = movePolicy;
    }

    private static boolean isAvailable(IReorgPolicy.IMovePolicy copyPolicy) throws JavaModelException {
        return copyPolicy.canEnable();
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fMovePolicy.getJavaElements());
            result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getJavaElements()).getCommonParent();
    }

    public IJavaElement[] getJavaElements() {
        return this.fMovePolicy.getJavaElements();
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        try {
            Assert.isNotNull(this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkInput(pm, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        Assert.isTrue(this.fMovePolicy.getJavaElementDestination() == null || this.fMovePolicy.getResourceDestination() == null);
        Assert.isTrue(this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null);
        try {
            CompositeChange resultComposite = new CompositeChange(){

                public boolean isUndoable() {
                    return false;
                }
            };
            IChange change = this.fMovePolicy.createChange(pm);
            if (change instanceof ICompositeChange) {
                ICompositeChange subComposite = (ICompositeChange)change;
                resultComposite.addAll(subComposite.getChildren());
            } else {
                resultComposite.add(change);
            }
            compositeChange = resultComposite;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveRefactoring.0");
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean getUpdateReferences() {
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public void setFilePatterns(String patterns) {
        this.fMovePolicy.setFilePatterns(patterns);
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fMovePolicy.setUpdateQualifiedNames(update);
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getJavaElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }
}

