/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.SharableParticipants;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Resources;

public class JavaDeleteProcessor
extends DeleteProcessor {
    private boolean fWasCanceled = false;
    private boolean fSuggestGetterSetterDeletion = true;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private int fStyle;
    private IReorgQueries fDeleteQueries;
    private IChange fDeleteChange;

    public void initialize(Object[] elements) {
        this.fElements = elements;
        this.fResources = JavaDeleteProcessor.getResources(elements);
        this.fJavaElements = JavaDeleteProcessor.getJavaElements(elements);
        this.fStyle = JavaDeleteProcessor.getStyle(this.fResources, this.fJavaElements);
    }

    public boolean isAvailable() throws CoreException {
        return this.fElements.length == this.fResources.length + this.fJavaElements.length;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getString("DeleteRefactoring.7");
    }

    public IProject[] getAffectedProjects() throws CoreException {
        IProject[] jScope = JavaProcessors.computeScope(this.fJavaElements);
        IProject[] rScope = ResourceProcessors.computeScope(this.fResources);
        HashSet<IProject> result = new HashSet<IProject>();
        result.addAll(Arrays.asList(jScope));
        result.addAll(Arrays.asList(rScope));
        return result.toArray(new IProject[result.size()]);
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public int getStyle() {
        return this.fStyle;
    }

    public Object[] getDerivedElements() throws CoreException {
        return super.getDerivedElements();
    }

    protected IRefactoringParticipant[] getMappedParticipants(SharableParticipants shared) throws CoreException {
        ResourceModifications modifications = new ResourceModifications();
        int p = 0;
        while (p < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[p];
            if (element instanceof IPackageFragment) {
                ICompilationUnit[] children = ((IPackageFragment)element).getCompilationUnits();
                int c = 0;
                while (c < children.length) {
                    IResource resource = children[c].getResource();
                    if (resource != null) {
                        modifications.addDelete(resource);
                    }
                    ++c;
                }
            }
            ++p;
        }
        return modifications.getParticipants(this, shared);
    }

    private static IResource[] getResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IResource) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static IJavaElement[] getJavaElements(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IJavaElement) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private static int getStyle(IResource[] resources, IJavaElement[] jElements) {
        if (resources != null && resources.length > 0) {
            return 4;
        }
        if (jElements != null) {
            int i = 0;
            while (i < jElements.length) {
                int type = jElements[i].getElementType();
                if (type <= 6) {
                    return 4;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setSuggestGetterSetterDeletion(boolean suggest) {
        this.fSuggestGetterSetterDeletion = suggest;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fDeleteQueries = queries;
    }

    public IJavaElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkActivation() throws CoreException {
        Assert.isNotNull(this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(this.fResources))));
        IResource[] javaResources = ReorgUtils.getResources(this.fJavaElements);
        result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IType) {
                ((IType)element).isAnonymous();
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask(RefactoringCoreMessages.getString("DeleteRefactoring.1"), 1);
        try {
            try {
                this.fWasCanceled = false;
                RefactoringStatus result = new RefactoringStatus();
                this.recalculateElementsToDelete();
                TextChangeManager manager = new TextChangeManager();
                this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fJavaElements);
                result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(manager.getAllCompilationUnits())));
                refactoringStatus = result;
                Object var4_8 = null;
            }
            catch (OperationCanceledException e) {
                this.fWasCanceled = true;
                throw e;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private void recalculateElementsToDelete() throws CoreException {
        this.fJavaElements = ReorgUtils.toWorkingCopies(this.fJavaElements);
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptyCusToDelete();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaModelException {
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.2");
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        int i = 0;
        while (i < this.fResources.length) {
            IPackageFragmentRoot root;
            IJavaProject project;
            IResource resource = this.fResources[i];
            if (resource instanceof IFile && (project = JavaCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findPackageFragmentRoot(resource.getFullPath())) != null) {
                ArrayList<IJavaProject> referencingProjects = new ArrayList<IJavaProject>(1);
                referencingProjects.add(root.getJavaProject());
                referencingProjects.addAll(Arrays.asList(JavaElementUtil.getReferencingProjects(root)));
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    filesToSkip.add(resource);
                }
            }
            ++i;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> rootsToSkip = new ArrayList<IPackageFragmentRoot>(0);
        int i = 0;
        while (i < this.fJavaElements.length) {
            List<IJavaProject> referencingProjects;
            IPackageFragmentRoot root;
            IJavaElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot && JavaDeleteProcessor.skipDeletingReferencedRoot(query, root = (IPackageFragmentRoot)element, referencingProjects = Arrays.asList(JavaElementUtil.getReferencingProjects(root)))) {
                rootsToSkip.add(root);
            }
            ++i;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IJavaElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IPackageFragmentRoot root, List referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String question = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.3", root.getElementName());
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.4");
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        int i = 0;
        while (i < this.fResources.length) {
            String question;
            IFolder folder;
            IResource resource = this.fResources[i];
            if (resource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.5", folder.getName()))) {
                foldersToSkip.add(folder);
            }
            ++i;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentUtil.getJavaElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentUtil.getJavaElements();
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        pm.done();
        return this.fDeleteChange;
    }

    private void addToSetToDelete(IJavaElement[] newElements) {
        this.fJavaElements = ReorgUtils.union(this.fJavaElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }

    private void addGettersSetters() throws JavaModelException {
        IField[] fields = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (fields.length == 0) {
            return;
        }
        Map getterSetterMapping = JavaDeleteProcessor.createGetterSetterMapping(fields);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(getterSetterMapping);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        List gettersSettersToAdd = this.getGettersSettersToDelete(getterSetterMapping);
        this.addToSetToDelete((IJavaElement[])gettersSettersToAdd.toArray(new IMethod[gettersSettersToAdd.size()]));
    }

    private List getGettersSettersToDelete(Map getterSetterMapping) {
        ArrayList<IMethod> gettersSettersToAdd = new ArrayList<IMethod>(getterSetterMapping.size());
        String queryTitle = RefactoringCoreMessages.getString("DeleteRefactoring.8");
        IConfirmQuery getterSetterQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 1);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IField field = (IField)iter.next();
            Assert.isTrue(JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field));
            String deleteGetterSetter = RefactoringCoreMessages.getFormattedString("DeleteRefactoring.9", JavaElementUtil.createFieldSignature(field));
            if (!getterSetterQuery.confirm(deleteGetterSetter)) continue;
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field)) {
                gettersSettersToAdd.add(JavaDeleteProcessor.getGetter(getterSetterMapping, field));
            }
            if (!JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            gettersSettersToAdd.add(JavaDeleteProcessor.getSetter(getterSetterMapping, field));
        }
        return gettersSettersToAdd;
    }

    private void removeAlreadySelectedMethods(Map getterSetterMapping) {
        List<IJavaElement> elementsToDelete = Arrays.asList(this.fJavaElements);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IMethod setter;
            IField field = (IField)iter.next();
            IMethod getter = JavaDeleteProcessor.getGetter(getterSetterMapping, field);
            if (getter != null && elementsToDelete.contains(getter)) {
                JavaDeleteProcessor.removeGetterFromMapping(getterSetterMapping, field);
            }
            if ((setter = JavaDeleteProcessor.getSetter(getterSetterMapping, field)) != null && elementsToDelete.contains(setter)) {
                JavaDeleteProcessor.removeSetterFromMapping(getterSetterMapping, field);
            }
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            getterSetterMapping.remove(field);
        }
    }

    private static Map createGetterSetterMapping(IField[] fields) throws JavaModelException {
        HashMap<IField, IMethod[]> result = new HashMap<IField, IMethod[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            IMethod[] getterSetter = JavaDeleteProcessor.getGetterSetter(field);
            if (getterSetter != null) {
                result.put(field, getterSetter);
            }
            ++i;
        }
        return result;
    }

    private static boolean hasSetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getSetter(getterSetterMapping, field) != null;
    }

    private static boolean hasGetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getGetter(getterSetterMapping, field) != null;
    }

    private static void removeGetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[0] = null;
    }

    private static void removeSetterFromMapping(Map getterSetterMapping, IField field) {
        ((IMethod[])getterSetterMapping.get((Object)field))[1] = null;
    }

    private static IMethod getGetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[0];
    }

    private static IMethod getSetter(Map getterSetterMapping, IField field) {
        return ((IMethod[])getterSetterMapping.get(field))[1];
    }

    private static IField[] getFields(IJavaElement[] elements) {
        ArrayList<IJavaElement> fields = new ArrayList<IJavaElement>(3);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IField) {
                fields.add(elements[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IMethod[] getGetterSetter(IField field) throws JavaModelException {
        IMethod getter = GetterSetterUtil.getGetter(field);
        IMethod setter = GetterSetterUtil.getSetter(field);
        if (getter != null && getter.exists() || setter != null && setter.exists()) {
            return new IMethod[]{getter, setter};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaModelException {
        Set cusToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IJavaElement[])cusToEmpty.toArray(new ICompilationUnit[cusToEmpty.size()]));
    }

    private Set getCusToEmpty() throws JavaModelException {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaElement element = this.fJavaElements[i];
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu != null && !result.contains(cu) && this.willHaveAllTopLevelTypesDeleted(cu)) {
                result.add(cu);
            }
            ++i;
        }
        return result;
    }

    private boolean willHaveAllTopLevelTypesDeleted(ICompilationUnit cu) throws JavaModelException {
        HashSet<IJavaElement> elementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
        IType[] topLevelTypes = cu.getTypes();
        int i = 0;
        while (i < topLevelTypes.length) {
            if (!elementSet.contains(topLevelTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

