/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static IChange createDeleteChange(TextChangeManager manager, IResource[] resources, IJavaElement[] javaElements) throws CoreException {
        CompositeChange composite = new CompositeChange(){

            public boolean isUndoable() {
                return false;
            }
        };
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (!ReorgUtils.isInsideCompilationUnit(element)) {
                composite.add(DeleteChangeCreator.createDeleteChange(element));
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            composite.add(DeleteChangeCreator.createDeleteChange(resources[i]));
            ++i;
        }
        Map grouped = ReorgUtils.groupByCompilationUnit(DeleteChangeCreator.getElementsSmallerThanCu(javaElements));
        if (grouped.size() != 0) {
            Assert.isNotNull(manager);
            Iterator iter = grouped.keySet().iterator();
            while (iter.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iter.next();
                composite.add(DeleteChangeCreator.createDeleteChange(cu, (List)grouped.get(cu), manager));
            }
        }
        return composite;
    }

    private static IChange createDeleteChange(IResource resource) {
        Assert.isTrue(!(resource instanceof IWorkspaceRoot));
        Assert.isTrue(!(resource instanceof IProject));
        if (resource instanceof IFile) {
            return new DeleteFileChange((IFile)resource);
        }
        if (resource instanceof IFolder) {
            return new DeleteFolderChange((IFolder)resource);
        }
        Assert.isTrue(false);
        return null;
    }

    private static IChange createDeleteChange(ICompilationUnit cu, List javaElements, TextChangeManager manager) throws CoreException {
        CompilationUnit cuNode = AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)false);
        ASTRewrite rewrite = new ASTRewrite((ASTNode)cuNode);
        IJavaElement[] elements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        ASTNodeDeleteUtil.markAsDeleted(elements, cuNode, rewrite);
        return DeleteChangeCreator.addTextEditFromRewrite(manager, cu, rewrite);
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChange textChange = manager.get(cu);
        if (textChange instanceof TextFileChange) {
            TextFileChange tfc = (TextFileChange)textChange;
            tfc.setSave(!cu.isWorkingCopy());
        }
        String message = RefactoringCoreMessages.getString("DeleteChangeCreator.1");
        textChange.addTextEdit(message, (TextEdit)resultingEdits);
        rewrite.removeModifications();
        return textChange;
    }

    private static List getElementsSmallerThanCu(IJavaElement[] javaElements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (ReorgUtils.isInsideCompilationUnit(element)) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private static IChange createDeleteChange(IJavaElement javaElement) throws JavaModelException {
        Assert.isTrue(!ReorgUtils.isInsideCompilationUnit(javaElement));
        switch (javaElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createPackageFragmentRootDeleteChange((IPackageFragmentRoot)javaElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((IPackageFragment)javaElement));
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((ICompilationUnit)javaElement));
            }
            case 6: {
                Assert.isTrue(((IClassFile)javaElement).getResource() instanceof IFile);
                return DeleteChangeCreator.createDeleteChange(((IClassFile)javaElement).getResource());
            }
            case 1: {
                Assert.isTrue(false);
                return null;
            }
            case 2: {
                Assert.isTrue(false);
                return null;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                Assert.isTrue(false);
            }
        }
        Assert.isTrue(false);
        return new NullChange();
    }

    private static IChange createSourceManipulationDeleteChange(ISourceManipulation element) {
        IResource resource;
        if ((element instanceof ICompilationUnit || element instanceof IPackageFragment) && (resource = element instanceof ICompilationUnit ? ReorgUtils.getResource((IJavaElement)((ICompilationUnit)element)) : ((IPackageFragment)element).getResource()) != null && resource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(resource);
        }
        return new DeleteSourceManipulationChange(element);
    }

    private static IChange createPackageFragmentRootDeleteChange(IPackageFragmentRoot root) throws JavaModelException {
        IResource resource = root.getResource();
        if (resource != null && resource.isLinked()) {
            CompositeChange composite = new CompositeChange(RefactoringCoreMessages.getString("DeleteRefactoring.delete_package_fragment_root"), 2);
            composite.add(new DeleteFromClasspathChange(root));
            Assert.isTrue(!Checks.isClasspathDelete(root));
            composite.add(DeleteChangeCreator.createDeleteChange(resource));
            return composite;
        }
        Assert.isTrue(!root.isExternal());
        return new DeletePackageFragmentRootChange(root, null);
    }
}

