/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.Resources;

public final class CopyRefactoring
extends Refactoring {
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.ICopyPolicy fCopyPolicy;

    public static boolean isAvailable(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        return CopyRefactoring.isAvailable(ReorgPolicyFactory.createCopyPolicy(resources, javaElements, settings));
    }

    public static CopyRefactoring create(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements, settings);
        if (!CopyRefactoring.isAvailable(copyPolicy)) {
            return null;
        }
        return new CopyRefactoring(copyPolicy);
    }

    private static boolean isAvailable(IReorgPolicy.ICopyPolicy copyPolicy) throws JavaModelException {
        return copyPolicy.canEnable();
    }

    private CopyRefactoring(IReorgPolicy.ICopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull(newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
            result.merge(RefactoringStatus.create(Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public IJavaElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    public RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        Assert.isNotNull(this.fNewNameQueries, "Missing new name queries");
        Assert.isNotNull(this.fReorgQueries, "Missing reorg queries");
        return this.fCopyPolicy.checkInput(pm, this.fReorgQueries);
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        Assert.isNotNull(this.fNewNameQueries);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null);
        try {
            CompositeChange resultComposite = new CompositeChange(){

                public boolean isUndoable() {
                    return false;
                }
            };
            IChange change = this.fCopyPolicy.createChange(pm, this.fNewNameQueries);
            if (change instanceof ICompositeChange) {
                ICompositeChange subComposite = (ICompositeChange)change;
                resultComposite.addAll(subComposite.getChildren());
            } else {
                resultComposite.add(change);
            }
            compositeChange = resultComposite;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("CopyRefactoring.0");
    }
}

