/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;

public class ASTNodeDeleteUtil {
    private ASTNodeDeleteUtil() {
    }

    public static void markAsDeleted(IJavaElement[] javaElements, CompilationUnit cuNode, ASTRewrite rewrite) throws JavaModelException {
        int i = 0;
        while (i < javaElements.length) {
            ASTNodeDeleteUtil.markAsDeleted(javaElements[i], cuNode, rewrite);
            ++i;
        }
        ASTNodeDeleteUtil.propagateFieldDeclarationNodeDeletions(rewrite);
    }

    private static void markAsDeleted(IJavaElement element, CompilationUnit cuNode, ASTRewrite rewrite) throws JavaModelException {
        ASTNode[] declarationNodes = ASTNodeDeleteUtil.getNodesToDelete(element, cuNode);
        int i = 0;
        while (i < declarationNodes.length) {
            ASTNode node = declarationNodes[i];
            if (node != null) {
                rewrite.markAsRemoved(node);
            }
            ++i;
        }
    }

    private static ASTNode[] getNodesToDelete(IJavaElement element, CompilationUnit cuNode) throws JavaModelException {
        if (element.getElementType() == 8) {
            return new ASTNode[]{ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)element, cuNode)};
        }
        if (element.getElementType() == 7 && ((IType)element).isLocal()) {
            IType type = (IType)element;
            if (type.isAnonymous()) {
                return new ASTNode[]{ASTNodeSearchUtil.getClassInstanceCreationNode(type, cuNode)};
            }
            ASTNode[] nodes = ASTNodeSearchUtil.getDeclarationNodes(element, cuNode);
            nodes[0] = nodes[0].getParent();
            return nodes;
        }
        return ASTNodeSearchUtil.getDeclarationNodes(element, cuNode);
    }

    private static void propagateFieldDeclarationNodeDeletions(ASTRewrite rewrite) {
        Set removedNodes = ASTNodeDeleteUtil.getRemovedNodes(rewrite);
        Iterator iter = removedNodes.iterator();
        while (iter.hasNext()) {
            FieldDeclaration fd;
            ASTNode node = (ASTNode)iter.next();
            if (!(node instanceof VariableDeclarationFragment) || !(node.getParent() instanceof FieldDeclaration) || rewrite.isRemoved((ASTNode)(fd = (FieldDeclaration)node.getParent())) || !removedNodes.containsAll(fd.fragments())) continue;
            rewrite.markAsRemoved((ASTNode)fd);
        }
    }

    private static Set getRemovedNodes(final ASTRewrite rewrite) {
        final HashSet result = new HashSet();
        ASTNode rootNode = rewrite.getRootNode();
        if (rootNode != null) {
            rootNode.accept((ASTVisitor)new GenericVisitor(){

                protected boolean visitNode(ASTNode node) {
                    if (rewrite.isRemoved(node)) {
                        result.add(node);
                    }
                    return true;
                }
            });
        }
        return result;
    }
}

