/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScanner;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

class TextMatchFinder {
    private Map fJavaDocMatches;
    private Map fCommentMatches;
    private Map fStringMatches;
    private IJavaSearchScope fScope;
    private RefactoringScanner fScanner;

    private TextMatchFinder(IJavaSearchScope scope, RefactoringScanner scanner, Map javaDocMatches, Map commentMatches, Map stringMatches) {
        Assert.isNotNull(scope);
        Assert.isNotNull(scanner);
        this.fCommentMatches = commentMatches;
        this.fJavaDocMatches = javaDocMatches;
        this.fStringMatches = stringMatches;
        this.fScope = scope;
        this.fScanner = scanner;
    }

    static void findTextMatches(IProgressMonitor pm, IJavaSearchScope scope, ITextUpdating processor, TextChangeManager manager) throws JavaModelException {
        try {
            if (!TextMatchFinder.isSearchingNeeded(processor)) {
                return;
            }
            RefactoringScanner scanner = TextMatchFinder.createScanner(processor);
            HashMap javaDocMatches = new HashMap();
            HashMap commentsMatches = new HashMap();
            HashMap stringMatches = new HashMap();
            TextMatchFinder.findTextMatches(pm, scope, scanner, javaDocMatches, commentsMatches, stringMatches);
            int patternLength = scanner.getPattern().length();
            String newName = processor.getNewElementName();
            TextMatchFinder.addMatches(manager, newName, patternLength, javaDocMatches, RefactoringCoreMessages.getString("TextMatchFinder.javadoc"));
            TextMatchFinder.addMatches(manager, newName, patternLength, commentsMatches, RefactoringCoreMessages.getString("TextMatchFinder.comment"));
            TextMatchFinder.addMatches(manager, newName, patternLength, stringMatches, RefactoringCoreMessages.getString("TextMatchFinder.string"));
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private static void addMatches(TextChangeManager manager, String newText, int patternLength, Map matches, String matchName) throws CoreException {
        Iterator iter = matches.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!(key instanceof ICompilationUnit)) continue;
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists((ICompilationUnit)key);
            Set results = (Set)matches.get(cu);
            Iterator resultIter = results.iterator();
            while (resultIter.hasNext()) {
                int match = (Integer)resultIter.next();
                manager.get(cu).addTextEdit(matchName, (TextEdit)new ReplaceEdit(match, patternLength, newText));
            }
        }
    }

    private static void findTextMatches(IProgressMonitor pm, IJavaSearchScope scope, RefactoringScanner scanner, Map javaDocMatches, Map commentMatches, Map stringMatches) throws JavaModelException {
        new TextMatchFinder(scope, scanner, javaDocMatches, commentMatches, stringMatches).findTextMatches(pm);
    }

    private static boolean isSearchingNeeded(ITextUpdating textUpdating) {
        return textUpdating.getUpdateComments() || textUpdating.getUpdateJavaDoc() || textUpdating.getUpdateStrings();
    }

    private static RefactoringScanner createScanner(ITextUpdating textUpdating) {
        RefactoringScanner scanner = new RefactoringScanner();
        scanner.setAnalyzeComments(textUpdating.getUpdateComments());
        scanner.setAnalyzeJavaDoc(textUpdating.getUpdateJavaDoc());
        scanner.setAnalyzeStrings(textUpdating.getUpdateStrings());
        scanner.setPattern(textUpdating.getCurrentElementName());
        return scanner;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findTextMatches(IProgressMonitor pm) throws JavaModelException {
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            pm.beginTask("", projects.length);
            Set enclosingProjectSet = this.createEnclosingProjectSet();
            int i = 0;
            while (i < projects.length) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (enclosingProjectSet.contains(projects[i].getFullPath())) {
                    this.addTextMatches((IResource)projects[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        pm.done();
    }

    private Set createEnclosingProjectSet() {
        IPath[] enclosingProjects = this.fScope.enclosingProjectsAndJars();
        HashSet<IPath> enclosingProjectSet = new HashSet<IPath>();
        enclosingProjectSet.addAll(Arrays.asList(enclosingProjects));
        return enclosingProjectSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTextMatches(IResource resource, IProgressMonitor pm) throws JavaModelException {
        block16: {
            block15: {
                block14: {
                    block13: {
                        try {
                            try {
                                if (resource instanceof IFile) {
                                    IJavaElement element = JavaCore.create((IResource)resource);
                                    pm.beginTask("", 1);
                                    if (!(element instanceof ICompilationUnit)) {
                                        Object var6_6 = null;
                                        break block13;
                                    }
                                    if (!element.exists()) {
                                        break block14;
                                    }
                                    if (!this.fScope.encloses(element)) {
                                        break block15;
                                    }
                                    this.addTextMatches((ICompilationUnit)element);
                                }
                                if (resource instanceof IContainer) {
                                    IContainer container = (IContainer)resource;
                                    IResource[] members = container.members();
                                    pm.beginTask("", members.length);
                                    pm.subTask(String.valueOf(RefactoringCoreMessages.getString("TextMatchFinder.searching")) + container.getFullPath());
                                    int i = 0;
                                    while (i < members.length) {
                                        if (pm.isCanceled()) {
                                            throw new OperationCanceledException();
                                        }
                                        this.addTextMatches(members[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                        ++i;
                                    }
                                }
                                break block16;
                            }
                            catch (JavaModelException e) {
                                throw e;
                            }
                            catch (CoreException e) {
                                throw new JavaModelException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return;
                }
                Object var6_7 = null;
                pm.done();
                return;
            }
            Object var6_8 = null;
            pm.done();
            return;
        }
        Object var6_10 = null;
        pm.done();
    }

    private void addTextMatches(ICompilationUnit cu) throws JavaModelException {
        this.fScanner.scan(cu);
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        this.fJavaDocMatches.put(wc, this.fScanner.getJavaDocResults());
        this.fCommentMatches.put(wc, this.fScanner.getCommentResults());
        this.fStringMatches.put(wc, this.fScanner.getStringResults());
    }
}

