/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;

public class RenameSourceFolderProcessor
extends RenameProcessor {
    private IPackageFragmentRoot fSourceFolder;

    public void initialize(Object[] elements) {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (!(element instanceof IPackageFragmentRoot)) {
            return;
        }
        this.fSourceFolder = (IPackageFragmentRoot)element;
        this.setNewElementName(this.fSourceFolder.getElementName());
    }

    public boolean isAvailable() throws CoreException {
        if (this.fSourceFolder == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fSourceFolder)) {
            return false;
        }
        if (this.fSourceFolder.isArchive()) {
            return false;
        }
        if (this.fSourceFolder.isExternal()) {
            return false;
        }
        if (!this.fSourceFolder.isConsistent()) {
            return false;
        }
        return !(this.fSourceFolder.getResource() instanceof IProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameSourceFolderRefactoring.rename", new String[]{this.fSourceFolder.getElementName(), this.fNewElementName});
    }

    public IProject[] getAffectedProjects() throws CoreException {
        return JavaProcessors.computeScope((IJavaElement)this.fSourceFolder);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    public IResourceModifications getResourceModifications() throws CoreException {
        ResourceModifications result = new ResourceModifications();
        result.setRename(this.fSourceFolder.getResource(), this.getNewElementName());
        return result;
    }

    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getElementName().equals(this.fNewElementName)) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkActivation() throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        IPath p;
        Assert.isNotNull(newName, "new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.blank"));
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.invalid_name"));
        }
        RefactoringStatus result = RefactoringStatus.create(c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create(c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaProject project = this.fSourceFolder.getJavaProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.already_exists"));
        }
        if (project.getProject().findMember((IPath)new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameSourceFolderRefactoring.alread_exists"));
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        RenameSourceFolderChange renameSourceFolderChange;
        pm.beginTask("", 1);
        try {
            renameSourceFolderChange = new RenameSourceFolderChange(this.fSourceFolder, this.fNewElementName);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameSourceFolderChange;
    }
}

