/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;

public class RenameResourceProcessor
extends RenameProcessor {
    private IResource fResource;
    static /* synthetic */ Class class$0;

    public RenameResourceProcessor() {
        super(0);
    }

    public void initialize(Object[] elements) throws CoreException {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (!(element instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        if (this.fResource == null) {
            return;
        }
        this.setNewElementName(this.fResource.getName());
    }

    public boolean isAvailable() throws JavaModelException {
        if (this.fResource == null) {
            return false;
        }
        if (!this.fResource.exists()) {
            return false;
        }
        return this.fResource.isAccessible();
    }

    public String getProcessorName() {
        String message = RefactoringCoreMessages.getFormattedString("RenameResourceProcessor.name", new String[]{this.getCurrentElementName(), this.fNewElementName});
        return message;
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public IResourceModifications getResourceModifications() throws CoreException {
        return null;
    }

    public IProject[] getAffectedProjects() {
        return ResourceProcessors.computeScope(this.fResource);
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.fNewElementName));
    }

    public RefactoringStatus checkActivation() throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.Internal_Error"));
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.alread_exists"));
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameResourceRefactoring.invalidName"));
        }
        RefactoringStatus result = RefactoringStatus.create(c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create(c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        RenameResourceChange renameResourceChange;
        pm.beginTask("", 1);
        try {
            renameResourceChange = new RenameResourceChange(this.fResource, this.fNewElementName);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameResourceChange;
    }
}

