/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.IProcessorBasedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRenameParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.SharableParticipants;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameRefactoring;

public class RenameRefactoring
extends Refactoring
implements IProcessorBasedRefactoring,
IRenameRefactoring {
    private Object fElement;
    private IRenameProcessor fProcessor;
    private IRenameParticipant[] fElementParticipants;
    private IRenameParticipant[] fDerivedParticipants;
    private IRefactoringParticipant[] fResourceParticipants;

    public RenameRefactoring(Object element) throws CoreException {
        Assert.isNotNull(element);
        this.fElement = element;
        this.fProcessor = RenameExtensionManager.getProcessor(new Object[]{this.fElement});
    }

    public boolean isAvailable() {
        return this.fProcessor != null;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance(this.fProcessor)) {
            return this.fProcessor;
        }
        return super.getAdapter(clazz);
    }

    public IRefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public int getStyle() {
        return this.fProcessor.getStyle();
    }

    public String getNewName() {
        return this.fProcessor.getNewElementName();
    }

    public void setNewName(String newName) {
        this.fProcessor.setNewElementName(newName);
    }

    public String getCurrentName() {
        return this.fProcessor.getCurrentElementName();
    }

    public Object getNewElement() throws JavaModelException {
        try {
            return this.fProcessor.getNewElement();
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public RefactoringStatus checkNewName(String newName) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            result.merge(this.fProcessor.checkNewElementName(newName));
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    public String getName() {
        return this.fProcessor.getProcessorName();
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            result.merge(this.fProcessor.checkActivation());
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        try {
            this.fElementParticipants = RenameExtensionManager.getParticipants(this.fProcessor, this.fProcessor.getElements());
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        int i = 0;
        while (i < this.fElementParticipants.length) {
            IRenameParticipant participant = this.fElementParticipants[i];
            try {
                result.merge(participant.checkActivation());
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            IRefactoringParticipant participant;
            this.initParticipants();
            pm.beginTask("", 2 + this.fElementParticipants.length + this.fDerivedParticipants.length + this.fResourceParticipants.length);
            result.merge(this.fProcessor.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (result.hasFatalError()) {
                return result;
            }
            int i = 0;
            while (i < this.fElementParticipants.length) {
                participant = this.fElementParticipants[i];
                this.fProcessor.propagateDataTo((IRenameParticipant)participant);
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fElementParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fDerivedParticipants.length) {
                participant = this.fDerivedParticipants[i];
                this.fProcessor.propagateDataTo((IRenameParticipant)participant);
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fDerivedParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fResourceParticipants.length) {
                participant = this.fResourceParticipants[i];
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fResourceParticipants.length)));
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fElementParticipants.length + this.fDerivedParticipants.length + this.fResourceParticipants.length + 1);
        CompositeChange result = new CompositeChange();
        try {
            IRefactoringParticipant participant;
            result.add(this.fProcessor.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            int i = 0;
            while (i < this.fElementParticipants.length) {
                participant = this.fElementParticipants[i];
                this.fProcessor.propagateDataTo((IRenameParticipant)participant);
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fElementParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fDerivedParticipants.length) {
                participant = this.fDerivedParticipants[i];
                this.fProcessor.propagateDataTo((IRenameParticipant)participant);
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fDerivedParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fResourceParticipants.length) {
                participant = this.fResourceParticipants[i];
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fResourceParticipants.length)));
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    private void initParticipants() throws CoreException {
        this.fDerivedParticipants = RenameExtensionManager.getParticipants(this.fProcessor, this.fProcessor.getDerivedElements());
        IResourceModifications resourceModifications = this.fProcessor.getResourceModifications();
        this.fResourceParticipants = resourceModifications != null ? resourceModifications.getParticipants(this.fProcessor, new SharableParticipants()) : new IRefactoringParticipant[0];
    }

    public String toString() {
        if (this.isAvailable()) {
            return this.getName();
        }
        return "No refactoring available to process: " + this.fElement;
    }
}

