/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchFinder;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenamePackageProcessor
extends RenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    private IPackageFragment fPackage;
    private SearchResultGroup[] fOccurrences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateJavaDoc;
    private boolean fUpdateComments;
    private boolean fUpdateStrings;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;

    public void initialize(Object[] elements) {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (!(element instanceof IPackageFragment)) {
            return;
        }
        this.fPackage = (IPackageFragment)element;
        this.setNewElementName(this.fPackage.getElementName());
        this.fUpdateReferences = true;
        this.fUpdateJavaDoc = false;
        this.fUpdateComments = false;
        this.fUpdateStrings = false;
    }

    public boolean isAvailable() throws CoreException {
        if (this.fPackage == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fPackage)) {
            return false;
        }
        return !this.fPackage.isDefaultPackage();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.name", new String[]{this.fPackage.getElementName(), this.fNewElementName});
    }

    public IProject[] getAffectedProjects() throws CoreException {
        return JavaProcessors.computeScope((IJavaElement)this.fPackage);
    }

    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    public IResourceModifications getResourceModifications() throws CoreException {
        ResourceModifications result = new ResourceModifications();
        IContainer container = (IContainer)this.fPackage.getResource();
        if (container == null) {
            return null;
        }
        IResource[] members = container.members();
        int files = 0;
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member instanceof IFile) {
                result.addMove(member);
                ++files;
            }
            ++i;
        }
        IPath path = this.fPackage.getParent().getPath();
        path = path.append(this.getNewElementName().replace('.', '/'));
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (!target.exists()) {
            result.addCreate((IResource)target);
        }
        result.setMoveTarget((IContainer)target);
        if (files == members.length) {
            result.addDelete((IResource)container);
        }
        return result;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateJavaDoc() {
        return this.fUpdateJavaDoc;
    }

    public boolean getUpdateComments() {
        return this.fUpdateComments;
    }

    public boolean getUpdateStrings() {
        return this.fUpdateStrings;
    }

    public void setUpdateJavaDoc(boolean update) {
        this.fUpdateJavaDoc = update;
    }

    public void setUpdateComments(boolean update) {
        this.fUpdateComments = update;
    }

    public void setUpdateStrings(boolean update) {
        this.fUpdateStrings = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkPackageName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenamePackageRefactoring.another_name"));
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    public Object getNewElement() {
        IJavaElement parent = this.fPackage.getParent();
        if (!(parent instanceof IPackageFragmentRoot)) {
            return this.fPackage;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
        return root.getPackageFragment(this.fNewElementName);
    }

    public RefactoringStatus checkActivation() throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block10: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 15);
                pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.checking"));
                result = new RefactoringStatus();
                result.merge(this.checkNewElementName(this.fNewElementName));
                pm.worked(1);
                result.merge(this.checkForNativeMethods());
                pm.worked(1);
                result.merge(this.checkForMainMethods());
                pm.worked(1);
                if (this.fPackage.isReadOnly()) {
                    String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.Packagered_only", this.fPackage.getElementName());
                    result.addFatalError(message);
                } else if (this.fPackage.getResource().isReadOnly()) {
                    String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.resource_read_only", this.fPackage.getElementName());
                    result.addError(message);
                }
                if (this.fUpdateReferences) {
                    pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.searching"));
                    this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 6));
                    pm.setTaskName(RefactoringCoreMessages.getString("RenamePackageRefactoring.checking"));
                    result.merge(this.analyzeAffectedCompilationUnits());
                    pm.worked(1);
                } else {
                    pm.worked(9);
                }
                result.merge(this.checkPackageName(this.fNewElementName));
                if (!result.hasFatalError()) break block10;
                refactoringStatus = result;
                Object var4_7 = null;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3));
        if (this.fUpdateQualifiedNames) {
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            pm.worked(1);
        }
        result.merge(this.validateModifiesFiles());
        RefactoringStatus refactoringStatus = result;
        Object var4_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fPackage);
    }

    private ISearchPattern createSearchPattern() {
        return SearchEngine.createSearchPattern((IJavaElement)this.fPackage, (int)2);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm) throws CoreException {
        return RefactoringSearchEngine.search(pm, this.createRefactoringScope(), this.createSearchPattern());
    }

    private RefactoringStatus checkForMainMethods() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForMainMethods(cus[i]));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkForNativeMethods() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(Checks.checkForNativeMethods(cus[i]));
            ++i;
        }
        return result;
    }

    public static boolean isPackageNameOkInRoot(String newName, IPackageFragmentRoot root) throws CoreException {
        IPackageFragment pack = root.getPackageFragment(newName);
        if (!pack.exists()) {
            return true;
        }
        if (!pack.hasSubpackages()) {
            return false;
        }
        if (pack.containsJavaResources()) {
            return false;
        }
        return pack.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws CoreException {
        if (RenamePackageProcessor.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenamePackageRefactoring.package_exists"));
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IPackageFragmentRoot[] roots = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            if (!RenamePackageProcessor.isPackageNameOkInRoot(newName, roots[i])) {
                String message = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.aleady_exists", new Object[]{this.fNewElementName, roots[i].getElementName()});
                status.merge(RefactoringStatus.createWarningStatus(message));
                status.merge(this.checkTypeNameConflicts(roots[i], newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set getTopLevelTypeNames() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        HashSet result = new HashSet(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenamePackageProcessor.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws CoreException {
        IType[] types = iCompilationUnit.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot root, String newName, Set topLevelTypeNames) throws CoreException {
        IPackageFragment otherPack = root.getPackageFragment(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ICompilationUnit[] cus = otherPack.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set topLevelTypeNames) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iCompilationUnit.getTypes();
        String packageName = iCompilationUnit.getParent().getElementName();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                String[] keys = new String[]{packageName, name};
                String msg = RefactoringCoreMessages.getFormattedString("RenamePackageRefactoring.contains_type", keys);
                Context context = JavaStatusContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    private IFile[] getAllCusInPackageAsFiles() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource res = ResourceUtil.getResource(cus[i]);
            if (res != null && res.getType() == 1) {
                files.add(res);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> combined = new ArrayList<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        combined.addAll(Arrays.asList(this.getAllCusInPackageAsFiles()));
        if (this.fQualifiedNameSearchResult != null) {
            combined.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        CompositeChange compositeChange;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("RenamePackageRefactoring.creating_change"), 1);
            CompositeChange builder = new CompositeChange(RefactoringCoreMessages.getString("Change.javaChanges"));
            builder.addAll(this.fChangeManager.getAllChanges());
            if (this.fQualifiedNameSearchResult != null) {
                builder.addAll(this.fQualifiedNameSearchResult.getAllChanges());
            }
            builder.add(new RenamePackageChange(this.fPackage, this.fNewElementName));
            pm.worked(1);
            compositeChange = builder;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        TextMatchFinder.findTextMatches(pm, this.createRefactoringScope(), this, manager);
    }

    private TextEdit createTextChange(SearchResult searchResult) {
        return new ReplaceEdit(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart(), this.fNewElementName);
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        TextChangeManager manager = new TextChangeManager();
        pm.subTask(RefactoringCoreMessages.getString("RenamePackageRefactoring.searching_text"));
        this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (this.fUpdateReferences) {
            this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        return manager;
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                String name = RefactoringCoreMessages.getString("RenamePackageRefactoring.update_reference");
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                SearchResult[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    manager.get(wc).addTextEdit(name, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fPackage.getElementName(), this.fNewElementName, this.fFilePatterns, this.fPackage.getJavaProject().getProject(), pm);
    }
}

