/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    public boolean isAvailable() throws CoreException {
        return super.isAvailable() && !MethodChecks.isVirtual(this.getMethod());
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block6: {
            pm.beginTask("", 2);
            result = new RefactoringStatus();
            result.merge(super.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!result.hasFatalError()) break block6;
            RefactoringStatus refactoringStatus2 = result;
            Object var8_5 = null;
            pm.done();
            return refactoringStatus2;
        }
        try {
            IMethod[] hierarchyMethods = this.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod(), this.getNewElementName());
            int i = 0;
            while (i < hierarchyMethods.length) {
                String message;
                IMethod hierarchyMethod = hierarchyMethods[i];
                Context context = JavaStatusContext.create((IMember)hierarchyMethod);
                if (Checks.compareParamTypes(this.getMethod().getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                    message = RefactoringCoreMessages.getFormattedString("RenamePrivateMethodRefactoring.hierarchy_defines", new String[]{JavaModelUtil.getFullyQualifiedName(this.getMethod().getDeclaringType()), this.getNewElementName()});
                    result.addError(message, context);
                } else {
                    message = RefactoringCoreMessages.getFormattedString("RenamePrivateMethodRefactoring.hierarchy_defines2", new String[]{JavaModelUtil.getFullyQualifiedName(this.getMethod().getDeclaringType()), this.getNewElementName()});
                    result.addWarning(message, context);
                }
                ++i;
            }
            refactoringStatus = result;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        ISearchPattern pattern = this.createReferenceSearchPattern();
        SearchResultGroup[] groups = RefactoringSearchEngine.search(this.createRefactoringScope(), pattern, new MethodOccurenceCollector((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod().getElementName()));
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(group.getCompilationUnit());
            if (wc.equals(this.declaringWorkingCopy())) {
                SearchResult declarationResult = new SearchResult(group.getResource(), this.getMethod().getNameRange().getOffset(), this.getMethod().getNameRange().getOffset() + this.getMethod().getNameRange().getLength(), (IJavaElement)this.getMethod(), 0);
                group.add(declarationResult);
                break;
            }
            ++i;
        }
        return groups;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        this.addReferenceUpdates(manager, pm);
        this.addDeclarationUpdate(manager.get(this.declaringWorkingCopy()));
        pm.worked(1);
    }

    private ICompilationUnit declaringWorkingCopy() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.getMethod().getCompilationUnit());
    }

    ISearchPattern createOccurrenceSearchPattern(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)this.getMethod(), (int)3);
        pm.done();
        return pattern;
    }

    private ISearchPattern createReferenceSearchPattern() {
        return SearchEngine.createSearchPattern((IJavaElement)this.getMethod(), (int)2);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        SearchResultGroup[] grouped = this.getReferences(pm);
        int i = 0;
        while (i < grouped.length) {
            SearchResultGroup group = grouped[i];
            SearchResult[] results = group.getSearchResults();
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(group.getCompilationUnit());
            TextChange change = manager.get(cu);
            int j = 0;
            while (j < results.length) {
                String editName = RefactoringCoreMessages.getString("RenamePrivateMethodRefactoring.update");
                change.addTextEdit(editName, this.createTextChange(results[j]));
                ++j;
            }
            ++i;
        }
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        ISearchPattern pattern = this.createReferenceSearchPattern();
        return RefactoringSearchEngine.search(this.createRefactoringScope(), pattern, new MethodOccurenceCollector((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod().getElementName()));
    }
}

