/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RenameMethodProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private TextChangeManager fChangeManager;
    private ICompilationUnit[] fNewWorkingCopies;

    protected void setData(RenameMethodProcessor other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.fNewElementName = other.fNewElementName;
    }

    public void initialize(Object[] elements) {
        Assert.isTrue(elements != null && elements.length == 1);
        Object method = elements[0];
        if (!(method instanceof IMethod)) {
            return;
        }
        this.fMethod = (IMethod)method;
        this.setNewElementName(this.fMethod.getElementName());
        this.fUpdateReferences = true;
    }

    public boolean isAvailable() throws CoreException {
        if (this.fMethod == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fMethod)) {
            return false;
        }
        if (this.fMethod.isConstructor()) {
            return false;
        }
        return !RenameMethodProcessor.isSpecialCase(this.fMethod);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.name", new String[]{this.fMethod.getElementName(), this.getNewElementName()});
    }

    public IProject[] getAffectedProjects() throws CoreException {
        return JavaProcessors.computeScope((IJavaElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    public Object[] getDerivedElements() throws CoreException {
        return new Object[0];
    }

    public IResourceModifications getResourceModifications() {
        return null;
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkMethodName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameMethodRefactoring.same_name"));
        }
        return result;
    }

    public Object getNewElement() {
        return this.fMethod.getDeclaringType().getMethod(this.fNewElementName, this.fMethod.getParameterTypes());
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus checkActivation() throws CoreException {
        IMethod orig = RenameMethodProcessor.getOriginalMethod(this.fMethod);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.deleted", this.fMethod.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fMethod = orig;
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fMethod);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.getString("RenameMethodRefactoring.no_native"));
        }
        return result;
    }

    private static IMethod getOriginalMethod(IMethod method) throws CoreException {
        return (IMethod)WorkingCopyUtil.getOriginal((IMember)method);
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block11: {
            block10: {
                block9: {
                    RefactoringStatus refactoringStatus;
                    try {
                        result = new RefactoringStatus();
                        pm.beginTask("", 4);
                        if (Checks.isAvailable((IJavaElement)this.fMethod)) break block9;
                        result.addFatalError("Method to be renamed is binary.", JavaStatusContext.create((IMember)this.fMethod));
                        refactoringStatus = result;
                        Object var3_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_11 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                if (!result.hasFatalError()) break block10;
                RefactoringStatus refactoringStatus = result;
                Object var3_8 = null;
                pm.done();
                return refactoringStatus;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
            result.merge(this.checkNewElementName(this.fNewElementName));
            pm.worked(1);
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.searchingForReferences"));
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 4));
            pm.setTaskName(RefactoringCoreMessages.getString("RenameMethodRefactoring.taskName.checkingPreconditions"));
            if (this.fUpdateReferences) {
                result.merge(this.checkRelatedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeCompilationUnits());
            }
            pm.worked(1);
            if (!result.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus = result;
            Object var3_9 = null;
            pm.done();
            return refactoringStatus;
        }
        if (this.fUpdateReferences) {
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 3));
        result.merge(this.validateModifiesFiles());
        RefactoringStatus refactoringStatus = result;
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    protected final IJavaSearchScope createRefactoringScope() throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    ISearchPattern createOccurrenceSearchPattern(IProgressMonitor pm) throws CoreException {
        return RenameMethodProcessor.createSearchPattern(pm, this.fMethod, null);
    }

    private static ISearchPattern createSearchPattern(IProgressMonitor pm, IMethod method, IWorkingCopy[] workingCopies) throws CoreException {
        pm.beginTask("", 4);
        Set methods = RenameMethodProcessor.methodsToRename(method, (IProgressMonitor)new SubProgressMonitor(pm, 3), workingCopies);
        IMethod[] ms = methods.toArray(new IMethod[methods.size()]);
        pm.done();
        return RefactoringSearchEngine.createSearchPattern((IJavaElement[])ms, 3);
    }

    static Set getMethodsToRename(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws CoreException {
        return new HashSet<IMethod>(Arrays.asList(RippleMethodFinder.getRelatedMethods(method, pm, workingCopies)));
    }

    private static Set methodsToRename(IMethod method, IProgressMonitor pm, IWorkingCopy[] workingCopies) throws CoreException {
        HashSet<IMethod> methods = new HashSet<IMethod>();
        pm.beginTask("", 1);
        methods.add(method);
        methods.addAll(RenameMethodProcessor.getMethodsToRename(method, (IProgressMonitor)new SubProgressMonitor(pm, 1), workingCopies));
        pm.done();
        return methods;
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        ISearchPattern pattern = this.createOccurrenceSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return RefactoringSearchEngine.search(this.createRefactoringScope(), pattern, new MethodOccurenceCollector((IProgressMonitor)new SubProgressMonitor(pm, 1), this.getMethod().getElementName()));
    }

    private static boolean isSpecialCase(IMethod method) throws CoreException {
        if (method.getElementName().equals("toString") && method.getNumberOfParameters() == 0 && (method.getReturnType().equals("Ljava.lang.String;") || method.getReturnType().equals("QString;") || method.getReturnType().equals("Qjava.lang.String;"))) {
            return true;
        }
        return method.isMainMethod();
    }

    private static RefactoringStatus checkIfConstructorName(IMethod method, String newName) {
        return Checks.checkIfConstructorName(method, newName, method.getDeclaringType().getElementName());
    }

    private RefactoringStatus checkRelatedMethods(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = RenameMethodProcessor.getMethodsToRename(this.fMethod, pm, null).iterator();
        while (iter.hasNext()) {
            IMethod method = (IMethod)iter.next();
            result.merge(RenameMethodProcessor.checkIfConstructorName(method, this.fNewElementName));
            String[] msgData = new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())};
            if (!method.exists()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.not_in_model", msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_binary", msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_read_only", msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(RefactoringCoreMessages.getFormattedString("RenameMethodRefactoring.no_native_1", msgData));
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        int i2;
        Throwable throwable2;
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                RefactoringStatus result;
                pm.beginTask("", 3);
                TextChangeManager manager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                SearchResultGroup[] oldOccurrences = this.getOccurrences();
                SearchResultGroup[] newOccurrences = this.getNewOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
                refactoringStatus = result = RenameAnalyzeUtil.analyzeRenameChanges(manager, oldOccurrences, newOccurrences);
                Object var6_7 = null;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                pm.done();
                if (this.fNewWorkingCopies == null) throw throwable2;
                i2 = 0;
                break block6;
            }
            pm.done();
            if (this.fNewWorkingCopies == null) return refactoringStatus;
            int i2 = 0;
            while (true) {
                if (i2 >= this.fNewWorkingCopies.length) {
                    return refactoringStatus;
                }
                this.fNewWorkingCopies[i2].destroy();
                ++i2;
            }
        }
        while (true) {
            if (i2 >= this.fNewWorkingCopies.length) {
                throw throwable2;
            }
            this.fNewWorkingCopies[i2].destroy();
            ++i2;
        }
    }

    private SearchResultGroup[] getNewOccurrences(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        IMethod method;
        block5: {
            ICompilationUnit declaringCuWorkingCopy;
            block4: {
                SearchResultGroup[] searchResultGroupArray;
                pm.beginTask("", 3);
                try {
                    ICompilationUnit[] compilationUnitsToModify = manager.getAllCompilationUnits();
                    this.fNewWorkingCopies = RenameAnalyzeUtil.getNewWorkingCopies(compilationUnitsToModify, manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    declaringCuWorkingCopy = RenameAnalyzeUtil.findWorkingCopyForCu(this.fNewWorkingCopies, this.fMethod.getCompilationUnit());
                    if (declaringCuWorkingCopy != null) break block4;
                    searchResultGroupArray = new SearchResultGroup[]{};
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return searchResultGroupArray;
            }
            method = this.getNewMethod(declaringCuWorkingCopy);
            if (method != null && method.exists()) break block5;
            SearchResultGroup[] searchResultGroupArray = new SearchResultGroup[]{};
            Object var7_9 = null;
            pm.done();
            return searchResultGroupArray;
        }
        ISearchPattern newPattern = RenameMethodProcessor.createSearchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1), method, (IWorkingCopy[])this.fNewWorkingCopies);
        SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(this.createRefactoringScope(), newPattern, new MethodOccurenceCollector((IProgressMonitor)new SubProgressMonitor(pm, 1), method.getElementName()), this.fNewWorkingCopies);
        Object var7_10 = null;
        pm.done();
        return searchResultGroupArray;
    }

    private IMethod getNewMethod(ICompilationUnit newWorkingCopyOfDeclaringCu) throws CoreException {
        IType[] allNewTypes = newWorkingCopyOfDeclaringCu.getAllTypes();
        String fullyTypeName = this.fMethod.getDeclaringType().getFullyQualifiedName();
        String[] paramTypeSignatures = this.fMethod.getParameterTypes();
        int i = 0;
        while (i < allNewTypes.length) {
            if (allNewTypes[i].getFullyQualifiedName().equals(fullyTypeName)) {
                return allNewTypes[i].getMethod(this.fNewElementName, paramTypeSignatures);
            }
            ++i;
        }
        return null;
    }

    private IMethod[] classesDeclareMethodName(ITypeHierarchy hier, List classes, IMethod method, String newName) throws CoreException {
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            IMethod[] methods = clazz.getMethods();
            boolean isSubclass = subtypes.contains(clazz);
            int j = 0;
            while (j < methods.length) {
                IMethod foundMethod = Checks.findMethod(newName, parameterCount, false, new IMethod[]{methods[j]});
                if (foundMethod != null) {
                    if (isSubclass || type.equals(clazz)) {
                        result.add(foundMethod);
                    } else if (!isMethodPrivate && !JdtFlags.isPrivate((IMember)methods[j])) {
                        result.add(foundMethod);
                    }
                }
                ++j;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    final IMethod[] hierarchyDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        IType[] implementingClasses;
        IMethod[] foundInImplementingClasses;
        IMethod[] foundInHierarchyClasses;
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        ITypeHierarchy hier = type.newTypeHierarchy(pm);
        IMethod foundMethod = Checks.findMethod(newName, method.getParameterTypes().length, false, type);
        if (foundMethod != null) {
            result.add(foundMethod);
        }
        if ((foundInHierarchyClasses = this.classesDeclareMethodName(hier, Arrays.asList(hier.getAllClasses()), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInHierarchyClasses));
        }
        if ((foundInImplementingClasses = this.classesDeclareMethodName(hier, Arrays.asList(implementingClasses = hier.getImplementingClasses(type)), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInImplementingClasses));
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public final IChange createChange(IProgressMonitor pm) throws CoreException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("Change.javaChanges"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager manager = new TextChangeManager(true);
        if (!this.fUpdateReferences) {
            this.addDeclarationUpdate(manager);
        } else {
            this.addOccurrences(manager, pm);
        }
        return manager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                SearchResult[] results = this.fOccurrences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    String editName = RefactoringCoreMessages.getString("RenameMethodRefactoring.update_occurrence");
                    manager.get(wc).addTextEdit(editName, this.createTextChange(results[j]));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fMethod.getCompilationUnit());
        TextChange change = manager.get(cu);
        this.addDeclarationUpdate(change);
    }

    final void addDeclarationUpdate(TextChange change) throws CoreException {
        change.addTextEdit(RefactoringCoreMessages.getString("RenameMethodRefactoring.update_declaration"), (TextEdit)new ReplaceEdit(this.fMethod.getNameRange().getOffset(), this.fMethod.getNameRange().getLength(), this.fNewElementName));
    }

    final TextEdit createTextChange(SearchResult searchResult) {
        return new ReplaceEdit(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart(), this.fNewElementName);
    }
}

