/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;

public class RenameJavaProjectProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private IJavaProject fProject;
    private boolean fUpdateReferences;

    public void initialize(Object[] elements) {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (!(element instanceof IJavaProject)) {
            return;
        }
        this.fProject = (IJavaProject)element;
        this.setNewElementName(this.fProject.getElementName());
        this.fUpdateReferences = true;
    }

    public boolean isAvailable() throws CoreException {
        if (this.fProject == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fProject)) {
            return false;
        }
        return this.fProject.isConsistent();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.rename", new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    public IProject[] getAffectedProjects() throws CoreException {
        return JavaProcessors.computeScope((IJavaElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    public IResourceModifications getResourceModifications() throws CoreException {
        ResourceModifications result = new ResourceModifications();
        result.setRename((IResource)this.fProject.getProject(), this.getNewElementName());
        return result;
    }

    public Object getNewElement() throws CoreException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkActivation() throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = RefactoringStatus.create(ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameJavaProjectRefactoring.already_exists"));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            pm.beginTask("", 1);
            try {
                if (!this.isReadOnly()) break block3;
                String message = RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.read_only", this.fProject.getElementName());
                refactoringStatus = RefactoringStatus.createErrorStatus(message);
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() throws CoreException {
        return this.fProject.getResource().isReadOnly();
    }

    private boolean projectNameAlreadyExists(String newName) {
        return this.fProject.getJavaModel().getJavaProject(newName).exists();
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        RenameJavaProjectChange renameJavaProjectChange;
        pm.beginTask("", 1);
        try {
            renameJavaProjectChange = new RenameJavaProjectChange(this.fProject, this.fNewElementName, this.fUpdateReferences);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return renameJavaProjectChange;
    }
}

