/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.RenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class RenameCompilationUnitProcessor
extends RenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    private RenameTypeProcessor fRenameTypeProcessor;
    private boolean fWillRenameType;
    private ICompilationUnit fCu;

    public void initialize(Object[] elements) throws CoreException {
        Assert.isTrue(elements != null && elements.length == 1);
        Object element = elements[0];
        if (element instanceof IFile) {
            IJavaElement jElement = JavaCore.create((IFile)((IFile)element));
            if (jElement != null && jElement.exists() && jElement.getElementType() == 5) {
                this.fCu = (ICompilationUnit)jElement;
            }
        } else if (element instanceof ICompilationUnit) {
            this.fCu = (ICompilationUnit)element;
        }
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public boolean isAvailable() {
        if (this.fCu == null) {
            return false;
        }
        if (!this.fCu.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(this.fCu)) {
            return false;
        }
        return !this.fCu.isReadOnly();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.name", new String[]{this.fCu.getElementName(), this.getNewElementName()});
    }

    public IProject[] getAffectedProjects() throws CoreException {
        return JavaProcessors.computeScope((IJavaElement)this.fCu);
    }

    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    public Object[] getDerivedElements() {
        if (this.fRenameTypeProcessor == null) {
            return new Object[0];
        }
        return new Object[]{this.fRenameTypeProcessor.getElements()};
    }

    public IResourceModifications getResourceModifications() {
        IResource resource = this.fCu.getResource();
        if (resource == null) {
            return null;
        }
        ResourceModifications result = new ResourceModifications();
        result.setRename(resource, this.getNewElementName());
        return result;
    }

    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        String typeName = RenameCompilationUnitProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkCompilationUnitName(newName);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameCompilationUnitRefactoring.same_name"));
        }
        return result;
    }

    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(newName));
        }
    }

    public Object getNewElement() {
        IJavaElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (JavaConventions.validateCompilationUnitName((String)this.getNewElementName()).getSeverity() == 4) {
            return this.fCu;
        }
        return pack.getCompilationUnit(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public boolean getUpdateJavaDoc() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateJavaDoc();
    }

    public boolean getUpdateComments() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateComments();
    }

    public boolean getUpdateStrings() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateStrings();
    }

    public void setUpdateJavaDoc(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateJavaDoc(update);
        }
    }

    public void setUpdateComments(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateComments(update);
        }
    }

    public void setUpdateStrings(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateStrings(update);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    public RefactoringStatus checkActivation() throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CoreException {
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                    RefactoringStatus result1 = new RefactoringStatus();
                    RefactoringStatus result2 = new RefactoringStatus();
                    result2.merge(Checks.checkCompilationUnitNewName(this.fCu, this.fNewElementName));
                    if (result2.hasFatalError()) {
                        result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed_1", this.fCu.getElementName()));
                    } else {
                        result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed", this.fCu.getElementName()));
                    }
                    result1.merge(result2);
                }
                if (!this.fWillRenameType) break block6;
                refactoringStatus = this.fRenameTypeProcessor.checkInput(pm);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.fNewElementName);
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        if (type != null) {
            this.fRenameTypeProcessor = new RenameTypeProcessor();
            this.fRenameTypeProcessor.initialize(new Object[]{type});
        } else {
            this.fRenameTypeProcessor = null;
        }
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public IChange createChange(IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        IResource resource = ResourceUtil.getResource(this.fCu);
        if (resource != null && resource.isLinked()) {
            return new RenameResourceChange(resource, this.getNewElementName());
        }
        return new RenameCompilationUnitChange(this.fCu, this.getNewElementName());
    }
}

