/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

class RenameAnalyzeUtil {
    private RenameAnalyzeUtil() {
    }

    static RefactoringStatus analyzeRenameChanges(TextChangeManager manager, SearchResultGroup[] oldOccurrences, SearchResultGroup[] newOccurrences) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < oldOccurrences.length) {
            SearchResultGroup searchResultGroup = oldOccurrences[i];
            SearchResult[] searchResults = searchResultGroup.getSearchResults();
            ICompilationUnit cunit = searchResultGroup.getCompilationUnit();
            if (cunit != null) {
                int j = 0;
                while (j < searchResults.length) {
                    SearchResult searchResult = searchResults[j];
                    if (!RenameAnalyzeUtil.existsInNewOccurrences(searchResult, newOccurrences, manager)) {
                        SourceRange range = new SourceRange(searchResult.getStart(), searchResult.getEnd() - searchResult.getStart());
                        Context context = JavaStatusContext.create(cunit, range);
                        String message = RefactoringCoreMessages.getFormattedString("RenameAnalyzeUtil.shadows", cunit.getElementName());
                        result.addError(message, context);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    static ICompilationUnit findWorkingCopyForCu(ICompilationUnit[] newWorkingCopies, ICompilationUnit cu) {
        ICompilationUnit originalDeclaringCu = WorkingCopyUtil.getOriginal(cu);
        int i = 0;
        while (i < newWorkingCopies.length) {
            if (newWorkingCopies[i].getPrimary().equals(originalDeclaringCu)) {
                return newWorkingCopies[i];
            }
            ++i;
        }
        return null;
    }

    static ICompilationUnit[] getNewWorkingCopies(ICompilationUnit[] compilationUnitsToModify, TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", compilationUnitsToModify.length);
        ICompilationUnit[] newWorkingCopies = new ICompilationUnit[compilationUnitsToModify.length];
        int i = 0;
        while (i < compilationUnitsToModify.length) {
            ICompilationUnit cu = compilationUnitsToModify[i];
            newWorkingCopies[i] = WorkingCopyUtil.getNewWorkingCopy(cu);
            newWorkingCopies[i].getBuffer().setContents(manager.get(cu).getPreviewTextBuffer().getContent());
            newWorkingCopies[i].makeConsistent((IProgressMonitor)new SubProgressMonitor(pm, 1));
            ++i;
        }
        return newWorkingCopies;
    }

    private static boolean existsInNewOccurrences(SearchResult searchResult, SearchResultGroup[] newOccurrences, TextChangeManager manager) throws CoreException {
        SearchResultGroup newGroup = RenameAnalyzeUtil.findOccurrenceGroup(searchResult.getResource(), newOccurrences);
        if (newGroup == null) {
            return false;
        }
        IRegion oldEditRange = RenameAnalyzeUtil.getCorrespondingEditChangeRange(searchResult, manager);
        if (oldEditRange == null) {
            return false;
        }
        SearchResult[] newSearchResults = newGroup.getSearchResults();
        int oldRangeOffset = oldEditRange.getOffset();
        int i = 0;
        while (i < newSearchResults.length) {
            if (newSearchResults[i].getStart() == oldRangeOffset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IRegion getCorrespondingEditChangeRange(SearchResult searchResult, TextChangeManager manager) throws CoreException {
        TextChange change = RenameAnalyzeUtil.getTextChange(searchResult, manager);
        if (change == null) {
            return null;
        }
        IRegion oldMatchRange = RenameAnalyzeUtil.createTextRange(searchResult);
        TextChange.EditChange[] editChanges = change.getTextEditChanges();
        int i = 0;
        while (i < editChanges.length) {
            if (oldMatchRange.equals(editChanges[i].getTextRange())) {
                return change.getNewTextRange(editChanges[i]);
            }
            ++i;
        }
        return null;
    }

    private static TextChange getTextChange(SearchResult searchResult, TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = searchResult.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        ICompilationUnit oldWorkingCopy = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        if (oldWorkingCopy == null) {
            return null;
        }
        return manager.get(oldWorkingCopy);
    }

    private static IRegion createTextRange(SearchResult searchResult) {
        int start = searchResult.getStart();
        return new Region(start, searchResult.getEnd() - start);
    }

    private static SearchResultGroup findOccurrenceGroup(IResource resource, SearchResultGroup[] newOccurrences) {
        int i = 0;
        while (i < newOccurrences.length) {
            if (newOccurrences[i].getResource().equals((Object)resource)) {
                return newOccurrences[i];
            }
            ++i;
        }
        return null;
    }
}

