/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class RefactoringScopeFactory {
    private RefactoringScopeFactory() {
    }

    public static IJavaSearchScope create(IMember[] members) throws JavaModelException {
        Assert.isTrue(members != null && members.length > 0);
        IMember candidate = members[0];
        int visibility = RefactoringScopeFactory.getVisibility(candidate);
        int i = 1;
        while (i < members.length) {
            int mv = RefactoringScopeFactory.getVisibility(members[i]);
            if (mv > visibility) {
                visibility = mv;
                candidate = members[i];
            }
            ++i;
        }
        return RefactoringScopeFactory.create((IJavaElement)candidate);
    }

    private static int getVisibility(IMember member) throws JavaModelException {
        if (JdtFlags.isPrivate(member)) {
            return 0;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 2;
        }
        return 4;
    }

    public static IJavaSearchScope create(IJavaElement javaElement) throws JavaModelException {
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            if (JdtFlags.isPrivate(member)) {
                if (member.getCompilationUnit() != null) {
                    return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getCompilationUnit()});
                }
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member});
            }
            if (!JdtFlags.isPublic(member) && !JdtFlags.isProtected(member) && member.getCompilationUnit() != null) {
                IPackageFragment pack = (IPackageFragment)member.getCompilationUnit().getParent();
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{pack});
            }
        }
        return RefactoringScopeFactory.create(javaElement.getJavaProject());
    }

    private static IJavaSearchScope create(IJavaProject javaProject) throws JavaModelException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])RefactoringScopeFactory.getAllScopeElements(javaProject), (boolean)false);
    }

    private static IJavaElement[] getAllScopeElements(IJavaProject project) throws JavaModelException {
        Collection sourceRoots = RefactoringScopeFactory.getAllSourceRootsInProjects(RefactoringScopeFactory.getReferencingProjects(project));
        return sourceRoots.toArray(new IPackageFragmentRoot[sourceRoots.size()]);
    }

    private static Collection getReferencingProjects(IJavaProject focus) throws JavaModelException {
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static void addReferencingProjects(IJavaProject focus, Set projects) throws JavaModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IClasspathEntry entry;
            IJavaProject candidate = JavaCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static IClasspathEntry getReferencingClassPathEntry(IJavaProject referencingProject, IJavaProject referencedProject) throws JavaModelException {
        IClasspathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IClasspathEntry[] classpath = referencingProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static Collection getAllSourceRootsInProjects(Collection projects) throws JavaModelException {
        ArrayList result = new ArrayList();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            result.addAll(RefactoringScopeFactory.getSourceRoots((IJavaProject)it.next()));
        }
        return result;
    }

    private static List getSourceRoots(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IPackageFragmentRoot> elements = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isArchive()) {
                elements.add(root);
            }
            ++i;
        }
        return elements;
    }
}

