/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultCollector;
import org.eclipse.jdt.internal.corext.util.Strings;

final class MethodOccurenceCollector
extends SearchResultCollector {
    private final int fNameLength;

    public MethodOccurenceCollector(IProgressMonitor pm, String methodName) {
        super(pm);
        this.fNameLength = methodName.length();
    }

    public void accept(IResource res, int start, int end, IJavaElement element, int accuracy) throws CoreException {
        int theDotIndex;
        ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
        if (unit == null) {
            return;
        }
        int matchLength = end - start;
        IBuffer buffer = unit.getBuffer();
        String match = buffer.getText(start, matchLength);
        int leftBracketIndex = match.indexOf("(");
        if (leftBracketIndex != -1) {
            end = start + leftBracketIndex;
            match = match.substring(0, leftBracketIndex);
        }
        if ((theDotIndex = match.lastIndexOf(".")) == -1) {
            this.getResults().add(new SearchResult(res, start, start + this.fNameLength, element, accuracy));
        } else {
            start = start + theDotIndex + 1;
            int i = theDotIndex + 1;
            while (i < match.length() && Strings.isIndentChar(match.charAt(i))) {
                ++start;
                ++i;
            }
            this.getResults().add(new SearchResult(res, start, start + this.fNameLength, element, accuracy));
        }
    }
}

