/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;

public class VariablePool
implements IVariablePool {
    public static final String PLUGIN_DESCRIPTOR = "pluginDescriptor";
    public static final String SELECTION = "selection";
    private IVariablePool fParent;
    private Object fDefaultVariable;
    private Map fVariables;

    public VariablePool(IVariablePool parent, Object defaultVariable) {
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
    }

    public VariablePool(IVariablePool parent, Object defaultVariable, Object selection) {
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
        if (selection != null) {
            this.addVariable(SELECTION, selection);
        }
    }

    public IVariablePool getParent() {
        return this.fParent;
    }

    public IVariablePool getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    public void addVariable(String name, Object value) {
        Assert.isNotNull(name);
        Assert.isNotNull(value);
        if (this.fVariables == null) {
            this.fVariables = new HashMap();
        }
        this.fVariables.put(name, value);
    }

    public Object removeVariable(String name) {
        Assert.isNotNull(name);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.remove(name);
    }

    public Object getVariable(String name) {
        Assert.isNotNull(name);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.get(name);
    }

    public Object resolveVariable(String name, Object[] args) throws CoreException {
        if (PLUGIN_DESCRIPTOR.equals(name)) {
            if (args == null || args.length != 1) {
                throw new CoreException((IStatus)new ExpressionStatus(4, 2, "Wrong number of arguments"));
            }
            if (!(args[0] instanceof String)) {
                throw new CoreException((IStatus)new ExpressionStatus(4, 1, "Argument is of wrong type"));
            }
            return Platform.getPluginRegistry().getPluginDescriptor((String)args[0]);
        }
        return null;
    }
}

