/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ITypeExtender;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.LRUCache;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Method;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtender;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtenderDescriptor;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class TypeExtension {
    private static final String EXT_POINT = "typeExtenders";
    private static final String TYPE = "type";
    private static final ITypeExtender[] EMPTY_TYPE_EXTENDER_ARRAY = new ITypeExtender[0];
    private static final TypeExtension[] EMPTY_TYPE_EXTENSION_ARRAY = new TypeExtension[0];
    private static final ITypeExtender CONTINUE = new ITypeExtender(){

        public boolean handles(String method) {
            return false;
        }

        public boolean isLoaded() {
            return false;
        }

        public boolean canLoad() {
            return false;
        }

        public Object invoke(Object receiver, String method, Object[] args) throws CoreException {
            return null;
        }
    };
    private static final TypeExtension END_POINT = new TypeExtension(){

        ITypeExtender find(Object o, String name) {
            return CONTINUE;
        }
    };
    private static final Map fInterfaceMap = new HashMap();
    private static final LRUCache fMethodCache = new LRUCache(100);
    private static final boolean TRACING;
    private Class fType;
    private ITypeExtender[] fExtenders;
    private TypeExtension fExtends;
    private TypeExtension[] fImplements;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/typeExtension/tracing");
        TRACING = value != null && value.equalsIgnoreCase("true");
    }

    private TypeExtension() {
    }

    private TypeExtension(Class type) {
        Assert.isNotNull(type);
        this.fType = type;
        Map map = fInterfaceMap;
        synchronized (map) {
            fInterfaceMap.put(this.fType, this);
        }
    }

    public static Method getMethod(Object receiver, String method) throws CoreException {
        Class<?> clazz;
        Method result;
        Object cached;
        long start = 0L;
        if (TRACING) {
            start = System.currentTimeMillis();
        }
        if ((cached = fMethodCache.get(result = new Method(clazz = receiver.getClass(), method))) != null && TRACING) {
            System.out.println("[Type Extension] - method " + clazz.getName() + "#" + method + " found in cache: " + (System.currentTimeMillis() - start) + " ms.");
            return (Method)cached;
        }
        TypeExtension extension = TypeExtension.get(clazz);
        ITypeExtender extender = extension.find(receiver, method);
        if (extender == CONTINUE) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, "Unknown method: " + method, null));
        }
        result.setExtender(extender);
        fMethodCache.put(result, result);
        if (TRACING) {
            System.out.println("[Type Extension] - method " + clazz.getName() + "#" + method + " not found in cache: " + (System.currentTimeMillis() - start) + " ms.");
        }
        return result;
    }

    private static TypeExtension get(Class clazz) {
        Map map = fInterfaceMap;
        synchronized (map) {
            TypeExtension result = (TypeExtension)fInterfaceMap.get(clazz);
            if (result == null) {
                result = new TypeExtension(clazz);
            }
            return result;
        }
    }

    ITypeExtender find(Object element, String method) throws CoreException {
        TypeExtension typeExtension = this;
        synchronized (typeExtension) {
            if (this.fExtenders == null) {
                this.initialize();
            }
        }
        int i22 = 0;
        while (i22 < this.fExtenders.length) {
            ITypeExtender extender = this.fExtenders[i22];
            if (extender != null && extender.handles(method)) {
                if (extender.isLoaded()) {
                    return extender;
                }
                if (extender.canLoad()) {
                    try {
                        TypeExtenderDescriptor descriptor = (TypeExtenderDescriptor)extender;
                        TypeExtender temp = descriptor.create();
                        temp.initialize(descriptor.getProperties());
                        ITypeExtender[] iTypeExtenderArray = this.fExtenders;
                        synchronized (this.fExtenders) {
                            this.fExtenders[i22] = extender = temp;
                            // ** MonitorExit[var8_13] (shouldn't be in output)
                            return extender;
                        }
                    }
                    catch (CoreException e) {
                        JavaPlugin.getDefault().getLog().log(e.getStatus());
                        this.fExtenders[i22] = null;
                    }
                } else {
                    return extender;
                }
            }
            ++i22;
        }
        TypeExtension i22 = this;
        synchronized (i22) {
            if (this.fExtends == null) {
                Class superClass = this.fType.getSuperclass();
                this.fExtends = superClass != null ? TypeExtension.get(superClass) : END_POINT;
            }
        }
        ITypeExtender result = this.fExtends.find(element, method);
        if (result != CONTINUE) {
            return result;
        }
        i22 = this;
        synchronized (i22) {
            if (this.fImplements == null) {
                Class<?>[] interfaces = this.fType.getInterfaces();
                if (interfaces.length == 0) {
                    this.fImplements = EMPTY_TYPE_EXTENSION_ARRAY;
                } else {
                    this.fImplements = new TypeExtension[interfaces.length];
                    int i = 0;
                    while (i < interfaces.length) {
                        this.fImplements[i] = TypeExtension.get(interfaces[i]);
                        ++i;
                    }
                }
            }
        }
        int i = 0;
        while (i < this.fImplements.length) {
            result = this.fImplements[i].find(element, method);
            if (result != CONTINUE) {
                return result;
            }
            ++i;
        }
        return CONTINUE;
    }

    private void initialize() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXT_POINT);
        String fTypeName = this.fType.getName();
        ArrayList<TypeExtenderDescriptor> result = new ArrayList<TypeExtenderDescriptor>(2);
        int i = 0;
        while (i < ces.length) {
            IConfigurationElement config = ces[i];
            if (fTypeName.equals(config.getAttribute(TYPE))) {
                result.add(new TypeExtenderDescriptor(config));
            }
            ++i;
        }
        this.fExtenders = result.size() == 0 ? EMPTY_TYPE_EXTENDER_ARRAY : result.toArray(new ITypeExtender[result.size()]);
    }

    /* synthetic */ TypeExtension(TypeExtension typeExtension) {
        this();
    }
}

