/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ITypeExtender;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtender;
import org.eclipse.jdt.internal.ui.JavaPlugin;

class TypeExtenderDescriptor
implements ITypeExtender {
    private String fProperties;
    private IConfigurationElement fConfigElement;
    private static final String METHODS = "methods";
    private static final String CLASS = "class";

    public TypeExtenderDescriptor(IConfigurationElement element) {
        this.fConfigElement = element;
        StringBuffer buffer = new StringBuffer(",");
        String properties = element.getAttribute(METHODS);
        int i = 0;
        while (i < properties.length()) {
            char ch = properties.charAt(i);
            if (!Character.isWhitespace(ch)) {
                buffer.append(ch);
            }
            ++i;
        }
        buffer.append(',');
        this.fProperties = buffer.toString();
    }

    public String getProperties() {
        return this.fProperties;
    }

    public boolean handles(String property) {
        return this.fProperties.indexOf("," + property + ",") != -1;
    }

    public boolean isLoaded() {
        return false;
    }

    public boolean canLoad() {
        IPluginDescriptor plugin = this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        return plugin.isPluginActivated();
    }

    public Object invoke(Object receiver, String method, Object[] args) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, "Plug-in delcaring the method isn't loaded yet", null));
    }

    public TypeExtender create() throws CoreException {
        return (TypeExtender)this.fConfigElement.createExecutableExtension(CLASS);
    }
}

