/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.jdt.internal.corext.Assert;

public class TestResult {
    private int fValue;
    private static final int FALSE_VALUE = 0;
    private static final int TRUE_VALUE = 1;
    private static final int NOT_LOADED_VALUE = 2;
    public static final TestResult FALSE = new TestResult(0);
    public static final TestResult TRUE = new TestResult(1);
    public static final TestResult NOT_LOADED = new TestResult(2);
    private static final TestResult[][] AND = new TestResult[][]{{FALSE, FALSE, FALSE}, {FALSE, TRUE, NOT_LOADED}, {FALSE, NOT_LOADED, NOT_LOADED}};
    private static final TestResult[][] OR = new TestResult[][]{{FALSE, TRUE, NOT_LOADED}, {TRUE, TRUE, TRUE}, {NOT_LOADED, TRUE, NOT_LOADED}};
    private static final TestResult[] NOT = new TestResult[]{TRUE, FALSE, NOT_LOADED};

    private TestResult(int value) {
        this.fValue = value;
    }

    public TestResult and(TestResult op) {
        return AND[this.fValue][op.fValue];
    }

    public TestResult or(TestResult op) {
        return OR[this.fValue][op.fValue];
    }

    public TestResult not() {
        return NOT[this.fValue];
    }

    public static TestResult valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static TestResult valueOf(Boolean b) {
        return b != false ? TRUE : FALSE;
    }

    public String toString() {
        switch (this.fValue) {
            case 0: {
                return "false";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "not_loaded";
            }
        }
        Assert.isTrue(false);
        return null;
    }
}

