/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Method;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtension;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class TestExpression
extends Expression {
    private String fProperty;
    private Object[] fArgs;
    public static final String NAME = "test";
    private static final String ATT_PROPERTY = "property";
    private static final String ATT_ARGS = "args";
    private static final Object[] EMPTY_ARGS = new Object[0];

    public TestExpression(IConfigurationElement element) {
        this.fProperty = element.getAttribute(ATT_PROPERTY);
        this.fArgs = this.getArguments(element);
    }

    public TestResult evaluate(IVariablePool pool) throws CoreException {
        Object element = pool.getDefaultVariable();
        if ("instanceof".equals(this.fProperty)) {
            return TestResult.valueOf(Expression.isInstanceOf(element, (String)this.fArgs[0]));
        }
        Method method = TypeExtension.getMethod(element, this.fProperty);
        if (!method.isLoaded()) {
            return TestResult.NOT_LOADED;
        }
        Object returnValue = method.invoke(element, this.fArgs);
        if (!(returnValue instanceof Boolean)) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, "Expected result must be of type Boolean", null));
        }
        return TestResult.valueOf((Boolean)returnValue);
    }

    public Object[] getArguments(IConfigurationElement element) {
        String arg;
        String args = element.getAttribute(ATT_ARGS);
        if (args == null) {
            String value = element.getAttribute("value");
            if (value != null) {
                return new Object[]{this.convertToken(value)};
            }
            return EMPTY_ARGS;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Tokenizer tokenizer = new Tokenizer(args);
        while ((arg = tokenizer.next()) != null) {
            result.add(this.convertToken(arg));
        }
        return result.toArray();
    }

    private Object convertToken(String arg) {
        Assert.isTrue(arg.length() > 0);
        if (arg.charAt(0) == '\'' && arg.charAt(arg.length() - 1) == '\'') {
            return arg.substring(1, arg.length() - 1);
        }
        if ("true".equals(arg)) {
            return Boolean.TRUE;
        }
        if ("false".equals(arg)) {
            return Boolean.FALSE;
        }
        if (arg.indexOf(46) != -1) {
            try {
                return Float.valueOf(arg);
            }
            catch (NumberFormatException numberFormatException) {
                return arg;
            }
        }
        try {
            return Integer.valueOf(arg);
        }
        catch (NumberFormatException numberFormatException) {
            return arg;
        }
    }

    public String toString() {
        StringBuffer args = new StringBuffer();
        int i = 0;
        while (i < this.fArgs.length) {
            Object arg = this.fArgs[i];
            if (arg instanceof String) {
                args.append('\'');
                args.append(arg);
                args.append('\'');
            } else {
                args.append(arg.toString());
            }
            if (i < this.fArgs.length - 1) {
                args.append(", ");
            }
            ++i;
        }
        return "<test property=\"" + this.fProperty + "\" args=\"" + args + "\"";
    }

    private static class Tokenizer {
        private String fString;
        private int fPosition;

        public Tokenizer(String s) {
            this.fString = s;
            this.fPosition = 0;
        }

        public String next() {
            String result;
            if (this.fPosition >= this.fString.length()) {
                return null;
            }
            int nextComma = this.getNextCommna();
            if (nextComma == -1) {
                result = this.fString.substring(this.fPosition, this.fString.length()).trim();
                this.fPosition = this.fString.length();
            } else {
                result = this.fString.substring(this.fPosition, nextComma).trim();
                this.fPosition = nextComma + 1;
            }
            return result;
        }

        private int getNextCommna() {
            boolean quoted = false;
            int i = this.fPosition;
            while (i < this.fString.length()) {
                char ch = this.fString.charAt(i);
                switch (ch) {
                    case '\'': {
                        quoted = !quoted;
                    }
                    case ',': {
                        if (quoted) break;
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }
    }
}

