/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.AdaptExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.AndExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.CountExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.EnablementExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionParser;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IterateExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.NotExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.OrExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.WithExpression;

public class StandardElementHandler
implements IElementHandler {
    private static final IElementHandler INSTANCE = new StandardElementHandler();

    public static IElementHandler getInstance() {
        return INSTANCE;
    }

    private StandardElementHandler() {
    }

    public Expression create(IConfigurationElement element, ExpressionParser creator) throws CoreException {
        String name = element.getName();
        if ("test".equals(name)) {
            return new TestExpression(element);
        }
        if (OrExpression.NAME.equals(name)) {
            OrExpression result = new OrExpression();
            creator.processChildren(result, element);
            return result;
        }
        if (AndExpression.NAME.equals(name)) {
            AndExpression result = new AndExpression();
            creator.processChildren(result, element);
            return result;
        }
        if ("not".equals(name)) {
            return new NotExpression(creator.parse(element.getChildren()[0]));
        }
        if ("with".equals(name)) {
            WithExpression result = new WithExpression(element);
            creator.processChildren(result, element);
            return result;
        }
        if ("adapt".equals(name)) {
            AdaptExpression result = new AdaptExpression(element);
            creator.processChildren(result, element);
            return result;
        }
        if ("iterate".equals(name)) {
            IterateExpression result = new IterateExpression(element);
            creator.processChildren(result, element);
            return result;
        }
        if ("count".equals(name)) {
            return new CountExpression(element);
        }
        if ("enablement".equals(name)) {
            EnablementExpression result = new EnablementExpression(element);
            creator.processChildren(result, element);
            return result;
        }
        return null;
    }
}

