/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtender;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class ResourceExtender
extends TypeExtender {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String CAN_DELETE = "canDelete";

    public Object invoke(Object receiver, String method, Object[] args) {
        IResource resource = (IResource)receiver;
        if (PROPERTY_MATCHES_PATTERN.equals(method)) {
            String fileName = resource.getName();
            StringMatcher matcher = new StringMatcher((String)args[0], false, false);
            return matcher.match(fileName);
        }
        if (PROJECT_NATURE.equals(method)) {
            try {
                IProject proj = resource.getProject();
                return proj.isAccessible() && proj.hasNature((String)args[0]);
            }
            catch (CoreException coreException) {
                return Boolean.FALSE;
            }
        }
        if (CAN_DELETE.equals(method)) {
            return this.canDelete(resource);
        }
        Assert.isTrue(false);
        return null;
    }

    private boolean canDelete(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }
}

