/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtender;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JavaTypeExtender
extends TypeExtender {
    private static final String PROPERTY_HAS_MAIN_TYPE = "hasMainType";
    private static final String IS_ANONYMOUES = "isAnonymous";
    private static final String IS_LOCAL = "isLocal";

    public Object invoke(Object receiver, String method, Object[] args) {
        IType type = (IType)receiver;
        if (PROPERTY_HAS_MAIN_TYPE.equals(method)) {
            try {
                return JavaModelUtil.hasMainMethod(type);
            }
            catch (JavaModelException javaModelException) {
                return Boolean.FALSE;
            }
        }
        if (IS_ANONYMOUES.equals(method)) {
            try {
                return type.isAnonymous();
            }
            catch (JavaModelException javaModelException) {
                return Boolean.FALSE;
            }
        }
        if (IS_LOCAL.equals(method)) {
            try {
                return type.isLocal();
            }
            catch (JavaModelException javaModelException) {
                return Boolean.FALSE;
            }
        }
        Assert.isTrue(false);
        return null;
    }
}

