/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TypeExtender;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;

public class JavaElementExtender
extends TypeExtender {
    private static final String PROPERTY_IS_AVAILABLE = "isAvailable";
    private static final String CAN_DELETE = "canDelete";

    public Object invoke(Object receiver, String method, Object[] args) throws CoreException {
        IJavaElement jElement = (IJavaElement)receiver;
        if (PROPERTY_IS_AVAILABLE.equals(method)) {
            return Checks.isAvailable(jElement);
        }
        if (CAN_DELETE.equals(method)) {
            return this.canDelete(jElement);
        }
        Assert.isTrue(false);
        return null;
    }

    private boolean canDelete(IJavaElement element) throws CoreException {
        IPackageFragmentRoot root;
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaModel || element instanceof IJavaProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot && ((root = (IPackageFragmentRoot)element).isExternal() || Checks.isClasspathDelete(root))) {
            return false;
        }
        if (element instanceof IPackageFragment && JavaElementExtender.isEmptySuperPackage((IPackageFragment)element)) {
            return false;
        }
        if (JavaElementExtender.isFromExternalArchive(element)) {
            return false;
        }
        if (element instanceof IMember && ((IMember)element).isBinary()) {
            return false;
        }
        return !ReorgUtils.isDeletedFromEditor(element);
    }

    private static boolean isFromExternalArchive(IJavaElement element) {
        return element.getResource() == null && !JavaElementExtender.isWorkingCopyElement(element);
    }

    private static boolean isWorkingCopyElement(IJavaElement element) {
        if (element instanceof IWorkingCopy) {
            return ((IWorkingCopy)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private static boolean isEmptySuperPackage(IPackageFragment pack) throws JavaModelException {
        return pack.hasSubpackages() && pack.getNonJavaResources().length == 0 && pack.getChildren().length == 0;
    }
}

