/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.CompositeExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.DefaultVariable;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expressions;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public class IterateExpression
extends CompositeExpression {
    public static final String NAME = "iterate";
    private static final String ATT_OPERATOR = "operator";
    private static final int OR = 1;
    private static final int AND = 2;
    private int fOperator;

    public IterateExpression(IConfigurationElement configElement) throws CoreException {
        String opValue = configElement.getAttribute(ATT_OPERATOR);
        if (opValue == null) {
            this.fOperator = 2;
        } else {
            this.checkAttribute(ATT_OPERATOR, opValue, new String[]{"and", "or"});
            this.fOperator = "and".equals(opValue) ? 2 : 1;
        }
    }

    public TestResult evaluate(IVariablePool pool) throws CoreException {
        Object var = pool.getDefaultVariable();
        Expressions.checkCollection(var);
        Collection col = (Collection)var;
        switch (col.size()) {
            case 0: {
                return this.fOperator == 2 ? TestResult.TRUE : TestResult.FALSE;
            }
            case 1: {
                if (!(col instanceof List)) break;
                return this.evaluateAnd(new DefaultVariable(pool, ((List)col).get(0)));
            }
        }
        IteratePool iter = new IteratePool(pool, col.iterator());
        TestResult result = this.fOperator == 2 ? TestResult.TRUE : TestResult.FALSE;
        while (iter.hasNext()) {
            iter.next();
            switch (this.fOperator) {
                case 1: {
                    result = result.or(this.evaluateAnd(iter));
                    if (result != TestResult.TRUE) break;
                    return result;
                }
                case 2: {
                    result = result.and(this.evaluateAnd(iter));
                    if (result == TestResult.TRUE) break;
                    return result;
                }
            }
        }
        return result;
    }

    private static class IteratePool
    implements IVariablePool {
        private Iterator fIterator;
        private Object fDefaultVariable;
        private IVariablePool fParent;

        public IteratePool(IVariablePool parent, Iterator iterator) {
            Assert.isNotNull(parent);
            Assert.isNotNull(iterator);
            this.fParent = parent;
            this.fIterator = iterator;
        }

        public IVariablePool getParent() {
            return this.fParent;
        }

        public IVariablePool getRoot() {
            return this.fParent.getRoot();
        }

        public Object getDefaultVariable() {
            return this.fDefaultVariable;
        }

        public void addVariable(String name, Object value) {
            this.fParent.addVariable(name, value);
        }

        public Object removeVariable(String name) {
            return this.fParent.removeVariable(name);
        }

        public Object getVariable(String name) {
            return this.fParent.getVariable(name);
        }

        public Object resolveVariable(String name, Object[] args) throws CoreException {
            return this.fParent.resolveVariable(name, args);
        }

        public Object next() {
            this.fDefaultVariable = this.fIterator.next();
            return this.fDefaultVariable;
        }

        public boolean hasNext() {
            return this.fIterator.hasNext();
        }
    }
}

