/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.CompositeExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.StandardElementHandler;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ExpressionParser {
    private IElementHandler[] fHandlers;
    private static final ExpressionParser INSTANCE = new ExpressionParser(new IElementHandler[]{StandardElementHandler.getInstance()});

    public static ExpressionParser getStandard() {
        return INSTANCE;
    }

    public ExpressionParser(IElementHandler[] handlers) {
        Assert.isNotNull(handlers);
        this.fHandlers = handlers;
    }

    public Expression parse(IConfigurationElement element) throws CoreException {
        int i = 0;
        while (i < this.fHandlers.length) {
            IElementHandler handler = this.fHandlers[i];
            Expression result = handler.create(element, this);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public void processChildren(CompositeExpression result, IConfigurationElement element) throws CoreException {
        IConfigurationElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Expression child = this.parse(children[i]);
                if (child == null) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, "Unknown expression element", null));
                }
                result.add(child);
                ++i;
            }
        }
    }
}

