/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public abstract class Expression {
    protected static final String ATT_VALUE = "value";
    public static final Expression TRUE = new Expression(){

        public TestResult evaluate(IVariablePool pool) throws CoreException {
            return TestResult.TRUE;
        }
    };
    public static final Expression FALSE = new Expression(){

        public TestResult evaluate(IVariablePool pool) throws CoreException {
            return TestResult.FALSE;
        }
    };

    public abstract TestResult evaluate(IVariablePool var1) throws CoreException;

    protected void checkAttribute(String name, String value) throws CoreException {
        if (value == null) {
            throw new CoreException((IStatus)new ExpressionStatus(4, 50, "Missing attribute " + name));
        }
    }

    protected void checkAttribute(String name, String value, String[] validValues) throws CoreException {
        this.checkAttribute(name, value);
        int i = 0;
        while (i < validValues.length) {
            if (value.equals(validValues[i])) {
                return;
            }
            ++i;
        }
        throw new CoreException((IStatus)new ExpressionStatus(4, 51, "Wrong attribute value"));
    }

    protected static boolean isInstanceOf(Object element, String type) {
        if (element == null) {
            return false;
        }
        return Expression.isSubtype(element.getClass(), type);
    }

    private static boolean isSubtype(Class clazz, String type) {
        if (clazz.getName().equals(type)) {
            return true;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && Expression.isSubtype(superClass, type)) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (Expression.isSubtype(interfaces[i], type)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

