/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expressions;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public class CountExpression
extends Expression {
    public static final String NAME = "count";
    private static final int ANY_NUMBER = 5;
    private static final int EXACT = 4;
    private static final int ONE_OR_MORE = 3;
    private static final int NONE_OR_ONE = 2;
    private static final int NONE = 1;
    private static final int UNKNOWN = 0;
    private int fMode;
    private int fSize;

    public CountExpression(IConfigurationElement configElement) {
        String size = configElement.getAttribute("value");
        if (size == null) {
            size = "*";
        }
        if (size.equals("*")) {
            this.fMode = 5;
        } else if (size.equals("?")) {
            this.fMode = 2;
        } else if (size.equals("!")) {
            this.fMode = 1;
        } else if (size.equals("+")) {
            this.fMode = 3;
        } else {
            try {
                this.fSize = Integer.parseInt(size);
                this.fMode = 4;
            }
            catch (NumberFormatException numberFormatException) {
                this.fMode = 0;
            }
        }
    }

    public TestResult evaluate(IVariablePool pool) throws CoreException {
        Object var = pool.getDefaultVariable();
        Expressions.checkCollection(var);
        Collection collection = (Collection)var;
        int size = collection.size();
        switch (this.fMode) {
            case 0: {
                return TestResult.FALSE;
            }
            case 1: {
                return TestResult.valueOf(size == 0);
            }
            case 3: {
                return TestResult.valueOf(size >= 1);
            }
            case 4: {
                return TestResult.valueOf(this.fSize == size);
            }
            case 5: {
                return TestResult.TRUE;
            }
        }
        return TestResult.FALSE;
    }
}

