/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public abstract class CompositeExpression
extends Expression {
    private static final Expression[] EMPTY_ARRAY = new Expression[0];
    protected List fExpressions;

    public void add(Expression expression) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(2);
        }
        this.fExpressions.add(expression);
    }

    public Expression[] getChildren() {
        if (this.fExpressions == null) {
            return EMPTY_ARRAY;
        }
        return this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    protected TestResult evaluateAnd(IVariablePool scope) throws CoreException {
        if (this.fExpressions == null) {
            return TestResult.TRUE;
        }
        TestResult result = TestResult.TRUE;
        Iterator iter = this.fExpressions.iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            if ((result = result.and(expression.evaluate(scope))) != TestResult.FALSE) continue;
            return result;
        }
        return result;
    }

    protected TestResult evaluateOr(IVariablePool scope) throws CoreException {
        if (this.fExpressions == null) {
            return TestResult.TRUE;
        }
        TestResult result = TestResult.FALSE;
        Iterator iter = this.fExpressions.iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            if ((result = result.or(expression.evaluate(scope))) != TestResult.TRUE) continue;
            return result;
        }
        return result;
    }
}

