/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.CompositeExpression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.DefaultVariable;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public class AdaptExpression
extends CompositeExpression {
    public static final String NAME = "adapt";
    private static final String ATT_TYPE = "type";
    private String fTypeName;
    private Class fType;
    private IPluginDescriptor fPluginDescriptor;

    public AdaptExpression(IConfigurationElement configElement) throws CoreException {
        this.fTypeName = configElement.getAttribute(ATT_TYPE);
        this.checkAttribute(ATT_TYPE, this.fTypeName);
        this.fPluginDescriptor = configElement.getDeclaringExtension().getDeclaringPluginDescriptor();
    }

    public TestResult evaluate(IVariablePool pool) throws CoreException {
        Object adapted;
        if (this.fTypeName == null) {
            return TestResult.FALSE;
        }
        Object var = pool.getDefaultVariable();
        if (!(var instanceof IAdaptable)) {
            return TestResult.FALSE;
        }
        if (this.fType == null) {
            ClassLoader loader = this.fPluginDescriptor.getPluginClassLoader();
            try {
                this.fType = loader.loadClass(this.fTypeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fTypeName = null;
                return TestResult.FALSE;
            }
        }
        if ((adapted = ((IAdaptable)var).getAdapter(this.fType)) == null) {
            return TestResult.FALSE;
        }
        return this.evaluateAnd(new DefaultVariable(pool, adapted));
    }
}

