/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.participants.CopyExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.CreateExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.ICopyParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.ICreateParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IDeleteParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IMoveParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.IResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.participants.MoveExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.SharableParticipants;

public class ResourceModifications
implements IResourceModifications {
    private List fCreate;
    private List fDelete;
    private List fMove;
    private IContainer fMoveTarget;
    private List fCopy;
    private IContainer fCopyTarget;
    private IResource fRename;
    private String fNewName;

    public List getCreate() {
        return this.fCreate;
    }

    public void addCreate(IResource create) {
        if (this.fCreate == null) {
            this.fCreate = new ArrayList(2);
        }
        this.fCreate.add(create);
    }

    public List getDelete() {
        return this.fDelete;
    }

    public void addDelete(IResource delete) {
        if (this.fDelete == null) {
            this.fDelete = new ArrayList(2);
        }
        this.fDelete.add(delete);
    }

    public List getCopy() {
        return this.fCopy;
    }

    public IContainer getCopyTarget() {
        return this.fCopyTarget;
    }

    public void addCopy(IResource copy) {
        if (this.fCopy == null) {
            this.fCopy = new ArrayList(2);
        }
        this.fCopy.add(copy);
    }

    public void setCopyTarget(IContainer target) {
        this.fCopyTarget = target;
    }

    public List getMove() {
        return this.fMove;
    }

    public IContainer getMoveTarget() {
        return this.fMoveTarget;
    }

    public void addMove(IResource move) {
        if (this.fMove == null) {
            this.fMove = new ArrayList(2);
        }
        this.fMove.add(move);
    }

    public void setMoveTarget(IContainer target) {
        this.fMoveTarget = target;
    }

    public IResource getRename() {
        return this.fRename;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setRename(IResource rename, String newName) {
        this.fRename = rename;
        this.fNewName = newName;
    }

    public IRefactoringParticipant[] getParticipants(IRefactoringProcessor processor, SharableParticipants shared) throws CoreException {
        int i;
        ArrayList<IRefactoringParticipant> result = new ArrayList<IRefactoringParticipant>(5);
        if (this.fDelete != null) {
            IDeleteParticipant[] deletes = DeleteExtensionManager.getParticipants(processor, this.fDelete.toArray(), shared);
            result.addAll(Arrays.asList(deletes));
        }
        if (this.fCreate != null) {
            ICreateParticipant[] creates = CreateExtensionManager.getParticipants(processor, this.fCreate.toArray());
            result.addAll(Arrays.asList(creates));
        }
        if (this.fMove != null) {
            IMoveParticipant[] moves = MoveExtensionManager.getParticipants(processor, this.fMove.toArray());
            i = 0;
            while (i < moves.length) {
                moves[i].setTarget(this.fMoveTarget);
                ++i;
            }
            result.addAll(Arrays.asList(moves));
        }
        if (this.fCopy != null) {
            ICopyParticipant[] copies = CopyExtensionManager.getParticipants(processor, this.fMove.toArray());
            i = 0;
            while (i < copies.length) {
                copies[i].setTarget(this.fCopyTarget);
                ++i;
            }
            result.addAll(Arrays.asList(copies));
        }
        return result.toArray(new IRefactoringParticipant[result.size()]);
    }
}

